/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.triangle;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.gaussianelimination.GaussianElimination4SquareMatrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.triangle.Doolittle;
import com.numericalmethod.suanshu.matrix.doubles.factorization.triangle.LUDecomposition;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.PermutationMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;

public class LU
implements LUDecomposition {
    private final LUDecomposition E;

    @Override
    public UpperTriangularMatrix U() {
        return this.E.U();
    }

    public LU(Matrix A, Method method, double epsilon) {
        switch (method) {
            case GAUSSIAN_ELIMINATION: {
                do {
                } while (false);
                this.E = new GaussianElimination4SquareMatrix(A, epsilon);
                break;
            }
            default: {
                this.E = new Doolittle(A, true, epsilon);
            }
        }
    }

    @Override
    public PermutationMatrix P() {
        return this.E.P();
    }

    @Override
    public LowerTriangularMatrix L() {
        return this.E.L();
    }

    public LU(Matrix A) {
        this(A, Method.DOOLITTLE, SuanShuUtils.autoEpsilon(A));
    }

    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method DOOLITTLE = new Method();
        private static final /* synthetic */ Method[] E;
        public static final /* enum */ Method GAUSSIAN_ELIMINATION = new Method();

        public static Method[] values() {
            return (Method[])E.clone();
        }

        static {
            Method[] methodArray = new Method[2];
            methodArray[0] = DOOLITTLE;
            methodArray[1] = GAUSSIAN_ELIMINATION;
            E = methodArray;
        }

        private Method() {
            Method a2;
        }

        public static Method valueOf(String name) {
            return Enum.valueOf(Method.class, name);
        }
    }
}

