/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.svd;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.svd.GloubKahanSVD;
import com.numericalmethod.suanshu.matrix.doubles.factorization.svd.SVDDecomposition;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;

public class SVD
implements SVDDecomposition {
    private boolean G;
    private final Matrix F;
    private SVDDecomposition k;
    public final double epsilon;
    private final Method L;
    private final boolean E;

    @Override
    public double[] getSingularValues() {
        return this.k.getSingularValues();
    }

    @Override
    public Matrix U() {
        Matrix a2 = this.G ? this.k.V() : this.k.U();
        return a2;
    }

    public SVD(Matrix A, boolean doUV) {
        this(A, doUV, Method.GLOUB_KAHAN, SuanShuUtils.autoEpsilon(A));
    }

    @Override
    public Matrix V() {
        Matrix a2 = this.G ? this.k.U() : this.k.V();
        return a2;
    }

    public SVD(Matrix A, boolean doUV, Method method, double epsilon) {
        this.F = A;
        this.E = doUV;
        this.L = method;
        this.epsilon = epsilon;
        this.G = DimensionCheck.isFat(A);
        switch (method) {
            default: 
        }
        this.k = new GloubKahanSVD(this.G ? this.F.t() : this.F, this.E, true, epsilon);
    }

    @Override
    public DiagonalMatrix D() {
        return this.k.D();
    }

    @Override
    public Matrix Ut() {
        return this.U().t();
    }

    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method GLOUB_KAHAN = new Method();
        private static final /* synthetic */ Method[] E;

        private Method() {
            Method a2;
        }

        public static Method valueOf(String name) {
            return Enum.valueOf(Method.class, name);
        }

        public static Method[] values() {
            return (Method[])E.clone();
        }

        static {
            Method[] methodArray = new Method[1];
            methodArray[0] = GLOUB_KAHAN;
            E = methodArray;
        }
    }
}

