/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.qr;

import com.numericalmethod.suanshu.datastructure.list.VectorList;
import com.numericalmethod.suanshu.matrix.doubles.IsMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.qr.QRDecomposition;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.PermutationMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.Basis;
import com.numericalmethod.suanshu.vector.doubles.operation.Projection;

public class GramSchmidt
implements QRDecomposition {
    private int G;
    private Matrix F;
    public final double epsilon;
    private PermutationMatrix k;
    public final int ncols;
    public final int nrows;
    private UpperTriangularMatrix L;
    private final DenseVector E;

    public GramSchmidt(Matrix A) {
        this(A, true, SuanShuUtils.autoEpsilon(A));
    }

    @Override
    public Matrix Q() {
        return this.F.deepCopy();
    }

    @Override
    public PermutationMatrix P() {
        return new PermutationMatrix(this.k);
    }

    @Override
    public Matrix squareQ() {
        int a2;
        if (this.F.nRows() == this.G) {
            if (this.F.nCols() <= this.F.nRows()) {
                return this.Q();
            }
            DenseMatrix a3 = CreateMatrix.subMatrix(this.F, 1, this.nrows, 1, this.nrows);
            return a3;
        }
        if (this.F.nCols() > this.F.nRows()) {
            DenseMatrix a4 = CreateMatrix.subMatrix(this.F, 1, this.nrows, 1, this.nrows);
            return a4;
        }
        VectorList a5 = new VectorList();
        int n = a2 = 1;
        while (n <= this.G) {
            a5.add(this.F.getColumn(a2));
            n = ++a2;
        }
        VectorList a22 = Basis.getBasis(this.nrows, this.nrows);
        a5.addAll(a22);
        DenseMatrix a6 = CreateMatrix.cbind(a5);
        Matrix a7 = new GramSchmidt(a6, false, this.epsilon).Q();
        a7 = CreateMatrix.subMatrix(a7, 1, this.nrows, 1, this.nrows);
        return a7;
    }

    public GramSchmidt(Matrix A, boolean pad0Cols, double epsilon) {
        int a2;
        this.nrows = A.nRows();
        this.ncols = A.nCols();
        this.L = new UpperTriangularMatrix(this.ncols);
        this.L.set(1, 1, 0.0);
        this.k = new PermutationMatrix(this.ncols);
        this.G = 0;
        this.E = new DenseVector(this.nrows);
        Vector[] vectorArray = new Vector[this.ncols];
        Vector[] a3 = vectorArray;
        vectorArray[0] = new DenseVector(this.nrows);
        int n = a2 = 1;
        while (n <= this.ncols) {
            int a4;
            Vector a5 = A.getColumn(a2);
            int n2 = a4 = 1;
            while (true) {
                int a6;
                if (n2 > 2) break;
                int n3 = a6 = 1;
                while (true) {
                    if (n3 > a2 - 1) break;
                    if (a3[a6 - 1] != null) {
                        Projection a7 = new Projection(a5, a3[a6 - 1]);
                        a5 = a7.orthogonalVector;
                        this.L.set(a6, a2, a7.length[0] + this.L.get(a6, a2));
                    }
                    n3 = ++a6;
                }
                n2 = ++a4;
            }
            if (!IsMatrix.zero(a5, epsilon)) {
                double a8 = a5.norm();
                this.L.set(a2, a2, a8);
                a3[a2 - 1] = a5.scaled(1.0 / a8);
                ++this.G;
            } else {
                if (pad0Cols) {
                    a3[a2 - 1] = this.E;
                }
                this.L.set(a2, a2, 0.0);
                this.k.moveColumn2End(a2);
            }
            n = ++a2;
        }
        this.F = CreateMatrix.cbind(a3);
        this.epsilon = epsilon;
    }

    @Override
    public Matrix tallR() {
        UpperTriangularMatrix a2 = this.R();
        if (this.nrows < this.ncols) {
            return CreateMatrix.subMatrix(a2, 1, this.nrows, 1, this.ncols);
        }
        DenseMatrix a3 = new DenseMatrix(this.nrows, this.ncols).ZERO();
        CreateMatrix.replace(a3, 1, Math.min(this.ncols, this.nrows), 1, this.ncols, a2);
        return a3;
    }

    @Override
    public UpperTriangularMatrix R() {
        return new UpperTriangularMatrix(this.L);
    }

    @Override
    public int rank() {
        return this.G;
    }
}

