/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.gaussianelimination;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.PermutationMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.ElementaryOperation;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class GaussianElimination {
    private final boolean M;
    private final int i;
    private ElementaryOperation G;
    public final double epsilon;
    private ElementaryOperation F;
    private PermutationMatrix k;
    private final int L;
    private Matrix E;

    public Matrix U() {
        return this.F.T();
    }

    public Matrix L() {
        return this.E.deepCopy();
    }

    private void b(int a2, int a3) {
        int a4;
        GaussianElimination a5;
        Vector a6 = a5.E.getRow(a2);
        int n = a4 = 1;
        while (n < a2) {
            a5.E.set(a2, a4, a5.E.get(a3, a4));
            a5.E.set(a3, a4, a6.get(a4));
            n = ++a4;
        }
    }

    public Matrix T() {
        return this.G.T();
    }

    public GaussianElimination(Matrix A, boolean usePivoting, double epsilon) {
        this.i = A.nRows();
        this.L = A.nCols();
        this.M = usePivoting;
        this.epsilon = epsilon;
        this.G = new ElementaryOperation(this.i, this.i);
        this.F = new ElementaryOperation(A);
        this.E = new DenseMatrix(this.i, this.i).ONE();
        this.k = new PermutationMatrix(this.i);
        this.b();
    }

    public GaussianElimination(Matrix A) {
        this(A, true, SuanShuUtils.autoEpsilon(A));
    }

    public PermutationMatrix P() {
        return new PermutationMatrix(this.k);
    }

    private void b() {
        GaussianElimination a2;
        int a3 = 1;
        int n = a3;
        GaussianElimination gaussianElimination = a2;
        for (int a4 = 1; n <= gaussianElimination.i && a4 <= a2.L; ++a4) {
            int a5;
            int a6 = a3;
            if (a2.M) {
                int n2 = a3 + 1;
                while (n2 <= a2.i) {
                    if (Math.abs(a2.F.T().get(a5, a4)) > Math.abs(a2.F.T().get(a6, a4))) {
                        a6 = a5;
                    }
                    n2 = ++a5;
                }
            }
            if (DoubleUtils.compare(a2.F.T().get(a6, a4), 0.0, a2.epsilon) != 0) {
                if (a3 != a6) {
                    a2.F.swapRow(a3, a6);
                    a2.G.swapRow(a3, a6);
                    a2.k.swapRow(a3, a6);
                    a2.b(a3, a6);
                }
                int n3 = a3 + 1;
                while (n3 <= a2.i) {
                    double a7 = a2.F.T().get(a5, a4) / a2.F.T().get(a3, a4);
                    a2.F.addRow(a5, a3, -a7);
                    a2.G.addRow(a5, a3, -a7);
                    a2.E.set(a5, a4, a7);
                    n3 = ++a5;
                }
            }
            n = ++a3;
            gaussianElimination = a2;
        }
    }
}

