/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.qr;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.qr.Hessenberg;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Householder;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;

public class HessenbergDecomposition {
    private volatile Matrix F = null;
    private Matrix k;
    private final int L;
    private Householder[] E;

    public Matrix Q() {
        if (this.F == null) {
            int a2;
            int n = a2 = 1;
            while (true) {
                if (n > this.L - 2) break;
                Vector a3 = this.E[a2].generator();
                Vector[] vectorArray = new Vector[2];
                vectorArray[0] = new DenseVector(a2);
                vectorArray[1] = a3;
                a3 = CreateVector.concat(vectorArray);
                this.E[a2] = new Householder(a3);
                n = ++a2;
            }
            this.F = Householder.product(this.E, 1, this.L - 2, this.L, this.L);
        }
        return this.F.deepCopy();
    }

    public HessenbergDecomposition(Matrix A) {
        int a2;
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(A), "Hessenberg Reduction applies only to square matrices", new Object[0]);
        this.L = A.nRows();
        if (Hessenberg.isHessenberg(A, 0.0)) {
            this.k = A.deepCopy();
            this.F = A.ONE();
            return;
        }
        this.k = A.deepCopy();
        this.E = new Householder[this.L - 1];
        int n = a2 = 1;
        while (true) {
            if (n > this.L - 2) break;
            Householder.Context a3 = Householder.getContext(CreateVector.subVector(this.k.getColumn(a2), a2 + 1, this.L));
            this.E[a2] = new Householder(a3.generator);
            DenseMatrix a4 = CreateMatrix.subMatrix(this.k, a2 + 1, this.L, a2, this.L);
            Matrix a5 = this.E[a2].reflect(a4);
            CreateMatrix.replace(this.k, a2 + 1, this.L, a2, this.L, a5);
            DenseMatrix a6 = CreateMatrix.subMatrix(this.k, 1, this.L, a2 + 1, this.L);
            Matrix a7 = this.E[a2].reflectRows(a6);
            CreateMatrix.replace(this.k, 1, this.L, a2 + 1, this.L, a7);
            n = ++a2;
        }
    }

    public Matrix H() {
        return this.k.deepCopy();
    }
}

