/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.qr;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixMeasure;
import com.numericalmethod.suanshu.number.DoubleUtils;
import java.util.ArrayList;

public class Hessenberg {
    public final DeflationCriterion deflationCriterion;

    public static boolean isHessenberg(Matrix H, double epsilon) {
        int a2;
        boolean a3 = true;
        int a4 = H.nCols();
        int a5 = H.nRows();
        int n = a2 = 1;
        while (n <= a4) {
            int n2 = a2 + 2;
            while (n2 <= a5) {
                int a6;
                if (DoubleUtils.compare(H.get(a6, a2), 0.0, epsilon) != 0) {
                    return false;
                }
                n2 = ++a6;
            }
            n = ++a2;
        }
        return a3;
    }

    public Deflation backSearch(Matrix H, int n, double epsilon) {
        int a2 = n;
        int a3 = n;
        int n2 = a2;
        block0: while (true) {
            int n3 = 1;
            while (n2 >= n3) {
                block8: {
                    block7: {
                        if (a2 == 1) break block7;
                        if (!this.deflationCriterion.isNegligible(H, a2, a2 - 1, epsilon)) break block8;
                    }
                    if (a3 != 2) {
                        if (a2 > 1) {
                            H.set(a2 - 1, a2, 0.0);
                        }
                    }
                    if (a2 != a3 - 1 && a2 != a3) break block0;
                    a3 = --a2;
                    n2 = a2;
                    continue block0;
                }
                n2 = --a2;
                n3 = 1;
            }
            break;
        }
        return new Deflation(a2, a3);
    }

    @Deprecated
    public ArrayList<Matrix> reduce(Matrix H) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Hessenberg() {
        this.deflationCriterion = new DefaultDeflationCriterion();
    }

    public boolean isReducible(Matrix H, double epsilon) {
        int a2;
        Matrix a3 = H.deepCopy();
        boolean a4 = !Hessenberg.isHessenberg(H, epsilon);
        int n = a2 = 2;
        Matrix matrix = a3;
        while (n <= matrix.nRows() && !a4) {
            if (this.deflationCriterion.isNegligible(a3, a2, a2 - 1, epsilon)) {
                a4 = true;
            }
            n = ++a2;
            matrix = a3;
        }
        return a4;
    }

    public Hessenberg(DeflationCriterion dc) {
        this.deflationCriterion = dc;
    }

    public static class DefaultDeflationCriterion
    implements DeflationCriterion {
        private double E = 1.0E-12;

        @Override
        public boolean isNegligible(Matrix H, int row, int col, double epsilon) {
            boolean a2 = false;
            double a3 = H.get(row, col);
            double a4 = H.get(row - 1, col);
            double a5 = H.get(row, col + 1);
            double a6 = Math.abs(a4) + Math.abs(a5);
            if (DoubleUtils.equal(a6, 0.0, epsilon)) {
                if (DoubleUtils.compare(Math.abs(a3), this.E * MatrixMeasure.Frobenius(H), epsilon) <= 0) {
                    a2 = true;
                }
            } else if (DoubleUtils.compare(Math.abs(a3), this.E * a6, epsilon) <= 0) {
                a2 = true;
            }
            return a2;
        }

        public double getTolerance() {
            return this.E;
        }

        public void setTolerance(double tol) {
            this.E = tol;
        }
    }

    public static class Deflation {
        public final int ul;
        public final boolean isQuasiTriangular;
        public final int lr;

        public Deflation(int a2, int a3) {
            Deflation a4;
            a4.ul = a2;
            a4.lr = a3;
            a4.isQuasiTriangular = a2 == 0 && a3 == 0;
        }
    }

    public static interface DeflationCriterion {
        public boolean isNegligible(Matrix var1, int var2, int var3, double var4);
    }
}

