/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.qr;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Householder;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixMeasure;
import com.numericalmethod.suanshu.number.DoubleArrayMath;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;
import java.util.ArrayList;
import java.util.Iterator;

public class FrancisQRStep {
    private final Matrix G;
    private final int F;
    private final int k;
    private ArrayList<Householder> L = new ArrayList();
    private final Matrix E;

    public Matrix ZtHZ() {
        FrancisQRStep a2;
        return a2.E.deepCopy();
    }

    public Matrix Z() {
        FrancisQRStep a2;
        ArrayList<Householder> a3 = a2.getHouseholderTransformations();
        Householder[] a4 = new Householder[a3.size()];
        a4 = a3.toArray(a4);
        return Householder.product(a4, 0, a4.length - 1);
    }

    public DenseVector col1() {
        FrancisQRStep a2;
        double a3 = a2.G.get(1, 1);
        double a4 = a2.G.get(1, 2);
        double a5 = a2.G.get(2, 1);
        double a6 = a2.G.get(2, 2);
        double a7 = a2.G.get(3, 2);
        double a8 = a2.G.get(a2.F, a2.F);
        double a9 = a2.G.get(a2.F, a2.k);
        double a10 = a2.G.get(a2.k, a2.F);
        double a11 = a2.G.get(a2.k, a2.k);
        double[] dArray = new double[9];
        dArray[0] = Math.abs(a3);
        dArray[1] = Math.abs(a4);
        dArray[2] = Math.abs(a5);
        dArray[3] = Math.abs(a6);
        dArray[4] = Math.abs(a7);
        dArray[5] = Math.abs(a8);
        dArray[6] = Math.abs(a9);
        dArray[7] = Math.abs(a10);
        dArray[8] = Math.abs(a11);
        double a12 = DoubleArrayMath.max(dArray);
        a12 = 1.0 / a12;
        a3 = a12 * a3;
        a4 = a12 * a4;
        a5 = a12 * a5;
        a6 = a12 * a6;
        a7 = a12 * a7;
        a8 = a12 * a8;
        a9 = a12 * a9;
        a10 = a12 * a10;
        a11 = a12 * a11;
        double a13 = a11 - a3;
        double a14 = a8 - a3;
        double a15 = a6 - a3;
        DenseVector a16 = new DenseVector(3);
        a16.set(1, (a13 * a14 - a10 * a9) / a5 + a4);
        a16.set(2, a15 - a13 - a14);
        a16.set(3, a7);
        return a16;
    }

    private Matrix b() {
        int a2;
        FrancisQRStep a3;
        DenseMatrix a4 = new DenseMatrix(a3.G);
        Vector a5 = a3.col1();
        int n = a2 = 1;
        while (true) {
            if (n > a3.k - 1) break;
            Householder.Context a6 = Householder.getContext(a5);
            Householder a7 = new Householder(a6.generator);
            a3.L.add(a7);
            DenseMatrix a8 = CreateMatrix.subMatrix(a4, a2, Math.min(a2 + 2, a3.k), Math.max(a2 - 1, 1), a3.k);
            Matrix a9 = a7.reflect(a8);
            CreateMatrix.replace(a4, a2, Math.min(a2 + 2, a3.k), Math.max(a2 - 1, 1), a3.k, a9);
            a8 = CreateMatrix.subMatrix(a4, 1, Math.min(a2 + 3, a3.k), a2, Math.min(a2 + 2, a3.k));
            a9 = a7.reflectRows(a8);
            CreateMatrix.replace(a4, 1, Math.min(a2 + 3, a3.k), a2, Math.min(a2 + 2, a3.k), a9);
            if (a2 < a3.k - 1) {
                a5.set(1, a4.get(a2 + 1, a2));
                a5.set(2, a4.get(a2 + 2, a2));
                if (a2 <= a3.k - 3) {
                    a5.set(3, a4.get(a2 + 3, a2));
                } else {
                    a5 = CreateVector.subVector(a5, 1, 2);
                }
            }
            n = ++a2;
        }
        return a4;
    }

    public ArrayList<Householder> getHouseholderTransformations() {
        FrancisQRStep a2;
        Iterator<Householder> a3;
        ArrayList<Householder> a4 = new ArrayList<Householder>();
        int a5 = 0;
        Iterator<Householder> iterator = a3 = a2.L.iterator();
        while (iterator.hasNext()) {
            Vector a6 = a3.next().generator();
            int a7 = a2.k - a6.size() - a5;
            Vector[] vectorArray = new Vector[3];
            vectorArray[0] = new DenseVector(a5);
            vectorArray[1] = a6;
            vectorArray[2] = new DenseVector(a7);
            Vector a8 = CreateVector.concat(vectorArray);
            a4.add(new Householder(a8));
            ++a5;
            iterator = a3;
        }
        return a4;
    }

    public FrancisQRStep(Matrix a2) {
        FrancisQRStep a3;
        a3.G = a2;
        a3.k = a2.nRows();
        a3.F = a3.k - 1;
        a3.E = a3.b();
    }

    public Matrix M() {
        FrancisQRStep a2;
        DenseMatrix a3 = CreateMatrix.subMatrix(a2.G, a2.F, a2.k, a2.F, a2.k);
        double a4 = MatrixMeasure.tr(a3);
        double a5 = MatrixMeasure.det(a3);
        return a2.G.multiply(a2.G).minus(a2.G.scaled(a4)).add(a2.G.ONE().scaled(a5));
    }
}

