/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.eigen;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixMeasure;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class InverseIteration {
    private Matrix F;
    private double k;
    private Matrix L;
    private StoppingCriterion E;

    public InverseIteration(Matrix A, double lambda) {
        this(A, lambda, new GolubLoan(A, lambda, null));
    }

    public Vector getEigenVector() {
        return this.getEigenVector(new DenseVector(this.F.nRows(), 1.0), 10);
    }

    public InverseIteration(Matrix A, double lambda, StoppingCriterion criterion) {
        this.F = A;
        this.k = lambda;
        this.E = criterion;
        Matrix a2 = A.minus(A.ONE().scaled(lambda));
        this.L = new Inverse(a2, 0.0);
    }

    public Vector getEigenVector(Vector v0, int maxIterations) {
        int a2;
        Vector a3 = v0;
        int n = a2 = 0;
        while (n < maxIterations) {
            Vector a4 = this.L.multiply(a3);
            a3 = a4 = a4.scaled(1.0 / a4.norm());
            if (this.E.toStop(a3)) break;
            n = ++a2;
        }
        return new ImmutableVector(a3);
    }

    public static class 1 {
    }

    private static class GolubLoan
    implements StoppingCriterion {
        private double k;
        private Matrix L;
        private double E = Constant.unitRoundOff();

        private GolubLoan(Matrix a2, double a3) {
            GolubLoan a4;
            a4.L = a2;
            a4.k = a3;
        }

        public /* synthetic */ GolubLoan(Matrix a2, double a3, 1 a4) {
            a5(a2, a3);
            GolubLoan a5;
        }

        @Override
        public boolean toStop(Vector vk) {
            double a2;
            Vector a3 = this.L.minus(this.L.ONE().scaled(this.k)).multiply(vk);
            double a4 = a3.norm(Integer.MAX_VALUE);
            return a4 <= this.E * (a2 = MatrixMeasure.max(this.L));
        }
    }

    public static interface StoppingCriterion {
        public boolean toStop(Vector var1);
    }
}

