/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.eigen;

import com.numericalmethod.suanshu.datastructure.list.VectorList;
import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.Eigen;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;

public class EigenDecomposition {
    private int L;
    private Eigen E;

    public Matrix Q() {
        int a2;
        VectorList a3 = new VectorList();
        int n = a2 = 0;
        while (n < this.E.size()) {
            Eigen.Property a4 = this.E.getProperty(a2);
            a3.addAll(a4.eigenbasis());
            n = ++a2;
        }
        return CreateMatrix.cbind(a3);
    }

    public EigenDecomposition(Matrix A) {
        this(A, 1000.0 * SuanShuUtils.autoEpsilon(A));
    }

    public EigenDecomposition(Matrix A, double epsilon) {
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(A), "eigen decomposition applies only to square matrices", new Object[0]);
        this.L = A.nRows();
        this.E = new Eigen(A, Eigen.Method.QR, epsilon);
    }

    public DiagonalMatrix D() {
        int a2;
        double[] a3 = new double[this.L];
        int a4 = 0;
        int n = a2 = 0;
        while (n < this.E.size()) {
            int a5;
            Eigen.Property a6 = this.E.getProperty(a2);
            int n2 = a5 = 0;
            while (n2 < a6.algebraicMultiplicity()) {
                a3[a4++] = a6.eigenvalue().doubleValue();
                n2 = ++a5;
            }
            n = ++a2;
        }
        return new DiagonalMatrix(a3);
    }

    public Matrix Qt() {
        return this.Q().t();
    }
}

