/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles;

import com.numericalmethod.suanshu.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.matrix.doubles.AreMatrices;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class ImmutableMatrix
implements Matrix {
    private final Matrix E;

    @Override
    public Matrix scaled(double scalar) {
        return this.E.scaled(scalar);
    }

    @Override
    public double get(int row, int col) throws MatrixAccessException {
        return this.E.get(row, col);
    }

    @Override
    public Matrix opposite() {
        return this.E.opposite();
    }

    @Override
    public void set(int row, int col, double value) throws MatrixAccessException {
        throw new MatrixAccessException("this matrix is immutable");
    }

    @Override
    public int nRows() {
        return this.E.nRows();
    }

    public int hashCode() {
        return this.E.hashCode();
    }

    public ImmutableMatrix(Matrix A) {
        this.E = A;
    }

    @Override
    public int nCols() {
        return this.E.nCols();
    }

    @Override
    public Matrix ONE() {
        return this.E.ONE();
    }

    @Override
    public Vector getColumn(int col) throws MatrixAccessException {
        return this.E.getColumn(col);
    }

    @Override
    public Vector multiply(Vector v) {
        return this.E.multiply(v);
    }

    @Override
    public Matrix add(Matrix that) {
        return this.E.add(that);
    }

    public String toString() {
        return this.E.toString();
    }

    @Override
    public Matrix ZERO() {
        return this.E.ZERO();
    }

    @Override
    public Matrix t() {
        return this.E.t();
    }

    @Override
    public Matrix minus(Matrix that) {
        return this.E.minus(that);
    }

    @Override
    public Matrix deepCopy() {
        return this.E.deepCopy();
    }

    @Override
    public Vector getRow(int row) throws MatrixAccessException {
        return this.E.getRow(row);
    }

    @Override
    public Matrix multiply(Matrix that) {
        return this.E.multiply(that);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Matrix)) {
            return false;
        }
        Matrix a2 = (Matrix)obj;
        if (!AreMatrices.equal(this.E, a2, 0.0)) {
            return false;
        }
        return true;
    }
}

