/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.interval;

import com.numericalmethod.suanshu.interval.Algebra;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import java.util.EnumSet;
import java.util.Set;

public class Interval<T extends Comparable<T>> {
    private final T L;
    private final T E;

    public boolean is(Algebra.Relation relation, Interval<T> Y) {
        return relation.isRelationBetween(this, Y);
    }

    public Interval(T begin, T end) {
        SuanShuUtils.assertArgument(begin.compareTo(end) < 0, "begin must start before end", new Object[0]);
        this.L = begin;
        this.E = end;
    }

    public T begin() {
        return this.L;
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 19 * a2 + (this.L != null ? this.L.hashCode() : 0);
        a2 = 19 * a2 + (this.E != null ? this.E.hashCode() : 0);
        return a2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Interval)) {
            return false;
        }
        Interval a2 = (Interval)obj;
        if (!this.L.getClass().isInstance(a2.L)) {
            return false;
        }
        if (this.L != a2.L && (this.L == null || this.L.compareTo(a2.L) != 0)) {
            return false;
        }
        if (this.E != a2.E && (this.E == null || this.E.compareTo(a2.E) != 0)) {
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder a2 = new StringBuilder();
        a2.append("[");
        a2.append(this.L.toString());
        a2.append(", ");
        a2.append(this.E.toString());
        a2.append("]");
        return a2.toString();
    }

    public T end() {
        return this.E;
    }

    public Set<Algebra.Relation> relations(Interval<T> Y) {
        EnumSet<Algebra.Relation> a2 = EnumSet.noneOf(Algebra.Relation.class);
        for (Algebra.Relation a3 : EnumSet.allOf(Algebra.Relation.class)) {
            if (!this.is(a3, Y)) continue;
            a2.add(a3);
        }
        return a2;
    }
}

