/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.datastructure;

import com.numericalmethod.suanshu.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.matrix.doubles.MatrixTable;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import java.util.ArrayList;

public class FlexibleTable
implements MatrixTable {
    private ArrayList<Object> F;
    private int k = 0;
    private ArrayList<ArrayList<Double>> L;
    private ArrayList<Object> E;

    public void addRowAt(int i2) {
        this.addRowAt(i2, this.b());
    }

    public void addColAt(int i2) {
        this.addColAt(i2, this.m());
    }

    public int getIndexFromColLabel(Object label) {
        int a2;
        int n = a2 = 0;
        while (n < this.F.size()) {
            if (this.F.get(a2).equals(label)) {
                return a2 + 1;
            }
            n = ++a2;
        }
        Object[] objectArray = new Object[1];
        objectArray[0] = label.toString();
        throw new RuntimeException(String.format("unrecognized name: %s", objectArray));
    }

    @Override
    public double get(int i2, int j) {
        return this.L.get(i2 - 1).get(j - 1);
    }

    public DenseMatrix toMatrix() {
        int a2;
        int a3 = this.nRows();
        int a4 = this.nCols();
        DenseMatrix a5 = new DenseMatrix(a3, a4);
        int n = a2 = 1;
        while (n <= a3) {
            int a6;
            int n2 = a6 = 1;
            while (n2 <= a4) {
                a5.set(a2, a6, this.get(a2, a6));
                n2 = ++a6;
            }
            n = ++a2;
        }
        return a5;
    }

    @Override
    public int nRows() {
        return this.E.size();
    }

    public void deleteCol(int i2) {
        int a2;
        int a3 = this.nRows();
        int n = a2 = 0;
        while (n < a3) {
            Double a4 = this.L.get(a2).remove(i2 - 1);
            n = ++a2;
        }
        this.F.remove(i2 - 1);
    }

    public Object getRowLabel(int i2) {
        return this.E.get(i2 - 1);
    }

    public void renameRow(int i2, Object label) {
        this.E.set(i2 - 1, label);
    }

    public int getIndexFromRowLabel(Object label) {
        int a2;
        int n = a2 = 0;
        while (n < this.E.size()) {
            if (this.E.get(a2).equals(label)) {
                return a2 + 1;
            }
            n = ++a2;
        }
        Object[] objectArray = new Object[1];
        objectArray[0] = label.toString();
        throw new RuntimeException(String.format("unrecognized name: %s", objectArray));
    }

    private Object m() {
        FlexibleTable a2;
        Object[] objectArray = new Object[1];
        objectArray[0] = ++a2.k;
        return String.format("col#%d", objectArray);
    }

    @Override
    public void set(int i2, int j, double value) {
        this.L.get(i2 - 1).set(j - 1, value);
    }

    public FlexibleTable(Object[] rowLabels, Object[] colLabels, double[][] cells) {
        int a2;
        this.F = new ArrayList(colLabels.length);
        int n = a2 = 0;
        while (n < colLabels.length) {
            this.F.add(colLabels[a2]);
            n = ++a2;
        }
        this.E = new ArrayList(rowLabels.length);
        this.L = new ArrayList();
        int n2 = a2 = 0;
        while (n2 < rowLabels.length) {
            this.addRowAt(a2 + 1, rowLabels[a2]);
            n2 = ++a2;
        }
        int n3 = a2 = 0;
        while (n3 < rowLabels.length) {
            int a3;
            int n4 = a3 = 0;
            while (n4 < colLabels.length) {
                this.set(a2 + 1, a3 + 1, cells[a2][a3]);
                n4 = ++a3;
            }
            n3 = ++a2;
        }
    }

    public FlexibleTable(FlexibleTable that) {
        this(that.E.toArray(new Object[0]), that.F.toArray(new Object[0]), MatrixUtils.to2DArray(that.toMatrix()));
    }

    public Vector getColumn(int col) throws MatrixAccessException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getColLabel(int i2) {
        return this.F.get(i2 - 1);
    }

    public FlexibleTable(Object[] rowLabels, Object[] colLabels) {
        this(rowLabels, colLabels, new double[rowLabels.length][colLabels.length]);
    }

    public void addRowAt(int i2, Object label) {
        int a2;
        this.E.add(i2 - 1, label);
        int a3 = this.nCols();
        this.L.add(i2 - 1, new ArrayList(a3));
        ArrayList<Double> a4 = this.L.get(i2 - 1);
        int n = a2 = 0;
        while (n < a3) {
            a4.add(new Double(0.0));
            n = ++a2;
        }
    }

    public FlexibleTable(int nRows, int nCols) {
        this(new Object[nRows], new Object[nCols]);
        int a2;
        int n = a2 = 0;
        while (n < nRows) {
            this.renameRow(a2 + 1, this.b());
            n = ++a2;
        }
        int n2 = a2 = 0;
        while (n2 < nCols) {
            this.renameCol(a2 + 1, this.m());
            n2 = ++a2;
        }
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 41 * a2 + (this.L != null ? this.L.hashCode() : 0);
        a2 = 41 * a2 + (this.F != null ? this.F.hashCode() : 0);
        a2 = 41 * a2 + (this.E != null ? this.E.hashCode() : 0);
        return a2;
    }

    public void renameCol(int i2, Object label) {
        this.F.set(i2 - 1, label);
    }

    public String toString() {
        int a2;
        StringBuilder a3 = new StringBuilder();
        int a4 = this.nRows();
        int a5 = this.nCols();
        Object[] objectArray = new Object[2];
        objectArray[0] = a4;
        objectArray[1] = a5;
        a3.append(String.format("%dx%d\n", objectArray));
        Object[] objectArray2 = new Object[1];
        objectArray2[0] = "";
        a3.append(String.format("%-32s", objectArray2));
        int n = a2 = 0;
        while (n < a5) {
            Object[] objectArray3 = new Object[1];
            objectArray3[0] = this.F.get(a2);
            a3.append(String.format("%-32s", objectArray3));
            n = ++a2;
        }
        a3.append("\n");
        int n2 = a2 = 0;
        while (n2 < a4) {
            int a6;
            Object[] objectArray4 = new Object[1];
            objectArray4[0] = this.E.get(a2);
            a3.append(String.format("%-32s", objectArray4));
            int n3 = a6 = 0;
            while (n3 < a5) {
                Object[] objectArray5 = new Object[1];
                objectArray5[0] = this.get(a2 + 1, a6 + 1);
                a3.append(String.format("%-32f", objectArray5));
                n3 = ++a6;
            }
            a3.append("\n");
            n2 = ++a2;
        }
        return a3.toString();
    }

    public void addColAt(int i2, Object label) {
        int a2;
        this.F.add(i2 - 1, label);
        int a3 = this.nRows();
        int n = a2 = 0;
        while (n < a3) {
            this.L.get(a2).add(i2 - 1, 0.0);
            n = ++a2;
        }
    }

    public void deleteRow(int i2) {
        this.L.remove(i2 - 1);
        this.E.remove(i2 - 1);
    }

    private Object b() {
        FlexibleTable a2;
        Object[] objectArray = new Object[1];
        objectArray[0] = ++a2.k;
        return String.format("row#%d", objectArray);
    }

    public Vector getRow(int row) throws MatrixAccessException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlexibleTable a2 = (FlexibleTable)obj;
        if (!(this.L == a2.L || this.L != null && this.L.equals(a2.L))) {
            return false;
        }
        if (!(this.F == a2.F || this.F != null && this.F.equals(a2.F))) {
            return false;
        }
        if (!(this.E == a2.E || this.E != null && this.E.equals(a2.E))) {
            return false;
        }
        return true;
    }

    @Override
    public int nCols() {
        return this.F.size();
    }
}

