/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.uniroot;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;

public abstract class Uniroot {
    public final UnivariateRealFunction f;
    public final double tol;

    public double solve(int maxIterations, double lower, double upper, double guess) throws NoRootFoundException {
        double d2;
        double d3;
        double[] dArray = new double[1];
        dArray[0] = guess;
        double a2 = this.solve(maxIterations, lower, upper, dArray);
        if (d3 < lower) {
            a2 = lower;
        }
        if (a2 > upper) {
            a2 = upper;
        }
        double a3 = this.f.evaluate(a2);
        if (Math.abs(d2) > this.tol) {
            throw new NoRootFoundException(a2, a3);
        }
        return a2;
    }

    public Uniroot(UnivariateRealFunction f2, double tol) {
        this.f = f2;
        this.tol = tol;
    }

    public abstract double solve(int var1, double var2, double var4, double ... var6);

    public static class NoRootFoundException
    extends Exception {
        public final double x;
        private static final long serialVersionUID = 1L;
        public final double fx;

        public NoRootFoundException(double x, double fx) {
            Object[] objectArray = new Object[2];
            objectArray[0] = x;
            objectArray[1] = fx;
            super(String.format("no root found; best approx. root is %f; f(x)=%f", objectArray));
            this.x = x;
            this.fx = fx;
        }
    }
}

