/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.interpolation;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.interpolation.UnivariateRealInterpolator;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class NevilleTable
extends UnivariateRealFunction
implements UnivariateRealInterpolator {
    private static final double i = 1.2;
    private int G;
    private double[] F;
    private double k;
    private int L;
    private double[][] E;

    public NevilleTable(double[] x, double[] y) {
        this(0, x, y);
    }

    public NevilleTable() {
        int a2 = 10;
        this.E = new double[a2][a2];
        this.F = new double[a2];
        this.G = 0;
    }

    public NevilleTable(int n, double[] x, double[] y) {
        SuanShuUtils.assertArgument(x.length == y.length, "data sizes do not match", new Object[0]);
        int a2 = n;
        if (a2 < x.length) {
            a2 = (int)((double)x.length * 1.2);
        }
        this.F = new double[a2];
        this.E = new double[a2][a2];
        this.addData(x, y);
    }

    @Override
    public void addData(double[] x, double[] y) {
        int a2;
        int a3;
        int a4 = x.length;
        if (this.G + a4 > this.E.length) {
            int a5;
            int a6;
            a3 = (int)((double)(this.G + a4) * 1.2);
            double[] a7 = new double[a3];
            int n = a6 = 0;
            while (n < this.G) {
                a7[a6] = this.F[a6];
                n = ++a6;
            }
            this.F = a7;
            double[][] a22 = new double[a3][a3];
            int n2 = a5 = 0;
            while (n2 < this.G) {
                int n3 = a5;
                while (n3 < this.G) {
                    int a8;
                    a22[a5][a8] = this.E[a5][a8];
                    n3 = ++a8;
                }
                n2 = ++a5;
            }
            this.E = a22;
        }
        a3 = this.G;
        int n = a2 = 0;
        while (n < a4) {
            this.F[a3] = x[a2];
            this.E[a3][a3] = y[a2];
            ++a3;
            n = ++a2;
        }
        this.G += a4;
    }

    @Override
    public double evaluate(double x) {
        int a2;
        SuanShuUtils.assertArgument(this.G >= 2, "not enough data points for interpolation", new Object[0]);
        if (this.L == this.G - 1 && this.k == x) {
            return this.E[0][this.L];
        }
        int n = a2 = this.k == x ? this.L : 1;
        while (n < this.G) {
            int n2 = a2 - 1;
            while (n2 >= 0) {
                int a3;
                double a4 = (x - this.F[a2]) * this.E[a3][a2 - 1];
                a4 += (this.F[a3] - x) * this.E[a3 + 1][a2];
                double a5 = this.F[a3] - this.F[a2];
                if (DoubleUtils.compare(a5, 0.0) == 0) {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = a3;
                    objectArray[1] = a2;
                    throw new DuplicatedAbscissae(String.format("x[%d] and x[%d] are identical", objectArray));
                }
                this.E[a3][a2] = a4 /= a5;
                n2 = --a3;
            }
            n = ++a2;
        }
        this.k = x;
        this.L = this.G - 1;
        return this.E[0][this.L];
    }

    public int N() {
        return this.G;
    }

    public double[] X() {
        int a2;
        double[] a3 = new double[this.G];
        int n = a2 = 0;
        while (n < this.G) {
            a3[a2] = this.F[a2];
            n = ++a2;
        }
        return a3;
    }

    public double get(int row, int col) {
        SuanShuUtils.assertArgument(col >= row, "only the upper triangular part of the table is used", new Object[0]);
        return this.E[row][col];
    }

    public double[][] getTable() {
        int a2;
        double[][] a3 = new double[this.G][this.G];
        int n = a2 = 0;
        while (n < this.G) {
            int n2 = a2;
            while (n2 < this.G) {
                int a4;
                a3[a2][a4] = this.E[a2][a4];
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    public static class DuplicatedAbscissae
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public DuplicatedAbscissae(String msg) {
            super(msg);
        }
    }
}

