/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.integration.univariate.riemann;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.Integrator;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.IterativeIntegrator;
import com.numericalmethod.suanshu.analysis.interpolation.NevilleTable;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class Romberg
implements Integrator {
    private IterativeIntegrator L;
    private final NevilleTable E;

    private double b(double a2, double a3) {
        Romberg a4;
        double[] dArray = new double[1];
        dArray[0] = a2;
        double[] dArray2 = new double[1];
        dArray2[0] = a3;
        a4.E.addData(dArray, dArray2);
        int a5 = a4.E.N();
        double a6 = Double.NaN;
        if (a5 >= 2) {
            a6 = a4.E.evaluate(0.0);
        }
        return a6;
    }

    public Romberg(IterativeIntegrator integrator) {
        SuanShuUtils.assertArgument(integrator.getMaxIterations() >= 2, "the number of iterations must be > 2 for extrapolation", new Object[0]);
        this.L = integrator;
        this.E = new NevilleTable();
    }

    @Override
    public double integrate(UnivariateRealFunction f2, double a2, double b2) {
        int a3;
        double a4 = 0.0;
        double a5 = 0.0;
        double a6 = 0.0;
        int n = a3 = 1;
        while (n <= this.L.getMaxIterations()) {
            a4 = this.L.next(a3, f2, a2, b2, a4);
            double a7 = this.L.h();
            a6 = this.b(a7, a4);
            a5 = this.b();
            if (a3 > 3 && DoubleUtils.relativeError(a6, a5) < this.getPrecision()) break;
            n = ++a3;
        }
        return a6;
    }

    private double b() {
        Romberg a2;
        int a3 = a2.E.N();
        double a4 = Double.NaN;
        if (a3 >= 2) {
            a4 = a2.E.get(0, a3 - 2);
        }
        return a4;
    }

    @Override
    public double getPrecision() {
        return this.L.getPrecision();
    }
}

