/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.special;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.special.Lanczos;

public class LogGamma
extends UnivariateRealFunction {
    private Method L;
    private final Lanczos E;

    public LogGamma() {
        this.L = Method.LANCZOS_QUICK;
        this.E = new Lanczos();
    }

    @Override
    public double evaluate(double x) {
        double a2 = Double.NaN;
        double a3 = x > 0.0 ? x : -x;
        switch (this.L) {
            case LANCZOS_QUICK: {
                do {
                } while (false);
                a2 = this.E.logGammaQuick(a3);
                break;
            }
            default: {
                a2 = this.E.logGamma(a3);
            }
        }
        return a2;
    }

    public LogGamma(Method method, double g2, int n, int scale) {
        this.L = method;
        this.E = new Lanczos(g2, n, scale);
    }

    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method LANCZOS_QUICK;
        public static final /* enum */ Method LANCZOS;
        private static final /* synthetic */ Method[] E;

        public static Method valueOf(String name) {
            return Enum.valueOf(Method.class, name);
        }

        static {
            LANCZOS = new Method();
            LANCZOS_QUICK = new Method();
            Method[] methodArray = new Method[2];
            methodArray[0] = LANCZOS;
            methodArray[1] = LANCZOS_QUICK;
            E = methodArray;
        }

        public static Method[] values() {
            return (Method[])E.clone();
        }

        private Method() {
            Method a2;
        }
    }
}

