/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.special;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.special.Lanczos;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class Gamma
extends UnivariateRealFunction {
    private final Lanczos F;
    private Method k;
    private final double L;
    private final int E;

    @Override
    public double evaluate(double x) {
        double a2 = Double.POSITIVE_INFINITY;
        if (DoubleUtils.compare(x, 0.0) == 0) {
            return a2;
        }
        double a3 = x > 0.0 ? x : -x;
        switch (this.k) {
            case GERGO_NEMES: {
                a2 = this.d(a3);
                break;
            }
            case LANCZOS_QUICK: {
                do {
                } while (false);
                a2 = this.b(a3);
                break;
            }
            default: {
                a2 = this.m(a3);
            }
        }
        a2 = x > 0.0 ? a2 : this.b(-x, a2);
        return a2;
    }

    public Gamma(double g2, int n, int scale) {
        this.k = Method.LANCZOS;
        this.F = new Lanczos(g2, n, scale);
        this.L = 0.0;
        this.E = 0;
    }

    @Deprecated
    private double B(double a2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private double d(double a2) {
        double a3 = Math.sqrt(Math.PI * 2 / a2);
        double a4 = Math.pow((a2 + 1.0 / (12.0 * a2 - 0.1 * a2)) / Math.E, a2);
        double a5 = a3 * a4;
        return a5;
    }

    @Deprecated
    private double k(double a2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Gamma() {
        this.k = Method.LANCZOS_QUICK;
        this.F = new Lanczos();
        this.L = 0.0;
        this.E = 0;
    }

    public Gamma(Method method) {
        this.k = method;
        this.F = new Lanczos();
        this.E = 49;
        this.L = Constant.EPSILON;
    }

    private double m(double a2) {
        Gamma a3;
        double a4 = a3.F.logGamma(a2);
        a4 = Math.exp(a4);
        return a4;
    }

    private double b(double a2, double a3) {
        double a4 = Math.PI / a2;
        a4 /= a3;
        return a4 /= Math.sin(-a2 * Math.PI);
    }

    private double b(double a2) {
        Gamma a3;
        double a4 = a3.F.logGammaQuick(a2);
        a4 = Math.exp(a4);
        return a4;
    }

    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method LANCZOS_QUICK;
        public static final /* enum */ Method LANCZOS;
        public static final /* enum */ Method GERGO_NEMES;
        private static final /* synthetic */ Method[] E;

        private Method() {
            Method a2;
        }

        public static Method valueOf(String name) {
            return Enum.valueOf(Method.class, name);
        }

        public static Method[] values() {
            return (Method[])E.clone();
        }

        static {
            LANCZOS = new Method();
            LANCZOS_QUICK = new Method();
            GERGO_NEMES = new Method();
            Method[] methodArray = new Method[3];
            methodArray[0] = LANCZOS;
            methodArray[1] = LANCZOS_QUICK;
            methodArray[2] = GERGO_NEMES;
            E = methodArray;
        }
    }
}

