/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.special;

import com.numericalmethod.suanshu.analysis.function.rn2r1.ContinuedFraction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.special.LogBeta;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class BetaRegularized
extends UnivariateRealFunction {
    public final double p;
    private static final LogBeta E = new LogBeta();
    public final double q;

    @Override
    public double evaluate(final double x) {
        if (DoubleUtils.compare(x, 0.0) == 0) {
            return 0.0;
        }
        if (DoubleUtils.compare(x, 1.0) == 0) {
            return 1.0;
        }
        double a2 = (this.p + 1.0) / (this.p + this.q + 2.0);
        if (x > a2) {
            BetaRegularized a3 = new BetaRegularized(this.q, this.p);
            return 1.0 - a3.evaluate(1.0 - x);
        }
        double a4 = this.p * Math.log(x) + this.q * Math.log(1.0 - x) - Math.log(this.p) - E.evaluate(this.p, this.q);
        a4 = Math.exp(a4);
        return a4 /= new ContinuedFraction().evaluate(new ContinuedFraction.Partials(){

            @Override
            public double A(int n) {
                double a2 = 0.0;
                if (n % 2 == 1) {
                    int a3 = (n - 1) / 2;
                    a2 = -(BetaRegularized.this.p + (double)a3) * (BetaRegularized.this.p + BetaRegularized.this.q + (double)a3);
                    a2 /= (BetaRegularized.this.p + (double)(2 * a3)) * (BetaRegularized.this.p + (double)(2 * a3) + 1.0);
                    a2 *= x;
                } else {
                    int a4 = (n - 2) / 2;
                    a2 = (double)(a4 + 1) * (BetaRegularized.this.q - (double)a4 - 1.0);
                    a2 /= (BetaRegularized.this.p + (double)(2 * a4) + 1.0) * (BetaRegularized.this.p + (double)(2 * a4) + 2.0);
                    a2 *= x;
                }
                return a2;
            }
            {
                1 a2;
            }

            @Override
            public double B(int n) {
                return 1.0;
            }
        });
    }

    public BetaRegularized(double p, double q2) {
        this.p = p;
        this.q = q2;
    }
}

