/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.rn2r1;

import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class QuadraticFunction
implements RealScalarFunction {
    private final Matrix k;
    private final double L;
    private final Vector E;

    public QuadraticFunction(QuadraticFunction f2) {
        this(f2.k, f2.E, f2.L);
    }

    public QuadraticFunction(Matrix H, Vector p, double c2) {
        this.k = H;
        this.E = p;
        this.L = c2;
    }

    @Override
    public double evaluate(double ... z2) {
        DenseMatrix a2 = new DenseMatrix(z2, z2.length, 1);
        Matrix a3 = a2.t();
        Matrix a4 = a3.multiply(this.k).multiply(a2);
        Vector a5 = a3.multiply(this.E);
        return 0.5 * a4.get(1, 1) + a5.get(1) + this.L;
    }

    @Override
    public int dimensionOfRange() {
        return 1;
    }

    public Matrix Hessian() {
        return new ImmutableMatrix(this.k);
    }

    public String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = this.k;
        objectArray[1] = this.E;
        return String.format("1/2 * x'%sx + x'%s", objectArray);
    }

    public QuadraticFunction(Matrix H, Vector p) {
        this(H, p, 0.0);
    }

    @Override
    public int dimensionOfDomain() {
        return this.E.size();
    }

    public Vector p() {
        return new ImmutableVector(this.E);
    }
}

