/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.polynomial.root;

import com.numericalmethod.suanshu.analysis.function.polynomial.Polynomial;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.PolynomialSolver;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.QuarticByFormula;
import com.numericalmethod.suanshu.datastructure.list.NumberList;
import com.numericalmethod.suanshu.misc.SuanShuUtils;

public class Quartic
implements PolynomialSolver {
    private final QuarticSolver E;

    public Quartic(QuarticSolver solver) {
        this.E = solver;
    }

    public Quartic() {
        this(new QuarticByFormula());
    }

    @Override
    public NumberList solve(Polynomial polynomial) {
        SuanShuUtils.assertArgument(polynomial.degree == 4, "polynomial is not of degree 4", new Object[0]);
        double[] a2 = polynomial.getCoefficients();
        return this.E.solve(a2[0], a2[1], a2[2], a2[3], a2[4]);
    }

    @Override
    public PolynomialSolver.PolynomialType getType() {
        return PolynomialSolver.PolynomialType.QUARTIC;
    }

    public static interface QuarticSolver {
        public NumberList solve(double var1, double var3, double var5, double var7, double var9);
    }
}

