/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.polynomial.root;

import com.numericalmethod.suanshu.analysis.function.polynomial.Polynomial;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.PolynomialSolver;
import com.numericalmethod.suanshu.datastructure.list.NumberList;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.number.complex.Complex;

public class Quadratic
implements PolynomialSolver {
    @Override
    public NumberList solve(Polynomial polynomial) {
        SuanShuUtils.assertArgument(polynomial.degree == 2, "polynomial is not of degree 2", new Object[0]);
        NumberList a2 = new NumberList();
        double[] a3 = polynomial.getCoefficients();
        double a4 = a3[0];
        double a5 = a3[1];
        double a6 = a3[2];
        if (DoubleUtils.compare(a6, 0.0) == 0) {
            a2.add(new Double(0.0));
            a2.add(new Double(-a5 / a4));
            return a2;
        }
        double a7 = a5 / 2.0;
        double a8 = 0.0;
        double a9 = 0.0;
        if (Math.abs(a7) < Math.abs(a6)) {
            a9 = Math.signum(a6) * a4;
            a9 = -a9 + a7 * (a7 / Math.abs(a6));
            a8 = Math.sqrt(Math.abs(a9)) * Math.sqrt(Math.abs(a6));
        } else {
            a9 = -(a4 / a7 * (a6 / a7)) + 1.0;
            a8 = Math.sqrt(Math.abs(a9)) * Math.abs(a7);
        }
        if (DoubleUtils.compare(a9, 0.0) >= 0) {
            a8 = -Math.signum(a7) * a8;
            double a10 = (-a7 + a8) / a4;
            a2.add(a10);
            a2.add(DoubleUtils.compare(a10, 0.0) != 0 ? a6 / a10 / a4 : 0.0);
        } else {
            double a11 = -(a7 / a4);
            double a12 = a8 / a4;
            a2.add(new Complex(a11, a12));
            a2.add(new Complex(a11, -a12));
        }
        return a2;
    }

    @Override
    public PolynomialSolver.PolynomialType getType() {
        return PolynomialSolver.PolynomialType.QUADRATIC;
    }
}

