/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.polynomial.root;

import com.numericalmethod.suanshu.analysis.function.polynomial.Polynomial;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.PolynomialSolver;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.jenkinstraub.JenkinsTraubReal;
import com.numericalmethod.suanshu.datastructure.list.NumberList;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import java.util.EnumMap;

public class Polyroot
implements PolynomialSolver {
    private final EnumMap<PolynomialSolver.PolynomialType, PolynomialSolver> E = new EnumMap(PolynomialSolver.PolynomialType.class);

    @Override
    public PolynomialSolver.PolynomialType getType() {
        return PolynomialSolver.PolynomialType.GENERAL;
    }

    public Polyroot(PolynomialSolver ... solvers) {
        int a2;
        this.E.put(PolynomialSolver.PolynomialType.GENERAL, new JenkinsTraubReal());
        PolynomialSolver[] a3 = solvers;
        int a4 = solvers.length;
        int n = a2 = 0;
        while (n < a4) {
            PolynomialSolver a5 = a3[a2];
            this.E.put(a5.getType(), a5);
            n = ++a2;
        }
    }

    @Override
    public NumberList solve(Polynomial polynomial) {
        Object[] objectArray = new Object[1];
        objectArray[0] = polynomial.getCoefficient(0);
        SuanShuUtils.assertArgument(polynomial.degree != 0, "this polynomial is a constant %f", objectArray);
        PolynomialSolver a2 = this.E.get((Object)PolynomialSolver.PolynomialType.fromDegree(polynomial.degree));
        if (a2 == null) {
            a2 = this.E.get((Object)PolynomialSolver.PolynomialType.GENERAL);
        }
        return a2.solve(polynomial);
    }
}

