/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function;

import com.numericalmethod.suanshu.analysis.function.Function;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class RestrictedFunction
implements Function {
    public final Function f;
    public final ArrayList<FixedValues> fixed;

    @Override
    public int dimensionOfDomain() {
        return this.f.dimensionOfDomain() - this.fixed.size();
    }

    public RestrictedFunction(Function f2, Collection<FixedValues> fixed) {
        Iterator<FixedValues> a2;
        SuanShuUtils.assertArgument(fixed.size() <= f2.dimensionOfDomain(), "too many fixed values", new Object[0]);
        Iterator<FixedValues> iterator = a2 = fixed.iterator();
        while (iterator.hasNext()) {
            SuanShuUtils.assertArgument(a2.next().index < f2.dimensionOfDomain(), "invalid index", new Object[0]);
            iterator = a2;
        }
        this.f = f2;
        this.fixed = new ArrayList<FixedValues>(fixed);
    }

    @Override
    public int dimensionOfRange() {
        return this.f.dimensionOfRange();
    }

    public double[] getVariablePart(double[] z2) {
        double[] a2 = new double[this.f.dimensionOfDomain() - this.fixed.size()];
        int a3 = 0;
        int a4 = 0;
        int n = a3;
        while (n < z2.length) {
            if (!this.isFixedIndex(a3)) {
                a2[a4++] = z2[a3];
            }
            n = ++a3;
        }
        return a2;
    }

    public RestrictedFunction(Function f2, FixedValues ... fixed) {
        this(f2, Arrays.asList(fixed));
    }

    public static double[] getAllParts(double[] variables, Collection<FixedValues> fixed) {
        int a2;
        int a3 = variables.length + fixed.size();
        int a4 = 0;
        Iterator<FixedValues> a5 = fixed.iterator();
        FixedValues a6 = a5.hasNext() ? a5.next() : new FixedValues(Integer.MAX_VALUE, 2.147483647E9);
        double[] a7 = new double[a3];
        int n = a2 = 0;
        while (n < a3) {
            if (a2 == a6.index) {
                a7[a2] = a6.value;
                a6 = a5.hasNext() ? a5.next() : new FixedValues(Integer.MAX_VALUE, 2.147483647E9);
            } else {
                a7[a2] = variables[a4];
                ++a4;
            }
            n = ++a2;
        }
        return a7;
    }

    public boolean isFixedIndex(int idx) {
        int a2;
        int n = a2 = 0;
        while (n < this.fixed.size()) {
            if (this.fixed.get((int)a2).index == idx) {
                return true;
            }
            n = ++a2;
        }
        return false;
    }

    public static class FixedValues {
        public final int index;
        public final double value;

        public FixedValues(int index, double value) {
            this.index = index;
            this.value = value;
        }

        public String toString() {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.index;
            objectArray[1] = this.value;
            return String.format("x%d = %f", objectArray);
        }
    }
}

