/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentiation.univariate;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.function.FunctionOps;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.misc.SuanShuUtils;

public class FiniteDifference
extends UnivariateRealFunction {
    public final UnivariateRealFunction f;
    private volatile double E;
    public final FiniteDifferenceType type;
    public final int order;

    public FiniteDifference(UnivariateRealFunction f2, int order, FiniteDifferenceType type) {
        SuanShuUtils.assertArgument(order > 0, "the order of derivative must be >= 1", new Object[0]);
        this.order = order;
        this.type = type;
        this.f = f2;
    }

    public double df(double x, double h2) {
        int a2;
        double a3 = 0.0;
        int a4 = 1;
        int n = a2 = 0;
        while (n <= this.order) {
            double a5 = x;
            switch (this.type) {
                case FORWARD: {
                    a5 += (double)(this.order - a2) * h2;
                    break;
                }
                case BACKWARD: {
                    a5 += (double)(-a2) * h2;
                    break;
                }
                case CENTRAL: {
                    do {
                    } while (false);
                    a5 += ((double)this.order / 2.0 - (double)a2) * h2;
                }
            }
            a3 += (double)a4 * FunctionOps.combination(this.order, a2) * this.f.evaluate(a5);
            a4 *= -1;
            n = ++a2;
        }
        return a3;
    }

    public double evaluate(double[] x, double h2) {
        double a2 = x[0];
        this.E = a2 + h2;
        h2 = this.E - a2;
        double a3 = this.df(a2, h2);
        if (this.order % 2 == 1 && this.type == FiniteDifferenceType.CENTRAL) {
            a3 = 0.5 * (this.df(a2 - h2 / 2.0, h2) + this.df(a2 + h2 / 2.0, h2));
        }
        return a3 / Math.pow(h2, this.order);
    }

    @Override
    public double evaluate(double x) {
        double a2 = Math.pow(Constant.MACH_EPS, 1.0 / (double)(this.order + 1)) * Math.max(0.1, Math.abs(x));
        double[] dArray = new double[1];
        dArray[0] = x;
        return this.evaluate(dArray, a2);
    }

    public static final class FiniteDifferenceType
    extends Enum<FiniteDifferenceType> {
        public static final /* enum */ FiniteDifferenceType BACKWARD;
        private static final /* synthetic */ FiniteDifferenceType[] E;
        public static final /* enum */ FiniteDifferenceType FORWARD;
        public static final /* enum */ FiniteDifferenceType CENTRAL;

        public static FiniteDifferenceType[] values() {
            return (FiniteDifferenceType[])E.clone();
        }

        static {
            FORWARD = new FiniteDifferenceType();
            BACKWARD = new FiniteDifferenceType();
            CENTRAL = new FiniteDifferenceType();
            FiniteDifferenceType[] finiteDifferenceTypeArray = new FiniteDifferenceType[3];
            finiteDifferenceTypeArray[0] = FORWARD;
            finiteDifferenceTypeArray[1] = BACKWARD;
            finiteDifferenceTypeArray[2] = CENTRAL;
            E = finiteDifferenceTypeArray;
        }

        private FiniteDifferenceType() {
            FiniteDifferenceType a2;
        }

        public static FiniteDifferenceType valueOf(String name) {
            return Enum.valueOf(FiniteDifferenceType.class, name);
        }
    }
}

