/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentiation.univariate;

import com.numericalmethod.suanshu.analysis.differentiation.Ridders;
import com.numericalmethod.suanshu.analysis.differentiation.univariate.DBetaRegularized;
import com.numericalmethod.suanshu.analysis.differentiation.univariate.DErf;
import com.numericalmethod.suanshu.analysis.differentiation.univariate.DGamma;
import com.numericalmethod.suanshu.analysis.differentiation.univariate.DGaussian;
import com.numericalmethod.suanshu.analysis.differentiation.univariate.DPolynomial;
import com.numericalmethod.suanshu.analysis.differentiation.univariate.FiniteDifference;
import com.numericalmethod.suanshu.analysis.function.polynomial.Polynomial;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.special.BetaRegularized;
import com.numericalmethod.suanshu.analysis.function.special.CumulativeNormal;
import com.numericalmethod.suanshu.analysis.function.special.Digamma;
import com.numericalmethod.suanshu.analysis.function.special.Erf;
import com.numericalmethod.suanshu.analysis.function.special.Gamma;
import com.numericalmethod.suanshu.analysis.function.special.Gaussian;
import com.numericalmethod.suanshu.analysis.function.special.LogGamma;

public class Dfdx
extends UnivariateRealFunction {
    private final UnivariateRealFunction E;

    public Dfdx(final UnivariateRealFunction f2, Method method) {
        if (f2 instanceof Polynomial) {
            this.E = new DPolynomial((Polynomial)f2);
        } else if (f2 instanceof BetaRegularized) {
            this.E = new DBetaRegularized(((BetaRegularized)f2).p, ((BetaRegularized)f2).q);
        } else if (f2 instanceof LogGamma) {
            this.E = new Digamma();
        } else if (f2 instanceof Gamma) {
            this.E = new DGamma();
        } else if (f2 instanceof CumulativeNormal) {
            this.E = new Gaussian();
        } else if (f2 instanceof Gaussian) {
            this.E = new DGaussian((Gaussian)f2);
        } else if (f2 instanceof Erf) {
            this.E = new DErf();
        } else {
            switch (method) {
                case RIDDERS: {
                    do {
                    } while (false);
                    this.E = new UnivariateRealFunction(){
                        public RealScalarFunction df;
                        {
                            1 a2;
                            a2.df = new Ridders(a2.f2, 1);
                        }

                        @Override
                        public double evaluate(double x) {
                            double[] dArray = new double[1];
                            dArray[0] = x;
                            return this.df.evaluate(dArray);
                        }
                    };
                    break;
                }
                default: {
                    this.E = new FiniteDifference(f2, 1, FiniteDifference.FiniteDifferenceType.CENTRAL);
                }
            }
        }
    }

    @Override
    public double evaluate(double x) {
        return this.E.evaluate(x);
    }

    public Dfdx(UnivariateRealFunction f2) {
        this(f2, Method.FINITE_DIFFERENCE);
    }

    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method FINITE_DIFFERENCE = new Method();
        private static final /* synthetic */ Method[] E;
        public static final /* enum */ Method RIDDERS = new Method();

        public static Method valueOf(String name) {
            return Enum.valueOf(Method.class, name);
        }

        public static Method[] values() {
            return (Method[])E.clone();
        }

        private Method() {
            Method a2;
        }

        static {
            Method[] methodArray = new Method[2];
            methodArray[0] = FINITE_DIFFERENCE;
            methodArray[1] = RIDDERS;
            E = methodArray;
        }
    }
}

