/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentiation.multivariate;

import com.numericalmethod.suanshu.analysis.differentiation.multivariate.FiniteDifference;
import com.numericalmethod.suanshu.analysis.function.rn2r1.Projection;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2rm.RealVectorFunction;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixMeasure;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.List;

public class Jacobian
extends DenseMatrix {
    public Jacobian(RealVectorFunction f2, double ... x) {
        super(f2.dimensionOfRange(), f2.dimensionOfDomain());
        int a2;
        int n = a2 = 1;
        while (n <= this.nRows()) {
            int a3;
            Projection a4 = new Projection(f2, a2);
            int n2 = a3 = 1;
            while (n2 <= this.nCols()) {
                int[] nArray = new int[1];
                nArray[0] = a3;
                FiniteDifference a5 = new FiniteDifference(a4, nArray);
                super.set(a2, a3, a5.evaluate(x));
                n2 = ++a3;
            }
            n = ++a2;
        }
    }

    public Jacobian(RealVectorFunction f2, Vector x) {
        this(f2, x.toArray());
    }

    public double determinant() {
        return MatrixMeasure.det(this);
    }

    public Jacobian(final RealScalarFunction[] f2, double ... x) {
        this(new RealVectorFunction(){

            @Override
            public int dimensionOfDomain() {
                return f2[0].dimensionOfDomain();
            }
            {
                1 a2;
            }

            @Override
            public int dimensionOfRange() {
                return f2.length;
            }

            @Override
            public Vector evaluate(double ... x) {
                int a2;
                double[] a3 = new double[f2.length];
                int n = a2 = 0;
                while (n < f2.length) {
                    double a4;
                    a3[a2] = a4 = f2[a2].evaluate(x);
                    n = ++a2;
                }
                return new DenseVector(a3);
            }
        }, new DenseVector(x));
    }

    public Jacobian(List<RealScalarFunction> f2, double ... x) {
        this(f2.toArray(new RealScalarFunction[0]), x);
    }
}

