/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentiation.multivariate;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

public class FiniteDifference
implements RealScalarFunction {
    public final RealScalarFunction f;
    private final int[] E;

    @Override
    public double evaluate(double ... x) {
        DenseVector a2 = new DenseVector(x);
        double a3 = Math.pow(Constant.MACH_EPS, 1.0 / (double)(this.E.length + 1)) * Math.max(0.1, a2.norm());
        return this.evaluate(x, a3);
    }

    @Override
    public int dimensionOfDomain() {
        return this.f.dimensionOfDomain();
    }

    public double evaluate(double[] x, double h2) {
        return this.evaluateByRecursion(this.E.length, h2, x);
    }

    public double evaluateByRecursion(int n, double h2, double ... z2) {
        double[] a2 = Arrays.copyOf(z2, z2.length);
        if (n == 1) {
            int n2 = this.E[0] - 1;
            a2[n2] = a2[n2] + h2;
            double a3 = this.f.evaluate(a2);
            int n3 = this.E[0] - 1;
            a2[n3] = a2[n3] - 2.0 * h2;
            double a4 = this.f.evaluate(a2);
            double a5 = (a3 - a4) / 2.0 / h2;
            return a5;
        }
        int n4 = this.E[n - 1] - 1;
        a2[n4] = a2[n4] + h2;
        double a6 = this.evaluateByRecursion(n - 1, h2, a2);
        int n5 = this.E[n - 1] - 1;
        a2[n5] = a2[n5] - 2.0 * h2;
        double a7 = this.evaluateByRecursion(n - 1, h2, a2);
        double a8 = (a6 - a7) / 2.0 / h2;
        return a8;
    }

    public FiniteDifference(RealScalarFunction f2, int[] varidx) {
        int a2;
        this.f = f2;
        int n = a2 = 0;
        while (n < varidx.length) {
            if (varidx[a2] < 1 || varidx[a2] > f2.dimensionOfDomain()) {
                throw new IllegalArgumentException("invalid variable specification; order specifiies variable indices");
            }
            n = ++a2;
        }
        this.E = Arrays.copyOf(varidx, varidx.length);
    }

    @Override
    public int dimensionOfRange() {
        return 1;
    }
}

