/*
 * Decompiled with CFR 0.152.
 */
package main;

import lp.constant;
import lp.lprec;
import lp.solve;

public class LpSolveABS
implements constant {
    public static int result;

    public double[] predict(double[] data, int p, double[] MA_array, double[] coef_b) {
        int i;
        double A = -0.01;
        int data_count = data.length;
        double[] new_data = new double[data_count + 1];
        new_data[0] = 0.0;
        System.arraycopy(data, 0, new_data, 1, data_count);
        solve lpSolve = new solve();
        lprec lpIn = new lprec(0, data_count + p * 2);
        double[] minf = new double[data_count + p * 2 + 1];
        double[] rib1 = new double[data_count + p * 2 + 1];
        double[] rib2 = new double[data_count + p * 2 + 1];
        for (i = 1; i <= data_count; ++i) {
            minf[i] = 1.0;
            lpSolve.set_lowbo(lpIn, i, A);
        }
        for (i = data_count + 1; i <= data_count + p * 2; ++i) {
            minf[i] = 0.0;
            lpSolve.set_lowbo(lpIn, i, A);
        }
        lpSolve.set_obj_fn(lpIn, minf);
        lpSolve.set_minim(lpIn);
        for (i = 1; i <= data_count; ++i) {
            for (int j = 1; j <= data_count; ++j) {
                if (i == j) {
                    rib1[j] = 1.0;
                    rib2[j] = -1.0;
                    continue;
                }
                rib1[j] = 0.0;
                rib2[j] = 0.0;
            }
            int a = 1;
            for (int j = 1; j <= p; ++j) {
                if (i - j <= 0) continue;
                rib1[data_count + a] = new_data[i - j];
                rib1[data_count + a + 1] = -1.0 * new_data[i - j];
                rib2[data_count + a] = new_data[i - j];
                rib2[data_count + a + 1] = -1.0 * new_data[i - j];
                a += 2;
            }
            lpSolve.add_constraint(lpIn, rib1, (short)2, new_data[i] + MA_array[i - 1]);
            lpSolve.add_constraint(lpIn, rib2, (short)0, new_data[i] + MA_array[i - 1]);
        }
        try {
            result = lpSolve.solve(lpIn);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            System.out.println("Error2:" + ex);
            result = 1000000;
        }
        if (result == 0) {
            int rows = lpIn.getRows();
            for (int i2 = 1; i2 <= data_count + p * 2; ++i2) {
                minf[i2] = lpIn.getBestSolution(rows + i2);
            }
            double[] coef = new double[p];
            for (int i3 = 0; i3 < p; ++i3) {
                coef[i3] = minf[data_count + i3 + 1] - minf[data_count + p + i3 + 1];
            }
            return coef;
        }
        double[] coef = new double[]{};
        return coef;
    }
}

