/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import main.CSVFileSaveListener;
import main.LoadGraphicListener;
import main.StartApplet;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;

class LoadTestDataABSListener
implements ActionListener {
    private StartApplet applet;
    private int forecast_ABS;
    private double test_error_sum;
    private double bendra_suma2;
    private double bendra_suma3;
    private double bendra_suma4;
    private double bendra_suma5;
    private double[] new_array;
    private double[] new_array_ABS;
    private double[] forecast_array;
    private String[][] data;
    private JPanel test_data_ABS_Panel;
    private JLabel MAE_test_ABS_Label;
    private JLabel MAPE_test_ABS_Label;
    private JLabel PMAD_test_ABS_Label;
    private JLabel MSE_test_ABS_Label;
    private JLabel RMSE_test_ABS_Label;
    private JLabel residual_variance_test_ABS_Label;
    private JLabel MAE_test_value_ABS_Label;
    private JLabel MAPE_test_value_ABS_Label;
    private JLabel PMAD_test_value_ABS_Label;
    private JLabel MSE_test_value_ABS_Label;
    private JLabel RMSE_test_value_ABS_Label;
    private JLabel residual_variance_test_value_ABS_Label;
    private JButton save_test_CSV_ABS_Button;
    private JScrollPane test_data_ABS_Scroll;

    public LoadTestDataABSListener(StartApplet applet) {
        this.applet = applet;
    }

    public void actionPerformed(ActionEvent e) {
        int i;
        this.applet.test_data_ABS_Frame = new JFrame();
        this.applet.test_data_ABS_Frame.setTitle("Test AR-ABS data");
        this.applet.test_data_ABS_Frame.setSize(800, 600);
        this.applet.test_data_ABS_Frame.setVisible(true);
        Object[] titles = new String[]{"No.", "Actual value", "Forecast", "Error"};
        String forecast_string = this.applet.forecast_ABS_Field.getText();
        int forecast_length = forecast_string.length();
        this.forecast_ABS = forecast_length <= 0 ? 1 : Integer.parseInt(this.applet.forecast_ABS_Field.getText());
        this.data = new String[this.applet.entered_data_Count + this.forecast_ABS][5];
        this.applet.forecast_test_ABS_Series = new TimeSeries((Comparable)((Object)"Forecast"), Day.class);
        this.new_array = new double[this.applet.entered_data_Count];
        for (int i2 = 0; i2 < this.applet.entered_data_Count; ++i2) {
            this.data[i2][0] = Integer.toString(i2 + 1) + ".";
            this.data[i2][1] = String.valueOf(this.applet.data_ABS_Table.getValueAt(i2, 1));
            this.new_array[i2] = Double.parseDouble(String.valueOf(this.applet.data_ABS_Table.getValueAt(i2, 1)));
        }
        this.test_error_sum = 0.0;
        this.bendra_suma2 = 0.0;
        this.bendra_suma3 = 0.0;
        this.bendra_suma4 = 0.0;
        this.bendra_suma5 = 0.0;
        this.applet.testing_data_ABS_Count = this.applet.entered_data_Count - Integer.parseInt(this.applet.training_data_ABS_Field.getText());
        int n = 0;
        this.forecast_array = new double[this.applet.testing_data_ABS_Count];
        for (i = this.applet.training_data_ABS_Count; i < this.applet.entered_data_Count; ++i) {
            double suma = 0.0;
            for (int j = 0; j < this.applet.coef_ABS.length; ++j) {
                this.forecast_array[n] = suma += this.applet.coef_ABS[j] * this.new_array[i - j - 1];
            }
            this.data[i][2] = Double.toString(this.applet.round(suma, 3));
            double error = this.new_array[this.applet.training_data_ABS_Count + n] - this.forecast_array[n];
            this.bendra_suma5 += error;
            if (error < 0.0) {
                error *= -1.0;
            }
            this.data[i][3] = Double.toString(this.applet.round(error, 3));
            this.test_error_sum += error;
            this.bendra_suma2 += error / Double.parseDouble(String.valueOf(this.applet.data_ABS_Table.getValueAt(i, 1)));
            this.bendra_suma3 += Double.parseDouble(String.valueOf(this.applet.data_ABS_Table.getValueAt(i, 1)));
            this.bendra_suma4 += error * error;
            Date now = new Date();
            Calendar cal = Calendar.getInstance();
            cal.setTime(now);
            cal.add(6, i + 1);
            Date tomorrow = cal.getTime();
            this.applet.forecast_test_ABS_Series.add((RegularTimePeriod)new Day(tomorrow), this.applet.round(suma, 3));
            ++n;
        }
        this.new_array_ABS = new double[this.forecast_ABS + this.applet.p_value_ABS];
        for (i = this.applet.p_value_ABS; i > 0; --i) {
            this.new_array_ABS[this.applet.p_value_ABS - i] = this.applet.entered_data_ABS[this.applet.entered_data_Count - i];
        }
        this.applet.forecast_ABS_Series.clear();
        int y = 0;
        for (int i3 = this.applet.entered_data_Count; i3 < this.applet.entered_data_Count + this.forecast_ABS; ++i3) {
            this.data[i3][0] = Integer.toString(i3 + 1) + ".";
            double suma = 0.0;
            for (int j = 0; j < this.applet.coef_ABS.length; ++j) {
                suma += this.applet.coef_ABS[j] * this.new_array_ABS[this.applet.p_value_ABS + y - j - 1];
            }
            this.new_array_ABS[this.applet.p_value_ABS + y] = suma;
            this.data[i3][2] = Double.toString(this.applet.round(suma, 3));
            Date now = new Date();
            Calendar cal = Calendar.getInstance();
            cal.setTime(now);
            cal.add(6, i3 + 1);
            Date tomorrow = cal.getTime();
            this.applet.forecast_test_ABS_Series.add((RegularTimePeriod)new Day(tomorrow), this.applet.round(suma, 3));
            ++y;
        }
        this.test_data_ABS_Panel = new JPanel();
        this.test_data_ABS_Panel.setLayout(null);
        this.applet.test_data_ABS_Frame.add(this.test_data_ABS_Panel);
        this.applet.test_data_ABS_Table = new JTable(this.data, titles){

            public Component prepareRenderer(TableCellRenderer renderer, int row, int column2) {
                Component c = super.prepareRenderer(renderer, row, column2);
                if (row >= ((LoadTestDataABSListener)LoadTestDataABSListener.this).applet.training_data_ABS_Count) {
                    c.setBackground(new Color(200, 221, 242));
                } else {
                    c.setBackground(null);
                }
                return c;
            }
        };
        this.test_data_ABS_Scroll = new JScrollPane(this.applet.test_data_ABS_Table);
        this.test_data_ABS_Scroll.setVerticalScrollBarPolicy(22);
        this.test_data_ABS_Scroll.setBounds(10, 10, 400, 337);
        this.test_data_ABS_Panel.add(this.test_data_ABS_Scroll);
        this.applet.graphic_ABS_Button = new JButton("Graphic");
        this.applet.graphic_ABS_Button.setBounds(10, 355, 90, 20);
        LoadGraphicListener Graphic_Listener = new LoadGraphicListener(this.applet, "AR-ABS test data graphic", 4);
        this.applet.graphic_ABS_Button.addActionListener(Graphic_Listener);
        this.test_data_ABS_Panel.add(this.applet.graphic_ABS_Button);
        this.save_test_CSV_ABS_Button = new JButton("Save CSV file");
        this.save_test_CSV_ABS_Button.setBounds(110, 355, 120, 20);
        CSVFileSaveListener test_CSV_file_ABS_Listener = new CSVFileSaveListener(this.applet, 4);
        this.save_test_CSV_ABS_Button.addActionListener(test_CSV_file_ABS_Listener);
        this.test_data_ABS_Panel.add(this.save_test_CSV_ABS_Button);
        this.MAE_test_ABS_Label = new JLabel("Mean absolute error (MAE)");
        this.MAE_test_ABS_Label.setBounds(10, 380, 300, 20);
        this.test_data_ABS_Panel.add(this.MAE_test_ABS_Label);
        this.MAE_test_value_ABS_Label = new JLabel();
        this.MAE_test_value_ABS_Label.setBounds(300, 380, 300, 20);
        this.test_data_ABS_Panel.add(this.MAE_test_value_ABS_Label);
        this.MAPE_test_ABS_Label = new JLabel("Mean absolute percentage error (MAPE)");
        this.MAPE_test_ABS_Label.setBounds(10, 405, 300, 20);
        this.test_data_ABS_Panel.add(this.MAPE_test_ABS_Label);
        this.MAPE_test_value_ABS_Label = new JLabel();
        this.MAPE_test_value_ABS_Label.setBounds(300, 405, 300, 20);
        this.test_data_ABS_Panel.add(this.MAPE_test_value_ABS_Label);
        this.PMAD_test_ABS_Label = new JLabel("Percent mean absolute deviation (PMAD)");
        this.PMAD_test_ABS_Label.setBounds(10, 430, 300, 20);
        this.test_data_ABS_Panel.add(this.PMAD_test_ABS_Label);
        this.PMAD_test_value_ABS_Label = new JLabel();
        this.PMAD_test_value_ABS_Label.setBounds(300, 430, 300, 20);
        this.test_data_ABS_Panel.add(this.PMAD_test_value_ABS_Label);
        this.MSE_test_ABS_Label = new JLabel("Mean squared error (MSE)");
        this.MSE_test_ABS_Label.setBounds(10, 455, 300, 20);
        this.test_data_ABS_Panel.add(this.MSE_test_ABS_Label);
        this.MSE_test_value_ABS_Label = new JLabel();
        this.MSE_test_value_ABS_Label.setBounds(300, 455, 300, 20);
        this.test_data_ABS_Panel.add(this.MSE_test_value_ABS_Label);
        this.RMSE_test_ABS_Label = new JLabel("Root mean squared error (RMSE)");
        this.RMSE_test_ABS_Label.setBounds(10, 480, 300, 20);
        this.test_data_ABS_Panel.add(this.RMSE_test_ABS_Label);
        this.RMSE_test_value_ABS_Label = new JLabel();
        this.RMSE_test_value_ABS_Label.setBounds(300, 480, 300, 20);
        this.test_data_ABS_Panel.add(this.RMSE_test_value_ABS_Label);
        this.residual_variance_test_ABS_Label = new JLabel("Residual variance");
        this.residual_variance_test_ABS_Label.setBounds(10, 505, 300, 20);
        this.test_data_ABS_Panel.add(this.residual_variance_test_ABS_Label);
        this.residual_variance_test_value_ABS_Label = new JLabel();
        this.residual_variance_test_value_ABS_Label.setBounds(300, 505, 300, 20);
        this.test_data_ABS_Panel.add(this.residual_variance_test_value_ABS_Label);
        double MAE = 0.0;
        MAE = this.test_error_sum == Double.NaN || this.test_error_sum == Double.POSITIVE_INFINITY || this.test_error_sum == Double.NEGATIVE_INFINITY ? 0.0 : this.test_error_sum / (double)this.applet.testing_data_ABS_Count;
        this.MAE_test_value_ABS_Label.setText(" = " + Double.toString(this.applet.round(MAE, 3)));
        double MAPE = 0.0;
        MAPE = this.bendra_suma2 == Double.NaN || this.bendra_suma2 == Double.POSITIVE_INFINITY || this.bendra_suma2 == Double.NEGATIVE_INFINITY ? 0.0 : this.bendra_suma2 / (double)this.applet.testing_data_ABS_Count;
        this.MAPE_test_value_ABS_Label.setText(" = " + Double.toString(this.applet.round(MAPE, 3)));
        double PMAD = 0.0;
        PMAD = this.test_error_sum == Double.NaN || this.test_error_sum == Double.POSITIVE_INFINITY || this.test_error_sum == Double.NEGATIVE_INFINITY || this.bendra_suma3 == Double.NaN || this.bendra_suma3 == Double.POSITIVE_INFINITY || this.bendra_suma3 == Double.NEGATIVE_INFINITY || this.test_error_sum == 0.0 || this.bendra_suma3 == 0.0 ? 0.0 : this.test_error_sum / this.bendra_suma3;
        this.PMAD_test_value_ABS_Label.setText(" = " + Double.toString(this.applet.round(PMAD, 3)));
        double MSE = 0.0;
        MSE = this.bendra_suma4 == Double.NaN || this.bendra_suma4 == Double.POSITIVE_INFINITY || this.bendra_suma4 == Double.NEGATIVE_INFINITY ? 0.0 : this.bendra_suma4 / (double)this.applet.testing_data_ABS_Count;
        this.MSE_test_value_ABS_Label.setText(" = " + Double.toString(this.applet.round(MSE, 3)));
        double RMSE = 0.0;
        RMSE = MSE == 0.0 ? 0.0 : Math.sqrt(MSE);
        this.RMSE_test_value_ABS_Label.setText(" = " + Double.toString(this.applet.round(RMSE, 3)));
        double residual_variance = 0.0;
        residual_variance = (this.bendra_suma4 - this.bendra_suma5 * this.bendra_suma5 / (double)this.applet.testing_data_ABS_Count) / (double)(this.applet.testing_data_ABS_Count - 1);
        this.residual_variance_test_value_ABS_Label.setText(" = " + Double.toString(this.applet.round(residual_variance, 3)));
    }
}

