/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import main.StartApplet;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

class LoadGraphicListener
implements ActionListener {
    private StartApplet applet;
    private String title;
    int model_number;

    public LoadGraphicListener(StartApplet applet, String title, int model_number) {
        this.applet = applet;
        this.title = title;
        this.model_number = model_number;
    }

    public void actionPerformed(ActionEvent e) {
        this.applet.graphicFrame = new JFrame();
        this.applet.graphicFrame.setTitle(this.title);
        this.applet.graphicFrame.setSize(500, 300);
        this.applet.graphicFrame.setVisible(true);
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.setDomainIsPointsInTime(true);
        switch (this.model_number) {
            case 1: {
                dataset.addSeries(this.applet.real_AR_Series);
                dataset.addSeries(this.applet.forecast_AR_Series);
                break;
            }
            case 2: {
                dataset.addSeries(this.applet.real_ABS_Series);
                dataset.addSeries(this.applet.forecast_ABS_Series);
                break;
            }
            case 3: {
                dataset.addSeries(this.applet.real_AR_Series);
                dataset.addSeries(this.applet.forecast_test_AR_Series);
                break;
            }
            case 4: {
                dataset.addSeries(this.applet.real_ABS_Series);
                dataset.addSeries(this.applet.forecast_test_ABS_Series);
                break;
            }
            case 5: {
                dataset.addSeries(this.applet.real_ARMAABS_Series);
                dataset.addSeries(this.applet.forecast_ARMAABS_Series);
            }
        }
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)"Stock price", (String)"Date", (String)"Stock price", (XYDataset)dataset, (boolean)true, (boolean)false, (boolean)false);
        chart.setBackgroundPaint((Paint)new Color(240, 240, 240));
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)new Color(191, 191, 191));
        plot.setRangeGridlinePaint((Paint)new Color(191, 191, 191));
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setBounds(10, 430, 500, 300);
        this.applet.graphicFrame.add((Component)chartPanel);
    }
}

