/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.StringTokenizer;
import main.AR_method;
import main.CSVFileReader;
import main.StartApplet;

class ExpRunListener
implements ActionListener {
    StartApplet applet;
    int[] indicators_array;
    int[] entered_p;
    int count_p;
    double[] coef_AR;

    public ExpRunListener(StartApplet applet) {
        this.applet = applet;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            int start_month = this.applet.exp_start_month_Box.getSelectedIndex();
            String start_day = this.applet.exp_start_day_Field.getText();
            String start_year = this.applet.exp_start_year_Field.getText();
            int end_month = this.applet.exp_end_month_Box.getSelectedIndex();
            String end_day = this.applet.exp_end_day_Field.getText();
            String end_year = this.applet.exp_end_year_Field.getText();
            this.indicators_array = new int[8];
            if (this.applet.data_mean_CheckBox.isSelected()) {
                this.indicators_array[0] = 1;
            }
            if (this.applet.data_standard_CheckBox.isSelected()) {
                this.indicators_array[1] = 1;
            }
            if (this.applet.MAE_CheckBox.isSelected()) {
                this.indicators_array[2] = 1;
            }
            if (this.applet.MAPE_CheckBox.isSelected()) {
                this.indicators_array[3] = 1;
            }
            if (this.applet.PMAD_CheckBox.isSelected()) {
                this.indicators_array[4] = 1;
            }
            if (this.applet.MSE_CheckBox.isSelected()) {
                this.indicators_array[5] = 1;
            }
            if (this.applet.RMSE_CheckBox.isSelected()) {
                this.indicators_array[6] = 1;
            }
            if (this.applet.residual_variance_CheckBox.isSelected()) {
                this.indicators_array[7] = 1;
            }
            int count_indicators = 0;
            for (int i = 0; i < this.indicators_array.length; ++i) {
                if (this.indicators_array[i] != 1) continue;
                ++count_indicators;
            }
            System.out.println("count indicators = " + count_indicators);
            if (!this.applet.exp_p_Area.getText().equals("")) {
                String line = this.applet.exp_p_Area.getText();
                StringTokenizer t = new StringTokenizer(line, "\n");
                this.count_p = t.countTokens();
                this.entered_p = new int[this.count_p];
                int k = 0;
                while (t.hasMoreTokens()) {
                    this.entered_p[k] = Integer.parseInt(t.nextToken());
                    ++k;
                }
                System.out.println("count p = " + this.count_p);
            }
            String[] symbol = new String[]{"GOOG", "AAPL"};
            for (int i = 0; i < symbol.length; ++i) {
                for (int j = 0; j < this.count_p; ++j) {
                    URL yahooUrl = new URL("http://ichart.finance.yahoo.com/table.csv?s=" + symbol[i] + "&a=" + start_month + "&b=" + start_day + "&c=" + start_year + "&d=" + end_month + "&e=" + end_day + "&f=" + end_year + "&g=d&ignore=.csv");
                    URLConnection yc = yahooUrl.openConnection();
                    CSVFileReader csv = new CSVFileReader(new InputStreamReader(yc.getInputStream()));
                    csv.ReadFileFromURL();
                    ArrayList<String> a = csv.getArrayList();
                    String[][] data = new String[a.size() - 1][7];
                    double[] data2 = new double[a.size() - 1];
                    double[] forecast = new double[a.size() - 1];
                    double[] errors = new double[a.size() - 1 - this.entered_p[j]];
                    double training_error_sum = 0.0;
                    double bendra_suma2 = 0.0;
                    double bendra_suma3 = 0.0;
                    double bendra_suma4 = 0.0;
                    for (int k = 1; k < a.size(); ++k) {
                        data[k - 1] = a.get(k).split(",");
                        data2[a.size() - k - 1] = Double.parseDouble(data[k - 1][6]);
                    }
                    AR_method ar_ = null;
                    ar_ = new AR_method(data2, this.entered_p[j]);
                    this.coef_AR = ar_.rezult();
                    for (int m = this.entered_p[j]; m < data2.length; ++m) {
                        for (int n = 0; n < this.coef_AR.length; ++n) {
                            int n2 = m;
                            forecast[n2] = forecast[n2] + this.coef_AR[n] * data2[m - n - 1];
                        }
                        double error = data2[m] - forecast[m];
                        if (error < 0.0) {
                            error *= -1.0;
                        }
                        errors[m - this.entered_p[j]] = error;
                        training_error_sum += error;
                        bendra_suma2 += error / data2[m];
                        bendra_suma3 += data2[m];
                        bendra_suma4 += error * error;
                    }
                    double data_mean = 0.0;
                    double training_data_sum = 0.0;
                    double training_data_sum2 = 0.0;
                    for (int m = 0; m < data2.length; ++m) {
                        training_data_sum += data2[m];
                        training_data_sum2 += data2[m] * data2[m];
                    }
                    data_mean = training_data_sum / (double)data2.length;
                    if (this.applet.data_mean_CheckBox.isSelected()) {
                        System.out.println("Data mean = " + this.applet.round(data_mean, 3));
                    }
                    double data_variance = 0.0;
                    data_variance = (training_data_sum2 - training_data_sum * training_data_sum / (double)data2.length) / (double)(data2.length - 1);
                    if (this.applet.data_standard_CheckBox.isSelected()) {
                        System.out.println("Data variance = " + this.applet.round(data_variance, 3));
                    }
                    double MAE = 0.0;
                    MAE = training_error_sum == Double.NaN || training_error_sum == Double.POSITIVE_INFINITY || training_error_sum == Double.NEGATIVE_INFINITY || training_error_sum == 0.0 ? 0.0 : training_error_sum / (double)errors.length;
                    if (this.applet.MAE_CheckBox.isSelected()) {
                        System.out.println("MAE = " + this.applet.round(MAE, 3));
                    }
                    double MAPE = 0.0;
                    MAPE = bendra_suma2 == Double.NaN || bendra_suma2 == Double.POSITIVE_INFINITY || bendra_suma2 == Double.NEGATIVE_INFINITY || training_error_sum == 0.0 ? 0.0 : bendra_suma2 / (double)errors.length;
                    if (this.applet.MAPE_CheckBox.isSelected()) {
                        System.out.println("MAPE = " + this.applet.round(MAPE, 3));
                    }
                    double PMAD = 0.0;
                    PMAD = training_error_sum == Double.NaN || training_error_sum == Double.POSITIVE_INFINITY || training_error_sum == Double.NEGATIVE_INFINITY || bendra_suma3 == Double.NaN || bendra_suma3 == Double.POSITIVE_INFINITY || bendra_suma3 == Double.NEGATIVE_INFINITY || training_error_sum == 0.0 || bendra_suma3 == 0.0 ? 0.0 : training_error_sum / bendra_suma3;
                    if (this.applet.PMAD_CheckBox.isSelected()) {
                        System.out.println("PMAD = " + this.applet.round(PMAD, 3));
                    }
                    double MSE = 0.0;
                    MSE = bendra_suma4 == Double.NaN || bendra_suma4 == Double.POSITIVE_INFINITY || bendra_suma4 == Double.NEGATIVE_INFINITY || bendra_suma4 == 0.0 ? 0.0 : bendra_suma4 / (double)errors.length;
                    if (!this.applet.MSE_CheckBox.isSelected()) continue;
                    System.out.println("MSE = " + this.applet.round(MSE, 3));
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Unable to run experiment: " + ex);
        }
    }
}

