/*
 * Decompiled with CFR 0.152.
 */
package main;

import Jama.Matrix;

public class AR_method {
    private double[] data;
    private int p;
    private int m;
    private int n;
    private double det;
    private double[][] A;
    private double[][] B;
    private double[] X;

    public AR_method(double[] v, int p) {
        this.p = p;
        this.data = v;
        this.n = v.length;
        this.m = this.n - this.p;
    }

    public void A_() {
        this.A = new double[this.p][this.p];
        for (int i = 0; i < this.p; ++i) {
            for (int j = 0; j < this.p; ++j) {
                for (int k = this.data.length - 1; k > this.data.length - 1 - this.m; --k) {
                    double[] dArray = this.A[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.data[k - j - 1] * this.data[k - i - 1];
                }
            }
        }
    }

    public void B_() {
        this.B = new double[this.p][1];
        for (int i = 0; i < this.p; ++i) {
            for (int j = this.data.length - 1; j > this.data.length - 1 - this.m; --j) {
                double[] dArray = this.B[i];
                dArray[0] = dArray[0] + this.data[j] * this.data[j - i - 1];
            }
        }
    }

    public double[] rezult() {
        this.A_();
        this.B_();
        Matrix A_matrix = new Matrix(this.A);
        this.det = A_matrix.det();
        Matrix b_matrix = new Matrix(this.B);
        while (this.det < 0.05) {
            --this.p;
            this.A_();
            this.B_();
            A_matrix = new Matrix(this.A);
            this.det = A_matrix.det();
            b_matrix = new Matrix(this.B);
        }
        Matrix x_matrix = A_matrix.solve(b_matrix);
        double[][] temp = x_matrix.getArrayCopy();
        this.X = new double[this.p];
        for (int i = 0; i < temp.length; ++i) {
            this.X[i] = temp[i][0];
        }
        return this.X;
    }

    public void printB() {
        System.out.println("matrica B ------------------------");
        for (int i = 0; i < this.B.length; ++i) {
            System.out.println(this.B[i][0]);
        }
        System.out.println("matrica B ------------------------");
    }

    public void printA() {
        System.out.println("matrica A ------------------------");
        for (int i = 0; i < this.p; ++i) {
            String s = "";
            for (int j = 0; j < this.p; ++j) {
                double temp2 = Math.round(this.A[i][j] * 100.0);
                s = s + (temp2 /= 100.0) + " ";
            }
            System.out.println(s);
        }
        System.out.println("matrica A ------------------------");
    }

    private void printData() {
        System.out.println("matrica DATA ------------------------");
        for (int i = 0; i < this.data.length; ++i) {
            System.out.println(this.data[i]);
        }
        System.out.println("matrica DATA ------------------------");
    }
}

