/*
 * Decompiled with CFR 0.152.
 */
package lp;

import java.io.PrintStream;
import java.util.Random;
import java.util.StringTokenizer;
import lp.Ref;
import lp.Util;
import lp.constant;
import lp.lprec;
import lp.matrec;

public class solve
implements constant {
    lprec Lp;
    int Rows;
    int Columns;
    int Sum;
    int Non_zeros;
    int Level;
    matrec[] Mat;
    int[] Col_no;
    int[] Col_end;
    int[] Row_end;
    double[] Orig_rh;
    double[] Rh;
    double[] Rhs;
    short[] Must_be_int;
    double[] Orig_upbo;
    double[] Orig_lowbo;
    double[] Upbo;
    double[] Lowbo;
    int[] Bas;
    short[] Basis;
    short[] Lower;
    int Eta_alloc;
    int Eta_size;
    double[] Eta_value;
    int[] Eta_row_nr;
    int[] Eta_col_end;
    int Num_inv;
    double[] Solution;
    double[] Best_solution;
    double Infinite;
    double Epsilon;
    double Epsb;
    double Epsd;
    double Epsel;
    double TREJ;
    double TINV;
    short Maximise;
    short Floor_first;
    double Extrad;
    int Warn_count;
    short JustInverted;
    short Status;
    short Doiter;
    short DoInvert;
    short Break_bb;

    void inc_mat_space(lprec lp, int maxextra) {
        if (lp.non_zeros + maxextra > lp.mat_alloc) {
            lp.mat_alloc = lp.non_zeros + maxextra;
            matrec[] old_mat = lp.mat;
            lp.mat = new matrec[lp.mat_alloc];
            for (int i = old_mat.length; i < lp.mat.length; ++i) {
                lp.mat[i] = new matrec(0, 0.0);
            }
            System.arraycopy(old_mat, 0, lp.mat, 0, old_mat.length);
            int[] old_col_no = lp.col_no;
            lp.col_no = new int[lp.mat_alloc];
            System.arraycopy(old_col_no, 0, lp.col_no, 0, old_col_no.length);
            if (lp.active != 0) {
                this.Mat = lp.mat;
                this.Col_no = lp.col_no;
            }
        }
    }

    void inc_row_space(lprec lp) {
        if (lp.rows > lp.rows_alloc) {
            lp.rows_alloc = lp.rows + 10;
            lp.sum_alloc = lp.rows_alloc + lp.columns_alloc;
            double[] db_ptr = lp.orig_rh;
            lp.orig_rh = new double[lp.rows_alloc + 1];
            System.arraycopy(db_ptr, 0, lp.orig_rh, 0, db_ptr.length);
            db_ptr = lp.rh;
            lp.rh = new double[lp.rows_alloc + 1];
            System.arraycopy(db_ptr, 0, lp.rh, 0, db_ptr.length);
            db_ptr = lp.rhs;
            lp.rhs = new double[lp.rows_alloc + 1];
            System.arraycopy(db_ptr, 0, lp.rhs, 0, db_ptr.length);
            db_ptr = lp.orig_upbo;
            lp.orig_upbo = new double[lp.sum_alloc + 1];
            System.arraycopy(db_ptr, 0, lp.orig_upbo, 0, db_ptr.length);
            db_ptr = lp.upbo;
            lp.upbo = new double[lp.sum_alloc + 1];
            System.arraycopy(db_ptr, 0, lp.upbo, 0, db_ptr.length);
            db_ptr = lp.orig_lowbo;
            lp.orig_lowbo = new double[lp.sum_alloc + 1];
            System.arraycopy(db_ptr, 0, lp.orig_lowbo, 0, db_ptr.length);
            db_ptr = lp.lowbo;
            lp.lowbo = new double[lp.sum_alloc + 1];
            System.arraycopy(db_ptr, 0, lp.lowbo, 0, db_ptr.length);
            db_ptr = lp.solution;
            lp.solution = new double[lp.sum_alloc + 1];
            System.arraycopy(db_ptr, 0, lp.solution, 0, db_ptr.length);
            db_ptr = lp.best_solution;
            lp.best_solution = new double[lp.sum_alloc + 1];
            System.arraycopy(db_ptr, 0, lp.best_solution, 0, db_ptr.length);
            int[] int_ptr = lp.row_end;
            lp.row_end = new int[lp.rows_alloc + 1];
            System.arraycopy(int_ptr, 0, lp.row_end, 0, int_ptr.length);
            short[] short_ptr = lp.basis;
            lp.basis = new short[lp.sum_alloc + 1];
            System.arraycopy(short_ptr, 0, lp.basis, 0, short_ptr.length);
            short_ptr = lp.lower;
            lp.lower = new short[lp.sum_alloc + 1];
            System.arraycopy(short_ptr, 0, lp.lower, 0, short_ptr.length);
            short_ptr = lp.must_be_int;
            lp.must_be_int = new short[lp.sum_alloc + 1];
            System.arraycopy(short_ptr, 0, lp.must_be_int, 0, short_ptr.length);
            int_ptr = lp.bas;
            lp.bas = new int[lp.rows_alloc + 1];
            System.arraycopy(int_ptr, 0, lp.bas, 0, int_ptr.length);
            db_ptr = lp.duals;
            lp.duals = new double[lp.rows_alloc + 1];
            System.arraycopy(db_ptr, 0, lp.duals, 0, db_ptr.length);
            short_ptr = lp.ch_sign;
            lp.ch_sign = new short[lp.rows_alloc + 1];
            System.arraycopy(short_ptr, 0, lp.ch_sign, 0, short_ptr.length);
            int_ptr = lp.eta_col_end;
            lp.eta_col_end = new int[lp.rows_alloc + lp.max_num_inv];
            System.arraycopy(int_ptr, 0, lp.eta_col_end, 0, int_ptr.length);
            if (lp.names_used != 0) {
                String[] str_ptr = lp.row_name;
                lp.row_name = new String[lp.rows_alloc + 1];
                System.arraycopy(str_ptr, 0, lp.row_name, 0, str_ptr.length);
            }
            if (lp.scaling_used != 0) {
                db_ptr = lp.scale;
                lp.scale = new double[lp.sum_alloc + 1];
                System.arraycopy(db_ptr, 0, lp.scale, 0, db_ptr.length);
            }
            if (lp.active != 0) {
                this.set_globals(lp);
            }
        }
    }

    void inc_col_space(lprec lp) {
        if (lp.columns >= lp.columns_alloc) {
            lp.columns_alloc = lp.columns + 10;
            lp.sum_alloc = lp.rows_alloc + lp.columns_alloc;
            short[] short_ptr = lp.must_be_int;
            lp.must_be_int = new short[lp.sum_alloc + 1];
            System.arraycopy(short_ptr, 0, lp.must_be_int, 0, short_ptr.length);
            double[] double_ptr = lp.orig_upbo;
            lp.orig_upbo = new double[lp.sum_alloc + 1];
            System.arraycopy(double_ptr, 0, lp.orig_upbo, 0, double_ptr.length);
            double_ptr = lp.upbo;
            lp.upbo = new double[lp.sum_alloc + 1];
            System.arraycopy(double_ptr, 0, lp.upbo, 0, double_ptr.length);
            double_ptr = lp.orig_lowbo;
            lp.orig_lowbo = new double[lp.sum_alloc + 1];
            System.arraycopy(double_ptr, 0, lp.orig_lowbo, 0, double_ptr.length);
            double_ptr = lp.lowbo;
            lp.lowbo = new double[lp.sum_alloc + 1];
            System.arraycopy(double_ptr, 0, lp.lowbo, 0, double_ptr.length);
            double_ptr = lp.solution;
            lp.solution = new double[lp.sum_alloc + 1];
            System.arraycopy(double_ptr, 0, lp.solution, 0, double_ptr.length);
            double_ptr = lp.best_solution;
            lp.best_solution = new double[lp.sum_alloc + 1];
            System.arraycopy(double_ptr, 0, lp.best_solution, 0, double_ptr.length);
            short_ptr = lp.basis;
            lp.basis = new short[lp.sum_alloc + 1];
            System.arraycopy(short_ptr, 0, lp.basis, 0, short_ptr.length);
            short_ptr = lp.lower;
            lp.lower = new short[lp.sum_alloc + 1];
            System.arraycopy(short_ptr, 0, lp.lower, 0, short_ptr.length);
            if (lp.names_used != 0) {
                String[] str_ptr = lp.col_name;
                lp.col_name = new String[lp.columns_alloc + 1];
                System.arraycopy(str_ptr, 0, lp.col_name, 0, str_ptr.length);
            }
            if (lp.scaling_used != 0) {
                double_ptr = lp.scale;
                lp.scale = new double[lp.sum_alloc + 1];
                System.arraycopy(double_ptr, 0, lp.scale, 0, double_ptr.length);
            }
            int[] int_ptr = lp.col_end;
            lp.col_end = new int[lp.columns_alloc + 1];
            System.arraycopy(int_ptr, 0, lp.col_end, 0, int_ptr.length);
            if (lp.active != 0) {
                this.set_globals(lp);
            }
        }
    }

    public void set_mat(lprec lp, int Row, int Column, double Value) {
        int elmnr;
        if (Row > lp.rows || Row < 0) {
            System.err.print("Row out of range");
        }
        if (Column > lp.columns || Column < 1) {
            System.err.print("Column out of range");
        }
        if (lp.scaling_used != 0) {
            Value *= lp.scale[Row] * lp.scale[lp.rows + Column];
        }
        if (lp.basis[Column] == 1 && Row > 0) {
            lp.basis_valid = 0;
        }
        lp.eta_valid = 0;
        for (elmnr = lp.col_end[Column - 1]; elmnr < lp.col_end[Column] && lp.mat[elmnr].row_nr != Row; ++elmnr) {
        }
        if (elmnr != lp.col_end[Column] && lp.mat[elmnr].row_nr == Row) {
            lp.mat[elmnr].value = lp.scaling_used != 0 ? (lp.ch_sign[Row] != 0 ? -Value * lp.scale[Row] * lp.scale[Column] : Value * lp.scale[Row] * lp.scale[Column]) : (lp.ch_sign[Row] != 0 ? -Value : Value);
        } else {
            int lastelm;
            int i;
            this.inc_mat_space(lp, 1);
            for (i = lastelm = lp.non_zeros; i > elmnr; --i) {
                lp.mat[i] = lp.mat[i - 1];
            }
            i = Column;
            while (i <= lp.columns) {
                int n = i++;
                lp.col_end[n] = lp.col_end[n] + 1;
            }
            lp.mat[elmnr].row_nr = Row;
            lp.mat[elmnr].value = lp.scaling_used != 0 ? (lp.ch_sign[Row] != 0 ? -Value * lp.scale[Row] * lp.scale[Column] : Value * lp.scale[Row] * lp.scale[Column]) : (lp.ch_sign[Row] != 0 ? -Value : Value);
            lp.row_end_valid = 0;
            ++lp.non_zeros;
            if (lp.active != 0) {
                this.Non_zeros = lp.non_zeros;
            }
        }
    }

    public void set_obj_fn(lprec lp, double[] row) {
        for (int i = 1; i <= lp.columns; ++i) {
            this.set_mat(lp, 0, i, row[i]);
        }
    }

    public void str_set_obj_fn(lprec lp, String row) {
        double[] arow = new double[lp.columns + 1];
        int i = 0;
        StringTokenizer stk = new StringTokenizer(row);
        while (stk.hasMoreTokens() && i < lp.columns) {
            arow[++i] = Double.valueOf(stk.nextToken());
        }
        if (i < lp.columns) {
            System.err.println("Not enough numbers in the string in str_set_obj_fn");
            System.exit(-1);
        }
        this.set_obj_fn(lp, arow);
    }

    public void add_constraint(lprec lp, double[] row, short constr_type, double rh) {
        int i;
        short[] addtoo = new short[lp.columns + 1];
        for (i = 1; i <= lp.columns; ++i) {
            if (row[i] != 0.0) {
                addtoo[i] = 1;
                ++lp.non_zeros;
                continue;
            }
            addtoo[i] = 0;
        }
        matrec[] newmat = new matrec[lp.non_zeros];
        for (i = 0; i < newmat.length; ++i) {
            newmat[i] = new matrec(0, 0.0);
        }
        this.inc_mat_space(lp, 0);
        ++lp.rows;
        ++lp.sum;
        this.inc_row_space(lp);
        if (lp.scaling_used != 0) {
            for (i = lp.sum; i > lp.rows; --i) {
                lp.scale[i] = lp.scale[i - 1];
            }
            lp.scale[lp.rows] = 1.0;
        }
        if (lp.names_used != 0) {
            lp.row_name[lp.rows] = new String("r_" + lp.rows);
        }
        if (lp.scaling_used != 0 && lp.columns_scaled != 0) {
            for (i = 1; i <= lp.columns; ++i) {
                int n = i;
                row[n] = row[n] * lp.scale[lp.rows + i];
            }
        }
        lp.ch_sign[lp.rows] = constr_type == 2 ? (short)1 : 0;
        int elmnr = 0;
        int stcol = 0;
        for (i = 1; i <= lp.columns; ++i) {
            for (int j = stcol; j < lp.col_end[i]; ++j) {
                newmat[elmnr].row_nr = lp.mat[j].row_nr;
                newmat[elmnr].value = lp.mat[j].value;
                ++elmnr;
            }
            if (addtoo[i] != 0) {
                newmat[elmnr].value = lp.ch_sign[lp.rows] != 0 ? -row[i] : row[i];
                newmat[elmnr].row_nr = lp.rows;
            }
            stcol = lp.col_end[i];
            lp.col_end[i] = ++elmnr;
        }
        lp.mat = newmat;
        for (i = lp.sum; i > lp.rows; --i) {
            lp.orig_upbo[i] = lp.orig_upbo[i - 1];
            lp.orig_lowbo[i] = lp.orig_lowbo[i - 1];
            lp.basis[i] = lp.basis[i - 1];
            lp.lower[i] = lp.lower[i - 1];
            lp.must_be_int[i] = lp.must_be_int[i - 1];
        }
        for (i = 1; i <= lp.rows; ++i) {
            if (lp.bas[i] < lp.rows) continue;
            int n = i;
            lp.bas[n] = lp.bas[n] + 1;
        }
        if (constr_type == 0 || constr_type == 2) {
            lp.orig_upbo[lp.rows] = lp.infinite;
        } else if (constr_type == 1) {
            lp.orig_upbo[lp.rows] = 0.0;
        } else {
            System.err.print("Wrong constraint type\n");
            System.exit(-1);
        }
        lp.orig_lowbo[lp.rows] = 0.0;
        lp.orig_rh[lp.rows] = constr_type == 2 && rh != 0.0 ? -rh : rh;
        lp.row_end_valid = 0;
        lp.bas[lp.rows] = lp.rows;
        lp.basis[lp.rows] = 1;
        lp.lower[lp.rows] = 1;
        if (lp.active != 0) {
            this.set_globals(lp);
        }
        lp.eta_valid = 0;
    }

    public void str_add_constraint(lprec lp, String row_string, short constr_type, double rh) {
        int i = 0;
        double[] aRow = new double[lp.columns + 1];
        StringTokenizer stk = new StringTokenizer(row_string);
        while (stk.hasMoreTokens() && i < lp.columns) {
            aRow[++i] = Double.valueOf(stk.nextToken());
        }
        this.add_constraint(lp, aRow, constr_type, rh);
    }

    public void del_constraint(lprec lp, int del_row) {
        int i;
        if (del_row < 1 || del_row > lp.rows) {
            System.err.println("There is no constraint nr. " + del_row);
            System.exit(-1);
        }
        int elmnr = 0;
        int startcol = 0;
        for (i = 1; i <= lp.columns; ++i) {
            for (int j = startcol; j < lp.col_end[i]; ++j) {
                if (lp.mat[j].row_nr != del_row) {
                    lp.mat[elmnr] = lp.mat[j];
                    if (lp.mat[elmnr].row_nr > del_row) {
                        --lp.mat[elmnr].row_nr;
                    }
                    ++elmnr;
                    continue;
                }
                --lp.non_zeros;
            }
            startcol = lp.col_end[i];
            lp.col_end[i] = elmnr;
        }
        for (i = del_row; i < lp.rows; ++i) {
            lp.orig_rh[i] = lp.orig_rh[i + 1];
            lp.ch_sign[i] = lp.ch_sign[i + 1];
            lp.bas[i] = lp.bas[i + 1];
            if (lp.names_used == 0) continue;
            lp.row_name[i] = lp.row_name[i + 1];
        }
        for (i = 1; i < lp.rows; ++i) {
            if (lp.bas[i] <= del_row) continue;
            int n = i;
            lp.bas[n] = lp.bas[n] - 1;
        }
        for (i = del_row; i < lp.sum; ++i) {
            lp.lower[i] = lp.lower[i + 1];
            lp.basis[i] = lp.basis[i + 1];
            lp.orig_upbo[i] = lp.orig_upbo[i + 1];
            lp.orig_lowbo[i] = lp.orig_lowbo[i + 1];
            lp.must_be_int[i] = lp.must_be_int[i + 1];
            if (lp.scaling_used == 0) continue;
            lp.scale[i] = lp.scale[i + 1];
        }
        --lp.rows;
        --lp.sum;
        lp.row_end_valid = 0;
        if (lp.active != 0) {
            this.set_globals(lp);
        }
        lp.eta_valid = 0;
        lp.basis_valid = 0;
    }

    public void add_lag_con(lprec lp, double[] row, short con_type, double rhs) {
        int i;
        double sign = 0.0;
        if (con_type == 0 || con_type == 1) {
            sign = 1.0;
        } else if (con_type == 2) {
            sign = -1.0;
        } else {
            System.err.print("con_type not implemented\n");
        }
        ++lp.nr_lagrange;
        if (lp.nr_lagrange == 1) {
            lp.lag_row = new double[lp.nr_lagrange][];
            lp.lag_rhs = new double[lp.nr_lagrange];
            lp.lambda = new double[lp.nr_lagrange];
            lp.lag_con_type = new short[lp.nr_lagrange];
            for (i = 0; i < lp.nr_lagrange; ++i) {
                lp.lag_rhs[i] = 0.0;
                lp.lambda[i] = 0.0;
                lp.lag_con_type[i] = 0;
            }
        } else {
            double[][] db2_ptr = lp.lag_row;
            lp.lag_row = new double[lp.nr_lagrange][];
            System.arraycopy(db2_ptr, 0, lp.lag_row, 0, db2_ptr.length);
            double[] db_ptr = lp.lag_rhs;
            lp.lag_rhs = new double[lp.nr_lagrange];
            System.arraycopy(db_ptr, 0, lp.lag_rhs, 0, db_ptr.length);
            db_ptr = lp.lambda;
            lp.lambda = new double[lp.nr_lagrange];
            System.arraycopy(db_ptr, 0, lp.lambda, 0, db_ptr.length);
            short[] short_ptr = lp.lag_con_type;
            lp.lag_con_type = new short[lp.nr_lagrange];
            System.arraycopy(short_ptr, 0, lp.lag_con_type, 0, short_ptr.length);
        }
        lp.lag_row[lp.nr_lagrange - 1] = new double[lp.columns + 1];
        lp.lag_rhs[lp.nr_lagrange - 1] = rhs * sign;
        for (i = 1; i <= lp.columns; ++i) {
            lp.lag_row[lp.nr_lagrange - 1][i] = row[i] * sign;
        }
        lp.lambda[lp.nr_lagrange - 1] = 0.0;
        lp.lag_con_type[lp.nr_lagrange - 1] = con_type == 1 ? (short)1 : 0;
    }

    public void str_add_lag_con(lprec lp, String row, short con_type, double rhs) {
        int i = 0;
        double[] a_row = new double[lp.columns + 1];
        StringTokenizer stk = new StringTokenizer(row);
        while (stk.hasMoreTokens() && i < lp.columns) {
            a_row[++i] = Double.valueOf(stk.nextToken());
        }
        if (i < lp.columns) {
            System.err.println("not enough value for str_add_lag_con");
            System.exit(-1);
        }
        this.add_lag_con(lp, a_row, con_type, rhs);
    }

    public void add_column(lprec lp, double[] column2) {
        int i;
        ++lp.columns;
        ++lp.sum;
        this.inc_col_space(lp);
        this.inc_mat_space(lp, lp.rows + 1);
        if (lp.scaling_used != 0) {
            for (i = 0; i <= lp.rows; ++i) {
                int n = i;
                column2[n] = column2[n] * lp.scale[i];
            }
            lp.scale[lp.sum] = 1.0;
        }
        int elmnr = lp.col_end[lp.columns - 1];
        for (i = 0; i <= lp.rows; ++i) {
            if (column2[i] == 0.0) continue;
            lp.mat[elmnr].row_nr = i;
            lp.mat[elmnr].value = lp.ch_sign[i] != 0 ? -column2[i] : column2[i];
            ++lp.non_zeros;
            ++elmnr;
        }
        lp.col_end[lp.columns] = elmnr;
        lp.orig_lowbo[lp.sum] = 0.0;
        lp.orig_upbo[lp.sum] = lp.infinite;
        lp.lower[lp.sum] = 1;
        lp.basis[lp.sum] = 0;
        lp.must_be_int[lp.sum] = 0;
        if (lp.names_used != 0) {
            lp.col_name[lp.columns] = new String("var_" + lp.columns);
        }
        lp.row_end_valid = 0;
        if (lp.active != 0) {
            this.Sum = lp.sum;
            this.Columns = lp.columns;
            this.Non_zeros = lp.non_zeros;
        }
    }

    public void str_add_column(lprec lp, String col_string) {
        int i = 0;
        double[] aCol = new double[lp.rows + 1];
        StringTokenizer stk = new StringTokenizer(col_string);
        while (stk.hasMoreTokens() && i < lp.rows) {
            aCol[++i] = Double.valueOf(stk.nextToken());
        }
        if (i < lp.rows) {
            System.err.println("Bad String in str_add_column");
            System.exit(-1);
        }
        this.add_column(lp, aCol);
    }

    public void del_column(lprec lp, int column2) {
        int i;
        if (column2 > lp.columns || column2 < 1) {
            System.err.print("Column out of range in del_column");
        }
        for (i = 1; i <= lp.rows; ++i) {
            if (lp.bas[i] == lp.rows + column2) {
                lp.basis_valid = 0;
                continue;
            }
            if (lp.bas[i] <= lp.rows + column2) continue;
            int n = i;
            lp.bas[n] = lp.bas[n] - 1;
        }
        for (i = lp.rows + column2; i < lp.sum; ++i) {
            if (lp.names_used != 0) {
                lp.col_name[i - lp.rows] = lp.col_name[i - lp.rows + 1];
            }
            lp.must_be_int[i] = lp.must_be_int[i + 1];
            lp.orig_upbo[i] = lp.orig_upbo[i + 1];
            lp.orig_lowbo[i] = lp.orig_lowbo[i + 1];
            lp.upbo[i] = lp.upbo[i + 1];
            lp.lowbo[i] = lp.lowbo[i + 1];
            lp.basis[i] = lp.basis[i + 1];
            lp.lower[i] = lp.lower[i + 1];
            if (lp.scaling_used == 0) continue;
            lp.scale[i] = lp.scale[i + 1];
        }
        for (i = 0; i < lp.nr_lagrange; ++i) {
            for (int j = column2; j <= lp.columns; ++j) {
                lp.lag_row[i][j] = lp.lag_row[i][j + 1];
            }
        }
        int to_elm = lp.col_end[column2 - 1];
        int from_elm = lp.col_end[column2];
        int elm_in_col = from_elm - to_elm;
        for (i = from_elm; i < lp.non_zeros; ++i) {
            lp.mat[to_elm] = lp.mat[i];
            ++to_elm;
        }
        for (i = column2; i < lp.columns; ++i) {
            lp.col_end[i] = lp.col_end[i + 1] - elm_in_col;
        }
        lp.non_zeros -= elm_in_col;
        lp.row_end_valid = 0;
        lp.eta_valid = 0;
        --lp.sum;
        --lp.columns;
        if (lp.active != 0) {
            this.set_globals(lp);
        }
    }

    public void set_upbo(lprec lp, int column2, double value) {
        if (column2 > lp.columns || column2 < 1) {
            System.err.print("Column out of range");
        }
        if (lp.scaling_used != 0) {
            value /= lp.scale[lp.rows + column2];
        }
        if (value < lp.orig_lowbo[lp.rows + column2]) {
            System.err.print("Upperbound must be >= lowerbound");
        }
        lp.eta_valid = 0;
        lp.orig_upbo[lp.rows + column2] = value;
    }

    public void set_lowbo(lprec lp, int column2, double value) {
        if (column2 > lp.columns || column2 < 1) {
            System.err.print("Column out of range");
        }
        if (lp.scaling_used != 0) {
            value /= lp.scale[lp.rows + column2];
        }
        if (value > lp.orig_upbo[lp.rows + column2]) {
            System.err.print("Upperbound must be >= lowerbound");
        }
        lp.eta_valid = 0;
        lp.orig_lowbo[lp.rows + column2] = value;
    }

    public void set_int(lprec lp, int column2, short must_be_int) {
        if (column2 > lp.columns || column2 < 1) {
            System.err.print("Column out of range");
        }
        lp.must_be_int[lp.rows + column2] = must_be_int;
        if (must_be_int == 1 && lp.columns_scaled != 0) {
            this.unscale_columns(lp);
        }
    }

    public void set_rh(lprec lp, int row, double value) {
        if (row > lp.rows || row < 0) {
            System.err.print("Row out of Range");
        }
        if (row == 0) {
            System.err.println("Warning: attempt to set RHS of objective function, ignored");
            return;
        }
        lp.orig_rh[row] = lp.scaling_used != 0 ? (lp.ch_sign[row] != 0 ? -value * lp.scale[row] : value * lp.scale[row]) : (lp.ch_sign[row] != 0 ? -value : value);
        lp.eta_valid = 0;
    }

    public void set_rh_vec(lprec lp, double[] rh) {
        if (lp.scaling_used != 0) {
            for (int i = 1; i <= lp.rows; ++i) {
                lp.orig_rh[i] = lp.ch_sign[i] != 0 ? -rh[i] * lp.scale[i] : rh[i] * lp.scale[i];
            }
        } else {
            for (int i = 1; i <= lp.rows; ++i) {
                lp.orig_rh[i] = lp.ch_sign[i] != 0 ? -rh[i] : rh[i];
            }
        }
        lp.eta_valid = 0;
    }

    public void str_set_rh_vec(lprec lp, String rh_string) {
        int i = 0;
        double[] newrh = new double[lp.rows + 1];
        StringTokenizer stk = new StringTokenizer(rh_string);
        while (stk.hasMoreTokens() && i < lp.rows) {
            newrh[++i] = Double.valueOf(stk.nextToken());
        }
        this.set_rh_vec(lp, newrh);
    }

    public void set_maxim(lprec lp) {
        if (lp.maximise == 0) {
            for (int i = 0; i < lp.non_zeros; ++i) {
                if (lp.mat[i].row_nr != 0) continue;
                lp.mat[i].value *= -1.0;
            }
            lp.eta_valid = 0;
        }
        lp.maximise = 1;
        lp.ch_sign[0] = 1;
        if (lp.active != 0) {
            this.Maximise = 1;
        }
    }

    public void set_minim(lprec lp) {
        if (lp.maximise == 1) {
            for (int i = 0; i < lp.non_zeros; ++i) {
                if (lp.mat[i].row_nr != 0) continue;
                lp.mat[i].value = -lp.mat[i].value;
            }
            lp.eta_valid = 0;
        }
        lp.maximise = 0;
        lp.ch_sign[0] = 0;
        if (lp.active != 0) {
            this.Maximise = 0;
        }
    }

    public void set_constr_type(lprec lp, int row, short con_type) {
        if (row > lp.rows || row < 1) {
            System.err.print("Row out of Range");
        }
        if (con_type == 1) {
            lp.orig_upbo[row] = 0.0;
            lp.basis_valid = 0;
            if (lp.ch_sign[row] != 0) {
                for (int i = 0; i < lp.non_zeros; ++i) {
                    if (lp.mat[i].row_nr != row) continue;
                    lp.mat[i].value *= -1.0;
                }
                lp.eta_valid = 0;
                lp.ch_sign[row] = 0;
                if (lp.orig_rh[row] != 0.0) {
                    int n = row;
                    lp.orig_rh[n] = lp.orig_rh[n] * -1.0;
                }
            }
        } else if (con_type == 0) {
            lp.orig_upbo[row] = lp.infinite;
            lp.basis_valid = 0;
            if (lp.ch_sign[row] != 0) {
                for (int i = 0; i < lp.non_zeros; ++i) {
                    if (lp.mat[i].row_nr != row) continue;
                    lp.mat[i].value *= -1.0;
                }
                lp.eta_valid = 0;
                lp.ch_sign[row] = 0;
                if (lp.orig_rh[row] != 0.0) {
                    int n = row;
                    lp.orig_rh[n] = lp.orig_rh[n] * -1.0;
                }
            }
        } else if (con_type == 2) {
            lp.orig_upbo[row] = lp.infinite;
            lp.basis_valid = 0;
            if (lp.ch_sign[row] == 0) {
                for (int i = 0; i < lp.non_zeros; ++i) {
                    if (lp.mat[i].row_nr != row) continue;
                    lp.mat[i].value *= -1.0;
                }
                lp.eta_valid = 0;
                lp.ch_sign[row] = 1;
                if (lp.orig_rh[row] != 0.0) {
                    int n = row;
                    lp.orig_rh[n] = lp.orig_rh[n] * -1.0;
                }
            }
        } else {
            System.err.print("Constraint type not (yet) implemented");
        }
    }

    public double mat_elm(lprec lp, int row, int column2) {
        int elmnr;
        if (row < 0 || row > lp.rows) {
            System.err.print("Row out of range in mat_elm");
        }
        if (column2 < 1 || column2 > lp.columns) {
            System.err.print("Column out of range in mat_elm");
        }
        double value = 0.0;
        for (elmnr = lp.col_end[column2 - 1]; lp.mat[elmnr].row_nr != row && elmnr < lp.col_end[column2]; ++elmnr) {
        }
        if (elmnr != lp.col_end[column2]) {
            value = lp.mat[elmnr].value;
            if (lp.ch_sign[row] != 0) {
                value = -value;
            }
            if (lp.scaling_used != 0) {
                value /= lp.scale[row] * lp.scale[lp.rows + column2];
            }
        }
        return value;
    }

    public void get_row(lprec lp, int row_nr, double[] row) {
        int i;
        if (row_nr < 0 || row_nr > lp.rows) {
            System.err.print("Row nr. out of range in get_row");
        }
        for (i = 1; i <= lp.columns; ++i) {
            row[i] = 0.0;
            for (int j = lp.col_end[i - 1]; j < lp.col_end[i]; ++j) {
                if (lp.mat[j].row_nr != row_nr) continue;
                row[i] = lp.mat[j].value;
            }
            if (lp.scaling_used == 0) continue;
            int n = i;
            row[n] = row[n] / (lp.scale[lp.rows + i] * lp.scale[row_nr]);
        }
        if (lp.ch_sign[row_nr] != 0) {
            for (i = 0; i <= lp.columns; ++i) {
                if (row[i] == 0.0) continue;
                row[i] = -row[i];
            }
        }
    }

    public void get_column(lprec lp, int col_nr, double[] column2) {
        int i;
        if (col_nr < 1 || col_nr > lp.columns) {
            System.err.print("Col. nr. out of range in get_column");
        }
        for (i = 0; i <= lp.rows; ++i) {
            column2[i] = 0.0;
        }
        for (i = lp.col_end[col_nr - 1]; i < lp.col_end[col_nr]; ++i) {
            column2[lp.mat[i].row_nr] = lp.mat[i].value;
        }
        for (i = 0; i <= lp.rows; ++i) {
            if (column2[i] == 0.0) continue;
            if (lp.ch_sign[i] != 0) {
                int n = i;
                column2[n] = column2[n] * -1.0;
            }
            if (lp.scaling_used == 0) continue;
            int n = i;
            column2[n] = column2[n] / (lp.scale[i] * lp.scale[lp.rows + col_nr]);
        }
    }

    public void get_reduced_costs(lprec lp, double[] rc) {
        int i;
        if (lp.basis_valid == 0) {
            System.err.print("Not a valid basis in get_reduced_costs");
        }
        this.set_globals(lp);
        if (lp.eta_valid == 0) {
            this.invert();
        }
        for (i = 1; i <= lp.sum; ++i) {
            rc[i] = 0.0;
        }
        rc[0] = 1.0;
        this.btran(rc);
        for (i = 1; i <= lp.columns; ++i) {
            int varnr = lp.rows + i;
            if (this.Basis[varnr] != 0 || !(this.Upbo[varnr] > 0.0)) continue;
            double f = 0.0;
            for (int j = this.Col_end[i - 1]; j < this.Col_end[i]; ++j) {
                f += rc[this.Mat[j].row_nr] * this.Mat[j].value;
            }
            rc[varnr] = f;
        }
        for (i = 1; i <= this.Sum; ++i) {
            rc[i] = Util.round(rc[i], this.Epsd);
        }
    }

    short is_feasible(lprec lp, double[] values) {
        int i;
        if (lp.scaling_used != 0) {
            for (i = lp.rows + 1; i <= lp.sum; ++i) {
                if (!(values[i - lp.rows] < lp.orig_lowbo[i] * lp.scale[i]) && !(values[i - lp.rows] > lp.orig_upbo[i] * lp.scale[i])) continue;
                return 0;
            }
        } else {
            for (i = lp.rows + 1; i <= lp.sum; ++i) {
                if (!(values[i - lp.rows] < lp.orig_lowbo[i]) && !(values[i - lp.rows] > lp.orig_upbo[i])) continue;
                return 0;
            }
        }
        double[] this_rhs = new double[lp.rows + 1];
        for (i = 0; i <= lp.rows; ++i) {
            this_rhs[i] = 0.0;
        }
        for (i = 1; i <= lp.columns; ++i) {
            for (int elmnr = lp.col_end[i - 1]; elmnr < lp.col_end[i]; ++elmnr) {
                int n = lp.mat[elmnr].row_nr;
                this_rhs[n] = this_rhs[n] + lp.mat[elmnr].value * values[i];
            }
        }
        for (i = 1; i <= lp.rows; ++i) {
            double dist = lp.orig_rh[i] - this_rhs[i];
            dist = Util.round(dist, 0.001);
            if ((lp.orig_upbo[i] != 0.0 || dist == 0.0) && !(dist < 0.0)) continue;
            return 0;
        }
        return 1;
    }

    short column_in_lp(lprec lp, double[] testcolumn) {
        if (lp.scaling_used != 0) {
            for (int i = 1; i <= lp.columns; ++i) {
                boolean ident = true;
                for (int j = lp.col_end[i - 1]; ident && j < lp.col_end[i]; ++j) {
                    double value = lp.mat[j].value;
                    if (lp.ch_sign[lp.mat[j].row_nr] != 0) {
                        value = -value;
                    }
                    value /= lp.scale[lp.rows + i];
                    value /= lp.scale[lp.mat[j].row_nr];
                    if (!(Math.abs(value -= testcolumn[lp.mat[j].row_nr]) > 0.001)) continue;
                    ident = false;
                }
                if (!ident) continue;
                return 1;
            }
        } else {
            for (int i = 1; i <= lp.columns; ++i) {
                boolean ident = true;
                for (int j = lp.col_end[i - 1]; ident && j < lp.col_end[i]; ++j) {
                    double value = lp.mat[j].value;
                    if (lp.ch_sign[lp.mat[j].row_nr] != 0) {
                        value *= -1.0;
                    }
                    if (!(Math.abs(value -= testcolumn[lp.mat[j].row_nr]) > 0.001)) continue;
                    ident = false;
                }
                if (!ident) continue;
                return 1;
            }
        }
        return 0;
    }

    public void print_lp(lprec lp) {
        int j;
        int i;
        double[] fatmat = new double[(lp.rows + 1) * lp.columns];
        for (i = 0; i < fatmat.length; ++i) {
            fatmat[i] = 0.0;
        }
        for (i = 1; i <= lp.columns; ++i) {
            for (j = lp.col_end[i - 1]; j < lp.col_end[i]; ++j) {
                fatmat[(i - 1) * (lp.rows + 1) + lp.mat[j].row_nr] = lp.mat[j].value;
            }
        }
        System.out.println("problem name: " + lp.lp_name);
        System.out.print("          ");
        for (j = 1; j <= lp.columns; ++j) {
            if (lp.names_used != 0) {
                System.out.print(lp.col_name[j]);
                continue;
            }
            System.out.print("Var[" + j + "] ");
        }
        if (lp.maximise != 0) {
            System.out.print("\nMaximise  ");
            for (j = 0; j < lp.columns; ++j) {
                System.out.print(" " + -fatmat[j * (lp.rows + 1)] + " ");
            }
        } else {
            System.out.print("\nMinimize  ");
            for (j = 0; j < lp.columns; ++j) {
                System.out.print(" " + fatmat[j * (lp.rows + 1)] + " ");
            }
        }
        System.out.print("\n");
        for (i = 1; i <= lp.rows; ++i) {
            if (lp.names_used != 0) {
                System.out.print(lp.row_name[i]);
            } else {
                System.out.print("Row[" + i + "]  ");
            }
            for (j = 0; j < lp.columns; ++j) {
                if (lp.ch_sign[i] != 0 && fatmat[j * (lp.rows + 1) + i] != 0.0) {
                    System.out.print(-fatmat[j * (lp.rows + 1) + i] + " ");
                    continue;
                }
                System.out.print(fatmat[j * (lp.rows + 1) + i] + " ");
            }
            if (lp.orig_upbo[i] == lp.infinite) {
                if (lp.ch_sign[i] != 0) {
                    System.out.print(">= ");
                } else {
                    System.out.print("<= ");
                }
            } else {
                System.out.print(" = ");
            }
            if (lp.ch_sign[i] != 0) {
                System.out.println(-lp.orig_rh[i]);
                continue;
            }
            System.out.println(lp.orig_rh[i]);
        }
        System.out.print("Type      ");
        for (i = 1; i <= lp.columns; ++i) {
            if (lp.must_be_int[lp.rows + i] == 1) {
                System.out.print("     Int ");
                continue;
            }
            System.out.print("    double ");
        }
        System.out.print("\nupbo      ");
        for (i = 1; i <= lp.columns; ++i) {
            if (lp.orig_upbo[lp.rows + i] == lp.infinite) {
                System.out.print("     Inf ");
                continue;
            }
            System.out.print(lp.orig_upbo[lp.rows + i] + " ");
        }
        System.out.print("\nlowbo     ");
        for (i = 1; i <= lp.columns; ++i) {
            System.out.print(lp.orig_lowbo[lp.rows + i] + " ");
        }
        System.out.print("\n");
        for (i = 0; i < lp.nr_lagrange; ++i) {
            System.out.print("lag[" + i + "]  ");
            for (j = 1; j <= lp.columns; ++j) {
                System.out.print(lp.lag_row[i][j] + " ");
            }
            if (lp.orig_upbo[i] == lp.infinite) {
                if (lp.lag_con_type[i] == 2) {
                    System.out.print(">= ");
                } else if (lp.lag_con_type[i] == 0) {
                    System.out.print("<= ");
                } else if (lp.lag_con_type[i] == 1) {
                    System.out.print(" = ");
                }
            }
            System.out.println(lp.lag_rhs[i]);
        }
    }

    public void set_row_name(lprec lp, int row, String new_name) {
        if (lp.names_used == 0) {
            int i;
            lp.row_name = new String[lp.rows_alloc + 1];
            lp.col_name = new String[lp.columns_alloc + 1];
            lp.names_used = 1;
            for (i = 0; i <= lp.rows; ++i) {
                lp.row_name[i] = new String("r_" + i);
            }
            for (i = 1; i <= lp.columns; ++i) {
                lp.col_name[i] = new String("var_" + i);
            }
        }
        lp.row_name[row] = new_name;
    }

    public void set_col_name(lprec lp, int column2, String new_name) {
        if (lp.names_used == 0) {
            int i;
            lp.row_name = new String[lp.rows_alloc + 1];
            lp.col_name = new String[lp.columns_alloc + 1];
            lp.names_used = 1;
            for (i = 0; i <= lp.rows; ++i) {
                lp.row_name[i] = new String("r_" + i);
            }
            for (i = 1; i <= lp.columns; ++i) {
                lp.col_name[i] = new String("var_" + i);
            }
        }
        lp.col_name[column2] = new_name;
    }

    private double minmax_to_scale(double min, double max) {
        if (min == 0.0 || max == 0.0) {
            return 1.0;
        }
        double scale = 1.0 / Math.pow(Math.E, (Math.log(min) + Math.log(max)) / 2.0);
        return scale;
    }

    public void unscale_columns(lprec lp) {
        int i;
        for (int j = 1; j <= lp.columns; ++j) {
            for (i = lp.col_end[j - 1]; i < lp.col_end[j]; ++i) {
                lp.mat[i].value /= lp.scale[lp.rows + j];
            }
        }
        for (i = lp.rows + 1; i < lp.sum; ++i) {
            if (lp.orig_lowbo[i] != 0.0) {
                int n = i;
                lp.orig_lowbo[n] = lp.orig_lowbo[n] * lp.scale[i];
            }
            if (lp.orig_upbo[i] == lp.infinite) continue;
            int n = i;
            lp.orig_upbo[n] = lp.orig_upbo[n] * lp.scale[i];
        }
        for (i = lp.rows + 1; i <= lp.sum; ++i) {
            lp.scale[i] = 1.0;
        }
        lp.columns_scaled = 0;
        lp.eta_valid = 0;
    }

    public void unscale(lprec lp) {
        if (lp.scaling_used != 0) {
            int i;
            int j;
            for (j = 1; j <= lp.columns; ++j) {
                for (i = lp.col_end[j - 1]; i < lp.col_end[j]; ++i) {
                    lp.mat[i].value /= lp.scale[lp.rows + j];
                }
            }
            for (i = lp.rows + 1; i < lp.sum; ++i) {
                if (lp.orig_lowbo[i] != 0.0) {
                    int n = i;
                    lp.orig_lowbo[n] = lp.orig_lowbo[n] * lp.scale[i];
                }
                if (lp.orig_upbo[i] == lp.infinite) continue;
                int n = i;
                lp.orig_upbo[n] = lp.orig_upbo[n] * lp.scale[i];
            }
            for (j = 1; j <= lp.columns; ++j) {
                for (i = lp.col_end[j - 1]; i < lp.col_end[j]; ++i) {
                    lp.mat[i].value /= lp.scale[lp.mat[i].row_nr];
                }
            }
            for (i = 0; i <= lp.rows; ++i) {
                int n = i;
                lp.orig_rh[n] = lp.orig_rh[n] / lp.scale[i];
            }
            lp.scaling_used = 0;
            lp.eta_valid = 0;
        }
    }

    public void auto_scale(lprec lp) {
        int j;
        int i;
        if (lp.scaling_used == 0) {
            lp.scale = new double[lp.sum_alloc + 1];
            for (i = 0; i <= lp.sum; ++i) {
                lp.scale[i] = 1.0;
            }
        }
        double[] row_max = new double[lp.rows + 1];
        double[] row_min = new double[lp.rows + 1];
        double[] scalechange = new double[lp.sum + 1];
        for (i = 0; i <= lp.rows; ++i) {
            row_max[i] = 0.0;
            row_min[i] = lp.infinite;
        }
        for (j = 1; j <= lp.columns; ++j) {
            for (i = lp.col_end[j - 1]; i < lp.col_end[j]; ++i) {
                int row_nr = lp.mat[i].row_nr;
                double absval = Math.abs(lp.mat[i].value);
                if (absval == 0.0) continue;
                row_max[row_nr] = Math.max(row_max[row_nr], absval);
                row_min[row_nr] = Math.min(row_min[row_nr], absval);
            }
        }
        for (i = 0; i <= lp.rows; ++i) {
            scalechange[i] = this.minmax_to_scale(row_min[i], row_max[i]);
            int n = i;
            lp.scale[n] = lp.scale[n] * scalechange[i];
        }
        for (j = 1; j <= lp.columns; ++j) {
            for (i = lp.col_end[j - 1]; i < lp.col_end[j]; ++i) {
                lp.mat[i].value *= scalechange[lp.mat[i].row_nr];
            }
        }
        for (i = 0; i <= lp.rows; ++i) {
            int n = i;
            lp.orig_rh[n] = lp.orig_rh[n] * scalechange[i];
        }
        short IntUsed = 0;
        for (i = lp.rows + 1; IntUsed == 0 && i <= lp.sum; ++i) {
            IntUsed = lp.must_be_int[i];
        }
        if (IntUsed == 0) {
            for (j = 1; j <= lp.columns; ++j) {
                double col_max = 0.0;
                double col_min = lp.infinite;
                for (i = lp.col_end[j - 1]; i < lp.col_end[j]; ++i) {
                    if (lp.mat[i].value == 0.0) continue;
                    col_max = Math.max(col_max, Math.abs(lp.mat[i].value));
                    col_min = Math.min(col_min, Math.abs(lp.mat[i].value));
                }
                scalechange[lp.rows + j] = this.minmax_to_scale(col_min, col_max);
                int n = lp.rows + j;
                lp.scale[n] = lp.scale[n] * scalechange[lp.rows + j];
            }
            for (j = 1; j <= lp.columns; ++j) {
                for (i = lp.col_end[j - 1]; i < lp.col_end[j]; ++i) {
                    lp.mat[i].value *= scalechange[lp.rows + j];
                }
            }
            for (i = lp.rows + 1; i < lp.sum; ++i) {
                if (lp.orig_lowbo[i] != 0.0) {
                    int n = i;
                    lp.orig_lowbo[n] = lp.orig_lowbo[n] / scalechange[i];
                }
                if (lp.orig_upbo[i] == lp.infinite) continue;
                int n = i;
                lp.orig_upbo[n] = lp.orig_upbo[n] / scalechange[i];
            }
            lp.columns_scaled = 1;
        }
        lp.scaling_used = 1;
        lp.eta_valid = 0;
    }

    public void reset_basis(lprec lp) {
        lp.basis_valid = 0;
    }

    public void print_solution(lprec lp) {
        int i;
        System.out.println("Value of objective function: " + lp.best_solution[0]);
        for (i = 1; i <= lp.columns; ++i) {
            if (lp.names_used != 0) {
                System.out.println(lp.col_name[i] + " " + lp.best_solution[lp.rows + i]);
                continue;
            }
            System.out.println("Var [" + i + "]  " + lp.best_solution[lp.rows + i]);
        }
        if (lp.verbose != 0) {
            System.out.print("\nActual values of the constraints:\n");
            for (i = 1; i <= lp.rows; ++i) {
                if (lp.names_used != 0) {
                    System.out.println(lp.row_name[i] + " " + lp.best_solution[i]);
                    continue;
                }
                System.out.println("Row [" + i + "]  " + " " + lp.best_solution[i]);
            }
        }
        if (lp.verbose != 0 || lp.print_duals != 0) {
            if (lp.max_level != 1) {
                System.out.print("These are the duals from the node that gave the optimal solution.\n");
            } else {
                System.out.print("\nDual values:\n");
            }
            for (i = 1; i <= lp.rows; ++i) {
                if (lp.names_used != 0) {
                    System.out.println(lp.row_name[i] + " " + lp.duals[i]);
                    continue;
                }
                System.out.println("Row [" + i + "]  " + lp.duals[i]);
            }
        }
    }

    public void write_LP(lprec lp, PrintStream output) {
        int i;
        double[] row = new double[lp.columns + 1];
        if (lp.maximise != 0) {
            output.print("max:");
        } else {
            output.print("min:");
        }
        this.get_row(lp, 0, row);
        for (i = 1; i <= lp.columns; ++i) {
            if (row[i] == 0.0) continue;
            if (row[i] == -1.0) {
                output.print(" -");
            } else if (row[i] == 1.0) {
                output.print(" +");
            } else {
                output.print(row[i]);
            }
            if (lp.names_used != 0) {
                output.print(lp.col_name[i]);
                continue;
            }
            output.print("x" + i);
        }
        output.print(";\n");
        for (int j = 1; j <= lp.rows; ++j) {
            if (lp.names_used != 0) {
                output.print(lp.row_name[j]);
            }
            this.get_row(lp, j, row);
            for (i = 1; i <= lp.columns; ++i) {
                if (row[i] == 0.0) continue;
                if (row[i] == -1.0) {
                    output.print(" -");
                } else if (row[i] == 1.0) {
                    output.print(" +");
                } else {
                    output.print(" " + row[i] + " ");
                }
                if (lp.names_used != 0) {
                    output.print(lp.col_name[i]);
                    continue;
                }
                output.print("x" + i);
            }
            if (lp.orig_upbo[j] == 0.0) {
                output.print(" =");
            } else if (lp.ch_sign[j] != 0) {
                output.print(" >");
            } else {
                output.print(" <");
            }
            if (lp.ch_sign[j] != 0) {
                output.println(" " + -lp.orig_rh[j]);
                continue;
            }
            output.println(" " + lp.orig_rh[j]);
        }
        for (i = lp.rows + 1; i <= lp.sum; ++i) {
            if (lp.orig_lowbo[i] != 0.0) {
                if (lp.names_used != 0) {
                    output.println(lp.col_name[i - lp.rows] + ">" + lp.orig_lowbo[i] + ";");
                } else {
                    output.print("x" + (i - lp.rows) + " > " + lp.orig_lowbo[i] + ";");
                }
            }
            if (lp.orig_upbo[i] == lp.infinite) continue;
            if (lp.names_used != 0) {
                output.println(lp.col_name[i - lp.rows] + " < " + lp.orig_upbo[i] + ";");
                continue;
            }
            output.println("x" + (i - lp.rows) + " < " + lp.orig_upbo[i] + ";");
        }
        for (i = 1; lp.must_be_int[lp.rows + i] == 0 && i <= lp.columns; ++i) {
        }
        if (i <= lp.columns) {
            if (lp.names_used != 0) {
                output.print("\nint " + lp.col_name[i]);
            } else {
                output.print("\nint x" + i);
            }
            ++i;
            while (i <= lp.columns) {
                if (lp.must_be_int[lp.rows + i] != 0) {
                    if (lp.names_used != 0) {
                        output.print("," + lp.col_name[i]);
                    } else {
                        output.print(", x" + i);
                    }
                }
                ++i;
            }
            output.print(";\n");
        }
    }

    public void print_duals(lprec lp) {
        for (int i = 1; i <= lp.rows; ++i) {
            if (lp.names_used != 0) {
                System.out.println(lp.row_name[i] + " [" + i + "] " + lp.duals[i]);
                continue;
            }
            System.out.println("Dual       [" + i + "] " + lp.duals[i]);
        }
    }

    public void print_scales(lprec lp) {
        if (lp.scaling_used != 0) {
            int i;
            for (i = 0; i <= lp.rows; ++i) {
                System.out.println("Row[" + i + "]    scaled at " + lp.scale[i]);
            }
            for (i = 1; i <= lp.columns; ++i) {
                System.out.println("Column[" + i + "] scaled at " + lp.scale[lp.rows + i]);
            }
        }
    }

    private void print_indent() {
        System.out.print(this.Level);
        if (this.Level < 50) {
            for (int i = this.Level; i > 0; --i) {
                System.out.print("--");
            }
        } else {
            System.out.print(" *** too deep ***");
        }
        System.out.print("> ");
    }

    public void debug_print_solution() {
        if (this.Lp.debug != 0) {
            for (int i = this.Rows + 1; i <= this.Sum; ++i) {
                this.print_indent();
                if (this.Lp.names_used != 0) {
                    System.out.println(this.Lp.col_name[i - this.Rows] + " " + this.Solution[i]);
                    continue;
                }
                System.out.println("Var[" + (i - this.Rows) + "]   " + this.Solution[i]);
            }
        }
    }

    public void debug_print_bounds(double[] upbo, double[] lowbo) {
        if (this.Lp.debug != 0) {
            for (int i = this.Rows + 1; i <= this.Sum; ++i) {
                if (lowbo[i] != 0.0) {
                    this.print_indent();
                    if (this.Lp.names_used != 0) {
                        System.out.println(this.Lp.col_name[i - this.Rows] + " > " + lowbo[i]);
                    } else {
                        System.out.print("Var[" + (i - this.Rows) + "]  > " + lowbo[i]);
                    }
                }
                if (upbo[i] == this.Infinite) continue;
                this.print_indent();
                if (this.Lp.names_used != 0) {
                    System.out.println(this.Lp.col_name[i - this.Rows] + " < " + upbo[i]);
                    continue;
                }
                System.out.println("Var[" + (i - this.Rows) + "]  < " + upbo[i]);
            }
        }
    }

    public void debug_print(String format) {
        if (this.Lp.debug != 0) {
            this.print_indent();
            System.out.print(format);
        }
    }

    void set_globals(lprec lp) {
        if (this.Lp != null) {
            this.Lp.active = 0;
        }
        this.Lp = lp;
        this.Rows = lp.rows;
        this.Columns = lp.columns;
        this.Sum = this.Rows + this.Columns;
        this.Non_zeros = lp.non_zeros;
        this.Mat = lp.mat;
        this.Col_no = lp.col_no;
        this.Col_end = lp.col_end;
        this.Row_end = lp.row_end;
        this.Rh = lp.rh;
        this.Rhs = lp.rhs;
        this.Orig_rh = lp.orig_rh;
        this.Must_be_int = lp.must_be_int;
        this.Orig_upbo = lp.orig_upbo;
        this.Orig_lowbo = lp.orig_lowbo;
        this.Upbo = lp.upbo;
        this.Lowbo = lp.lowbo;
        this.Bas = lp.bas;
        this.Basis = lp.basis;
        this.Lower = lp.lower;
        this.Eta_alloc = lp.eta_alloc;
        this.Eta_size = lp.eta_size;
        this.Num_inv = lp.num_inv;
        this.Eta_value = lp.eta_value;
        this.Eta_row_nr = lp.eta_row_nr;
        this.Eta_col_end = lp.eta_col_end;
        this.Solution = lp.solution;
        this.Best_solution = lp.best_solution;
        this.Infinite = lp.infinite;
        this.Epsilon = lp.epsilon;
        this.Epsb = lp.epsb;
        this.Epsd = lp.epsd;
        this.Epsel = lp.epsel;
        this.TREJ = this.TREJ;
        this.TINV = this.TINV;
        this.Maximise = lp.maximise;
        this.Floor_first = lp.floor_first;
        lp.active = 1;
    }

    private void ftran(int start, int end, double[] pcol) {
        int i;
        for (i = start; i <= end; ++i) {
            int k = this.Eta_col_end[i] - 1;
            int r = this.Eta_row_nr[k];
            double theta = pcol[r];
            if (theta != 0.0) {
                for (int j = this.Eta_col_end[i - 1]; j < k; ++j) {
                    int n = this.Eta_row_nr[j];
                    pcol[n] = pcol[n] + theta * this.Eta_value[j];
                }
            }
            int n = r;
            pcol[n] = pcol[n] * this.Eta_value[k];
        }
        for (i = 0; i <= this.Rows; ++i) {
            Util.round(pcol[i], this.Epsel);
        }
    }

    private void btran(double[] row) {
        for (int i = this.Eta_size; i >= 1; --i) {
            double f = 0.0;
            int k = this.Eta_col_end[i] - 1;
            for (int j = this.Eta_col_end[i - 1]; j <= k; ++j) {
                f += row[this.Eta_row_nr[j]] * this.Eta_value[j];
            }
            row[this.Eta_row_nr[k]] = f = Util.round(f, this.Epsel);
        }
    }

    static short Isvalid(lprec lp) {
        int j;
        int i;
        int[] rownum;
        if (lp.row_end_valid == 0) {
            int[] num = new int[lp.rows + 1];
            rownum = new int[lp.rows + 1];
            for (i = 0; i <= lp.rows; ++i) {
                num[i] = 0;
                rownum[i] = 0;
            }
            for (i = 0; i < lp.non_zeros; ++i) {
                int n = lp.mat[i].row_nr;
                rownum[n] = rownum[n] + 1;
            }
            lp.row_end[0] = 0;
            for (i = 1; i <= lp.rows; ++i) {
                lp.row_end[i] = lp.row_end[i - 1] + rownum[i];
            }
            for (i = 1; i <= lp.columns; ++i) {
                for (j = lp.col_end[i - 1]; j < lp.col_end[i]; ++j) {
                    int row_nr = lp.mat[j].row_nr;
                    if (row_nr == 0) continue;
                    int n = row_nr;
                    num[n] = num[n] + 1;
                    lp.col_no[lp.row_end[row_nr - 1] + num[row_nr]] = i;
                }
            }
            lp.row_end_valid = 1;
        }
        if (lp.valid != 0) {
            return 1;
        }
        rownum = new int[lp.rows + 1];
        for (i = 0; i <= lp.rows; ++i) {
            rownum[i] = 0;
        }
        int[] colnum = new int[lp.columns + 1];
        for (i = 0; i <= lp.columns; ++i) {
            colnum[i] = 0;
        }
        for (i = 1; i <= lp.columns; ++i) {
            for (j = lp.col_end[i - 1]; j < lp.col_end[i]; ++j) {
                int n = i;
                colnum[n] = colnum[n] + 1;
                int n2 = lp.mat[j].row_nr;
                rownum[n2] = rownum[n2] + 1;
            }
        }
        for (i = 1; i <= lp.columns; ++i) {
            if (colnum[i] != 0) continue;
            if (lp.names_used != 0) {
                System.err.print("Warning: Variable " + lp.col_name[i] + " not used in any constraints\n");
                continue;
            }
            System.err.print("Warning: Variable " + i + " not used in any constaints\n");
        }
        lp.valid = 1;
        return 1;
    }

    private void resize_eta() {
        this.Eta_alloc *= 2;
        double[] db_ptr = this.Eta_value;
        this.Eta_value = new double[this.Eta_alloc];
        System.arraycopy(db_ptr, 0, this.Eta_value, 0, db_ptr.length);
        this.Lp.eta_value = this.Eta_value;
        int[] int_ptr = this.Eta_row_nr;
        this.Eta_row_nr = new int[this.Eta_alloc];
        System.arraycopy(int_ptr, 0, this.Eta_row_nr, 0, int_ptr.length);
        this.Lp.eta_row_nr = this.Eta_row_nr;
    }

    private void condensecol(int row_nr, double[] pcol) {
        int elnr = this.Eta_col_end[this.Eta_size];
        if (elnr + this.Rows + 2 > this.Eta_alloc) {
            this.resize_eta();
        }
        for (int i = 0; i <= this.Rows; ++i) {
            if (i == row_nr || pcol[i] == 0.0) continue;
            this.Eta_row_nr[elnr] = i;
            this.Eta_value[elnr] = pcol[i];
            ++elnr;
        }
        this.Eta_row_nr[elnr] = row_nr;
        this.Eta_value[elnr] = pcol[row_nr];
        this.Eta_col_end[this.Eta_size + 1] = ++elnr;
    }

    private void addetacol() {
        double theta;
        int j = this.Eta_col_end[this.Eta_size];
        ++this.Eta_size;
        int k = this.Eta_col_end[this.Eta_size];
        this.Eta_value[k - 1] = theta = 1.0 / this.Eta_value[k - 1];
        int i = j;
        while (i < k - 1) {
            int n = i++;
            this.Eta_value[n] = this.Eta_value[n] * -theta;
        }
        this.JustInverted = 0;
    }

    private void setpivcol(short lower, int varin, double[] pcol) {
        int i;
        double f = lower != 0 ? 1.0 : -1.0;
        for (i = 0; i <= this.Rows; ++i) {
            pcol[i] = 0.0;
        }
        if (varin > this.Rows) {
            int colnr = varin - this.Rows;
            for (i = this.Col_end[colnr - 1]; i < this.Col_end[colnr]; ++i) {
                pcol[this.Mat[i].row_nr] = this.Mat[i].value * f;
            }
            pcol[0] = pcol[0] - this.Extrad * f;
        } else {
            pcol[varin] = lower != 0 ? 1.0 : -1.0;
        }
        this.ftran(1, this.Eta_size, pcol);
    }

    private void minoriteration(int colnr, int row_nr) {
        int i;
        double theta;
        int elnr;
        double piv = 0.0;
        int varin = colnr + this.Rows;
        int wk = elnr = this.Eta_col_end[this.Eta_size];
        ++this.Eta_size;
        if (this.Extrad != 0.0) {
            this.Eta_row_nr[elnr] = 0;
            this.Eta_value[elnr] = -this.Extrad;
            ++elnr;
        }
        for (int j = this.Col_end[colnr - 1]; j < this.Col_end[colnr]; ++j) {
            int k = this.Mat[j].row_nr;
            if (k == 0 && this.Extrad != 0.0) {
                int n = this.Eta_col_end[this.Eta_size - 1];
                this.Eta_value[n] = this.Eta_value[n] + this.Mat[j].value;
                continue;
            }
            if (k != row_nr) {
                this.Eta_row_nr[elnr] = k;
                this.Eta_value[elnr] = this.Mat[j].value;
                ++elnr;
                continue;
            }
            piv = this.Mat[j].value;
        }
        this.Eta_row_nr[elnr] = row_nr;
        this.Eta_value[elnr] = 1.0 / piv;
        ++elnr;
        this.Rhs[row_nr] = theta = this.Rhs[row_nr] / piv;
        for (i = wk; i < elnr - 1; ++i) {
            int n = this.Eta_row_nr[i];
            this.Rhs[n] = this.Rhs[n] - theta * this.Eta_value[i];
        }
        int varout = this.Bas[row_nr];
        this.Bas[row_nr] = varin;
        this.Basis[varout] = 0;
        this.Basis[varin] = 1;
        i = wk;
        while (i < elnr - 1) {
            int n = i++;
            this.Eta_value[n] = this.Eta_value[n] / -piv;
        }
        this.Eta_col_end[this.Eta_size] = elnr;
    }

    private void rhsmincol(double theta, int row_nr, int varin) {
        if (row_nr > this.Rows + 1) {
            System.err.print("Error: rhsmincol called with row_nr: " + row_nr + ", rows: " + this.Rows + "\n");
            System.err.print("This indicates numerical instability\n");
            System.exit(-1);
        }
        int j = this.Eta_col_end[this.Eta_size];
        int k = this.Eta_col_end[this.Eta_size + 1];
        for (int i = j; i < k; ++i) {
            double f = this.Rhs[this.Eta_row_nr[i]] - theta * this.Eta_value[i];
            this.Rhs[this.Eta_row_nr[i]] = f = Util.round(f, this.Epsb);
        }
        this.Rhs[row_nr] = theta;
        int varout = this.Bas[row_nr];
        this.Bas[row_nr] = varin;
        this.Basis[varout] = 0;
        this.Basis[varin] = 1;
    }

    void invert() {
        int colnr;
        double theta;
        int j;
        int i;
        if (this.Lp.print_at_invert != 0) {
            System.out.print("Start Invert iter " + this.Lp.iter + " eta_size " + this.Eta_size + " rhs[0] " + -this.Rhs[0] + " \n");
        }
        int[] rownum = new int[this.Rows + 1];
        for (i = 0; i <= this.Rows; ++i) {
            rownum[i] = 0;
        }
        int[] col = new int[this.Rows + 1];
        for (i = 0; i <= this.Rows; ++i) {
            col[i] = 0;
        }
        int[] row = new int[this.Rows + 1];
        for (i = 0; i <= this.Rows; ++i) {
            row[i] = 0;
        }
        double[] pcol = new double[this.Rows + 1];
        for (i = 0; i <= this.Rows; ++i) {
            pcol[i] = 0.0;
        }
        short[] frow = new short[this.Rows + 1];
        for (i = 0; i <= this.Rows; ++i) {
            frow[i] = 1;
        }
        short[] fcol = new short[this.Columns + 1];
        for (i = 0; i < this.Columns; ++i) {
            fcol[i] = 0;
        }
        int[] colnum = new int[this.Columns + 1];
        for (i = 0; i <= this.Columns; ++i) {
            colnum[i] = 0;
        }
        for (i = 0; i <= this.Rows; ++i) {
            if (this.Bas[i] > this.Rows) {
                fcol[this.Bas[i] - this.Rows - 1] = 1;
                continue;
            }
            frow[this.Bas[i]] = 0;
        }
        for (i = 1; i <= this.Rows; ++i) {
            if (frow[i] == 0) continue;
            for (j = this.Row_end[i - 1] + 1; j <= this.Row_end[i]; ++j) {
                int wk = this.Col_no[j];
                if (fcol[wk - 1] == 0) continue;
                int n = wk;
                colnum[n] = colnum[n] + 1;
                int n2 = i - 1;
                rownum[n2] = rownum[n2] + 1;
            }
        }
        for (i = 1; i <= this.Rows; ++i) {
            this.Bas[i] = i;
        }
        for (i = 1; i <= this.Rows; ++i) {
            this.Basis[i] = 1;
        }
        for (i = 1; i <= this.Columns; ++i) {
            this.Basis[i + this.Rows] = 0;
        }
        for (i = 0; i <= this.Rows; ++i) {
            this.Rhs[i] = this.Rh[i];
        }
        for (i = 1; i <= this.Columns; ++i) {
            int varnr = this.Rows + i;
            if (this.Lower[varnr] != 0) continue;
            theta = this.Upbo[varnr];
            for (j = this.Col_end[i - 1]; j < this.Col_end[i]; ++j) {
                int n = this.Mat[j].row_nr;
                this.Rhs[n] = this.Rhs[n] - theta * this.Mat[j].value;
            }
        }
        for (i = 1; i <= this.Rows; ++i) {
            if (this.Lower[i] != 0) continue;
            int n = i;
            this.Rhs[n] = this.Rhs[n] - this.Upbo[i];
        }
        this.Eta_size = 0;
        int v = 0;
        int row_nr = 0;
        this.Num_inv = 0;
        int numit = 0;
        while (v < this.Rows) {
            if (++row_nr > this.Rows) {
                row_nr = 1;
            }
            ++v;
            if (rownum[row_nr - 1] != 1 || frow[row_nr] == 0) continue;
            v = 0;
            j = this.Row_end[row_nr - 1] + 1;
            while (fcol[this.Col_no[j] - 1] == 0) {
                ++j;
            }
            colnr = this.Col_no[j];
            fcol[colnr - 1] = 0;
            colnum[colnr] = 0;
            for (j = this.Col_end[colnr - 1]; j < this.Col_end[colnr]; ++j) {
                if (frow[this.Mat[j].row_nr] == 0) continue;
                int n = this.Mat[j].row_nr - 1;
                rownum[n] = rownum[n] - 1;
            }
            frow[row_nr] = 0;
            this.minoriteration(colnr, row_nr);
        }
        v = 0;
        colnr = 0;
        while (v < this.Columns) {
            if (++colnr > this.Columns) {
                colnr = 1;
            }
            ++v;
            if (colnum[colnr] != 1 || fcol[colnr - 1] == 0) continue;
            v = 0;
            j = this.Col_end[colnr - 1] + 1;
            while (frow[this.Mat[j - 1].row_nr] == 0) {
                ++j;
            }
            row_nr = this.Mat[j - 1].row_nr;
            frow[row_nr] = 0;
            rownum[row_nr - 1] = 0;
            for (j = this.Row_end[row_nr - 1] + 1; j <= this.Row_end[row_nr]; ++j) {
                if (fcol[this.Col_no[j] - 1] == 0) continue;
                int n = this.Col_no[j];
                colnum[n] = colnum[n] - 1;
            }
            fcol[colnr - 1] = 0;
            col[++numit - 1] = colnr;
            row[numit - 1] = row_nr;
        }
        for (j = 1; j <= this.Columns; ++j) {
            if (fcol[j - 1] == 0) continue;
            fcol[j - 1] = 0;
            this.setpivcol(this.Lower[this.Rows + j], j + this.Rows, pcol);
            for (row_nr = 1; (frow[row_nr] == 0 || pcol[row_nr] == 0.0) && row_nr <= this.Rows; ++row_nr) {
            }
            if (row_nr == this.Rows + 1) {
                System.err.print("Inverting failed");
            }
            frow[row_nr] = 0;
            this.condensecol(row_nr, pcol);
            theta = this.Rhs[row_nr] / pcol[row_nr];
            this.rhsmincol(theta, row_nr, this.Rows + j);
            this.addetacol();
        }
        for (i = numit - 1; i >= 0; --i) {
            colnr = col[i];
            row_nr = row[i];
            int varin = colnr + this.Rows;
            for (j = 0; j <= this.Rows; ++j) {
                pcol[j] = 0.0;
            }
            for (j = this.Col_end[colnr - 1]; j < this.Col_end[colnr]; ++j) {
                pcol[this.Mat[j].row_nr] = this.Mat[j].value;
            }
            pcol[0] = pcol[0] - this.Extrad;
            this.condensecol(row_nr, pcol);
            theta = this.Rhs[row_nr] / pcol[row_nr];
            this.rhsmincol(theta, row_nr, varin);
            this.addetacol();
        }
        for (i = 1; i <= this.Rows; ++i) {
            this.Rhs[i] = Util.round(this.Rhs[i], this.Epsb);
        }
        if (this.Lp.print_at_invert != 0) {
            System.out.print("End Invert                eta_size " + this.Eta_size + " rhs[0] " + -this.Rhs[0] + "\n");
        }
        this.JustInverted = 1;
        this.DoInvert = 0;
    }

    private short colprim(Ref colnr, short minit, double[] drow) {
        double f;
        int i;
        double dpiv = -this.Epsd;
        colnr.value = 0.0;
        if (minit == 0) {
            for (i = 1; i <= this.Sum; ++i) {
                drow[i] = 0.0;
            }
            drow[0] = 1.0;
            this.btran(drow);
            for (i = 1; i <= this.Columns; ++i) {
                int varnr = this.Rows + i;
                if (this.Basis[varnr] != 0 || !(this.Upbo[varnr] > 0.0)) continue;
                f = 0.0;
                for (int j = this.Col_end[i - 1]; j < this.Col_end[i]; ++j) {
                    f += drow[this.Mat[j].row_nr] * this.Mat[j].value;
                }
                drow[varnr] = f;
            }
            for (i = 1; i <= this.Sum; ++i) {
                drow[i] = Util.round(drow[i], this.Epsd);
            }
        }
        for (i = 1; i <= this.Sum; ++i) {
            if (this.Basis[i] != 0 || !(this.Upbo[i] > 0.0) || !((f = this.Lower[i] != 0 ? drow[i] : -drow[i]) < dpiv)) continue;
            dpiv = f;
            colnr.value = i;
        }
        if (this.Lp.trace != 0) {
            if (colnr.value > 0.0) {
                System.err.print("col_prim:" + colnr.value + ", reduced cost: " + dpiv + "\n");
            } else {
                System.err.print("col_prim: no negative reduced costs found, optimality!\n");
            }
        }
        if (colnr.value == 0.0) {
            this.Doiter = 0;
            this.DoInvert = 0;
            this.Status = 0;
        }
        return colnr.value > 0.0 ? (short)1 : 0;
    }

    private short rowprim(int colnr, Ref row_nr, Ref theta, double[] pcol) {
        double quot;
        int i;
        double f = 0.0;
        row_nr.value = 0.0;
        theta.value = this.Infinite;
        for (i = 1; i <= this.Rows; ++i) {
            f = pcol[i];
            if (Math.abs(f) < this.TREJ) {
                f = 0.0;
            }
            if (f == 0.0) continue;
            quot = 2.0 * this.Infinite;
            if (f > 0.0) {
                quot = this.Rhs[i] / f;
            } else if (this.Upbo[this.Bas[i]] < this.Infinite) {
                quot = (this.Rhs[i] - this.Upbo[this.Bas[i]]) / f;
            }
            Util.round(quot, this.Epsel);
            if (!(quot < theta.value)) continue;
            theta.value = quot;
            row_nr.value = i;
        }
        if (row_nr.value == 0.0) {
            for (i = 1; i <= this.Rows; ++i) {
                f = pcol[i];
                if (f == 0.0) continue;
                quot = 2.0 * this.Infinite;
                if (f > 0.0) {
                    quot = this.Rhs[i] / f;
                } else if (this.Upbo[this.Bas[i]] < this.Infinite) {
                    quot = (this.Rhs[i] - this.Upbo[this.Bas[i]]) / f;
                }
                quot = Util.round(quot, this.Epsel);
                if (!(quot < theta.value)) continue;
                theta.value = quot;
                row_nr.value = i;
            }
        }
        if (theta.value < 0.0) {
            System.err.println("Warning: Numerical instability, qout = " + theta.value);
            System.err.println("pcol[" + row_nr.value + "] = " + f + ", rhs[" + row_nr.value + "] = " + this.Rhs[(int)row_nr.value] + " , upbo = " + this.Upbo[this.Bas[(int)row_nr.value]]);
        }
        if (row_nr.value == 0.0) {
            if (this.Upbo[colnr] == this.Infinite) {
                this.Doiter = 0;
                this.DoInvert = 0;
                this.Status = (short)3;
            } else {
                for (i = 1; pcol[i] >= 0.0 && i <= this.Rows; ++i) {
                }
                if (i > this.Rows) {
                    this.Lower[colnr] = 0;
                    this.Rhs[0] = this.Rhs[0] + this.Upbo[colnr] * pcol[0];
                    this.Doiter = 0;
                    this.DoInvert = 0;
                } else if (pcol[i] < 0.0) {
                    row_nr.value = i;
                }
            }
        }
        if (row_nr.value > 0.0) {
            this.Doiter = 1;
        }
        if (this.Lp.trace != 0) {
            System.out.println("row_prim:" + row_nr.value + ", pivot element:" + pcol[(int)row_nr.value]);
        }
        return row_nr.value > 0.0 ? (short)1 : 0;
    }

    private short rowdual(Ref row_nr) {
        row_nr.value = 0.0;
        double minrhs = -this.Epsb;
        int i = 0;
        boolean artifs = false;
        while (i < this.Rows && !artifs) {
            double f;
            if ((f = this.Upbo[this.Bas[++i]]) == 0.0 && this.Rhs[i] != 0.0) {
                artifs = true;
                row_nr.value = i;
                continue;
            }
            double g = this.Rhs[i] < f - this.Rhs[i] ? this.Rhs[i] : f - this.Rhs[i];
            if (!(g < minrhs)) continue;
            minrhs = g;
            row_nr.value = i;
        }
        if (this.Lp.trace != 0) {
            if (row_nr.value > 0.0) {
                System.out.println("row_dual:" + row_nr.value + ", rhs of selected row:           " + this.Rhs[(int)row_nr.value]);
                if (this.Upbo[this.Bas[(int)row_nr.value]] < this.Infinite) {
                    System.out.println("               upper bound of basis variable:    " + this.Upbo[this.Bas[(int)row_nr.value]]);
                }
            } else {
                System.out.print("row_dual: no infeasibilities found\n");
            }
        }
        return row_nr.value > 0.0 ? (short)1 : 0;
    }

    private short coldual(int row_nr, Ref colnr, short minit, double[] prow, double[] drow) {
        double d;
        int i;
        this.Doiter = 0;
        if (minit == 0) {
            int j;
            double f;
            for (i = 0; i <= this.Rows; ++i) {
                prow[i] = 0.0;
                drow[i] = 0.0;
            }
            drow[0] = 1.0;
            prow[row_nr] = 1.0;
            for (i = this.Eta_size; i >= 1; --i) {
                d = 0.0;
                f = 0.0;
                int r = this.Eta_row_nr[this.Eta_col_end[i] - 1];
                for (j = this.Eta_col_end[i - 1]; j < this.Eta_col_end[i]; ++j) {
                    f += prow[this.Eta_row_nr[j]] * this.Eta_value[j];
                    d += drow[this.Eta_row_nr[j]] * this.Eta_value[j];
                }
                prow[r] = f = Util.round(f, this.Epsel);
                drow[r] = d = Util.round(d, this.Epsel);
            }
            for (i = 1; i <= this.Columns; ++i) {
                int varnr = this.Rows + i;
                if (this.Basis[varnr] != 0) continue;
                d = -this.Extrad * drow[0];
                f = 0.0;
                for (j = this.Col_end[i - 1]; j < this.Col_end[i]; ++j) {
                    d += drow[this.Mat[j].row_nr] * this.Mat[j].value;
                    f += prow[this.Mat[j].row_nr] * this.Mat[j].value;
                }
                drow[varnr] = d;
                prow[varnr] = f;
            }
            for (i = 0; i <= this.Sum; ++i) {
                prow[i] = Util.round(prow[i], this.Epsel);
                drow[i] = Util.round(drow[i], this.Epsd);
            }
        }
        double g = this.Rhs[row_nr] > this.Upbo[this.Bas[row_nr]] ? -1.0 : 1.0;
        double pivot = 0.0;
        colnr.value = 0.0;
        double theta = this.Infinite;
        for (i = 1; i <= this.Sum; ++i) {
            d = this.Lower[i] != 0 ? prow[i] * g : -prow[i] * g;
            if (!(d < 0.0) || this.Basis[i] != 0 || !(this.Upbo[i] > 0.0)) continue;
            double quot = this.Lower[i] == 0 ? -drow[i] / d : drow[i] / d;
            if (quot < theta) {
                theta = quot;
                pivot = d;
                colnr.value = i;
                continue;
            }
            if (quot != theta || !(Math.abs(d) > Math.abs(pivot))) continue;
            pivot = d;
            colnr.value = i;
        }
        if (this.Lp.trace != 0) {
            System.out.println("col_dual:" + colnr.value + ", pivot element:  " + prow[(int)colnr.value]);
        }
        if (colnr.value > 0.0) {
            this.Doiter = 1;
        }
        return colnr.value > 0.0 ? (short)1 : 0;
    }

    private void iteration(int row_nr, int varin, Ref theta, double up, Ref minit, Ref low, short primal, double[] pcol) {
        double f;
        int i;
        ++this.Lp.iter;
        double d = minit.value = theta.value > up + this.Epsb ? 1.0 : 0.0;
        if (minit.value != 0.0) {
            theta.value = up;
            low.value = low.value == 0.0 ? 1.0 : 0.0;
        }
        int k = this.Eta_col_end[this.Eta_size + 1];
        double pivot = this.Eta_value[k - 1];
        for (i = this.Eta_col_end[this.Eta_size]; i < k; ++i) {
            f = this.Rhs[this.Eta_row_nr[i]] - theta.value * this.Eta_value[i];
            this.Rhs[this.Eta_row_nr[i]] = f = Util.round(f, this.Epsb);
        }
        if (minit.value == 0.0) {
            this.Rhs[row_nr] = theta.value;
            int varout = this.Bas[row_nr];
            this.Bas[row_nr] = varin;
            this.Basis[varout] = 0;
            this.Basis[varin] = 1;
            if (primal != 0 && pivot < 0.0) {
                this.Lower[varout] = 0;
            }
            if (low.value == 0.0 && up < this.Infinite) {
                low.value = 1.0;
                this.Rhs[row_nr] = up - this.Rhs[row_nr];
                for (i = this.Eta_col_end[this.Eta_size]; i < k; ++i) {
                    this.Eta_value[i] = -this.Eta_value[i];
                }
            }
            this.addetacol();
            ++this.Num_inv;
        }
        if (this.Lp.trace != 0) {
            System.out.print("Theta = " + theta.value + " ");
            if (minit.value != 0.0) {
                if (this.Lower[varin] == 0) {
                    System.out.print("Iteration:" + this.Lp.iter + ", variable" + varin + " changed from 0 to its upper bound of " + this.Upbo[varin] + "\n");
                } else {
                    System.out.print("Iteration:" + this.Lp.iter + ", variable" + varin + " changed its upper bound of " + this.Upbo[varin] + " to 0\n");
                }
            } else {
                System.out.print("Iteration:" + this.Lp.iter + ", variable" + varin + " entered basis at:" + this.Rhs[row_nr] + "\n");
            }
            if (primal == 0) {
                f = 0.0;
                for (i = 1; i <= this.Rows; ++i) {
                    if (this.Rhs[i] < 0.0) {
                        f -= this.Rhs[i];
                        continue;
                    }
                    if (!(this.Rhs[i] > this.Upbo[this.Bas[i]])) continue;
                    f += this.Rhs[i] - this.Upbo[this.Bas[i]];
                }
                System.out.println("feasibility gap of this basis:" + f);
            } else {
                System.out.println("objective function value of this feasible basis: " + this.Rhs[0]);
            }
        }
    }

    private int solvelp() {
        int i;
        double f = 0.0;
        double theta = 0.0;
        int colnr = 0;
        int row_nr = 0;
        Ref ref1 = new Ref(0.0);
        Ref ref2 = new Ref(0.0);
        Ref ref3 = new Ref(0.0);
        double[] drow = new double[this.Sum + 1];
        double[] prow = new double[this.Sum + 1];
        double[] Pcol = new double[this.Rows + 1];
        for (i = 0; i <= this.Sum; ++i) {
            drow[i] = 0.0;
            prow[i] = 0.0;
        }
        for (i = 0; i <= this.Rows; ++i) {
            Pcol[i] = 0.0;
        }
        this.Lp.iter = 0;
        short minit = 0;
        this.Status = (short)5;
        this.DoInvert = 0;
        this.Doiter = 0;
        i = 0;
        short primal = 1;
        while (i != this.Rows && primal != 0) {
            primal = this.Rhs[++i] >= 0.0 && this.Rhs[i] <= this.Upbo[this.Bas[i]] ? (short)1 : 0;
        }
        if (this.Lp.trace != 0) {
            if (primal != 0) {
                System.out.print("Start at feasible basis\n");
            } else {
                System.out.print("Start at infeasible basis\n");
            }
        }
        if (primal == 0) {
            drow[0] = 1.0;
            for (i = 1; i <= this.Rows; ++i) {
                drow[i] = 0.0;
            }
            this.Extrad = 0.0;
            for (i = 1; i <= this.Columns; ++i) {
                int varnr = this.Rows + i;
                drow[varnr] = 0.0;
                for (int j = this.Col_end[i - 1]; j < this.Col_end[i]; ++j) {
                    if (drow[this.Mat[j].row_nr] == 0.0) continue;
                    int n = varnr;
                    drow[n] = drow[n] + drow[this.Mat[j].row_nr] * this.Mat[j].value;
                }
                if (!(drow[varnr] < this.Extrad)) continue;
                this.Extrad = drow[varnr];
            }
        } else {
            this.Extrad = 0.0;
        }
        if (this.Lp.trace != 0) {
            System.out.println("Extrad = " + this.Extrad);
        }
        minit = 0;
        while (this.Status == 5) {
            short flag;
            this.Doiter = 0;
            this.DoInvert = 0;
            this.construct_solution(this.Solution);
            this.debug_print_bounds(this.Upbo, this.Lowbo);
            this.debug_print_solution();
            if (primal != 0) {
                ref1.value = colnr;
                flag = this.colprim(ref1, minit, drow);
                colnr = (int)ref1.value;
                if (flag != 0) {
                    this.setpivcol(this.Lower[colnr], colnr, Pcol);
                    ref1.value = row_nr;
                    ref2.value = theta;
                    flag = this.rowprim(colnr, ref1, ref2, Pcol);
                    row_nr = (int)ref1.value;
                    theta = ref2.value;
                    if (flag != 0) {
                        this.condensecol(row_nr, Pcol);
                    }
                }
            } else {
                if (minit == 0) {
                    ref1.value = row_nr;
                    flag = this.rowdual(ref1);
                    row_nr = (int)ref1.value;
                }
                if (row_nr > 0) {
                    ref1.value = colnr;
                    flag = this.coldual(row_nr, ref1, minit, prow, drow);
                    colnr = (int)ref1.value;
                    if (flag != 0) {
                        this.setpivcol(this.Lower[colnr], colnr, Pcol);
                        if (Pcol[row_nr] == 0.0) {
                            System.err.println("An attempt was made to divide by zero (Pcol[" + row_nr + "])");
                            System.err.println("This indicates numerical instability");
                            this.Doiter = 0;
                            if (this.JustInverted == 0) {
                                System.out.println("Reinverting Eta");
                                this.DoInvert = 1;
                            } else {
                                System.out.println("Can't reinvert, failure");
                                this.Status = (short)4;
                            }
                        } else {
                            this.condensecol(row_nr, Pcol);
                            f = this.Rhs[row_nr] - this.Upbo[this.Bas[row_nr]];
                            if (f > 0.0) {
                                theta = f / Pcol[row_nr];
                                if (theta <= this.Upbo[colnr]) {
                                    this.Lower[this.Bas[row_nr]] = this.Lower[this.Bas[row_nr]] == 0 ? (short)1 : 0;
                                }
                            } else {
                                theta = this.Rhs[row_nr] / Pcol[row_nr];
                            }
                        }
                    } else {
                        this.Status = (short)2;
                    }
                } else {
                    primal = 1;
                    this.Doiter = 0;
                    this.Extrad = 0.0;
                    this.DoInvert = 1;
                }
            }
            if (this.Doiter != 0) {
                ref1.value = theta;
                ref2.value = minit;
                ref3.value = this.Lower[colnr];
                this.iteration(row_nr, colnr, ref1, this.Upbo[colnr], ref2, ref3, primal, Pcol);
                theta = ref1.value;
                minit = (short)ref2.value;
                this.Lower[colnr] = (short)ref3.value;
            }
            if (this.Num_inv >= this.Lp.max_num_inv) {
                this.DoInvert = 1;
            }
            if (this.DoInvert == 0) continue;
            if (this.Lp.print_at_invert != 0) {
                System.out.println("Inverting: Primal = " + primal);
            }
            this.invert();
        }
        this.Lp.total_iter += this.Lp.iter;
        return this.Status;
    }

    private short is_int(double value) {
        double tmp = value - Math.floor(value);
        if (tmp < this.Epsilon) {
            return 1;
        }
        if (tmp > 1.0 - this.Epsilon) {
            return 1;
        }
        return 0;
    }

    private void construct_solution(double[] sol) {
        int i;
        for (i = 0; i <= this.Rows; ++i) {
            sol[i] = 0.0;
        }
        if (this.Lp.scaling_used != 0) {
            for (i = this.Rows + 1; i <= this.Sum; ++i) {
                sol[i] = this.Lowbo[i] * this.Lp.scale[i];
            }
            for (i = 1; i <= this.Rows; ++i) {
                int basi = this.Bas[i];
                if (basi <= this.Rows) continue;
                int n = basi;
                sol[n] = sol[n] + this.Rhs[i] * this.Lp.scale[basi];
            }
            for (i = this.Rows + 1; i <= this.Sum; ++i) {
                if (this.Basis[i] != 0 || this.Lower[i] != 0) continue;
                int n = i;
                sol[n] = sol[n] + this.Upbo[i] * this.Lp.scale[i];
            }
            for (int j = 1; j <= this.Columns; ++j) {
                double f = sol[this.Rows + j];
                if (f == 0.0) continue;
                for (i = this.Col_end[j - 1]; i < this.Col_end[j]; ++i) {
                    int n = this.Mat[i].row_nr;
                    sol[n] = sol[n] + f / this.Lp.scale[this.Rows + j] * (this.Mat[i].value / this.Lp.scale[this.Mat[i].row_nr]);
                }
            }
            for (i = 0; i <= this.Rows; ++i) {
                if (Math.abs(sol[i]) < this.Epsb) {
                    sol[i] = 0.0;
                    continue;
                }
                if (this.Lp.ch_sign[i] == 0) continue;
                sol[i] = -sol[i];
            }
        } else {
            for (i = this.Rows + 1; i <= this.Sum; ++i) {
                sol[i] = this.Lowbo[i];
            }
            for (i = 1; i <= this.Rows; ++i) {
                int basi = this.Bas[i];
                if (basi <= this.Rows) continue;
                int n = basi;
                sol[n] = sol[n] + this.Rhs[i];
            }
            for (i = this.Rows + 1; i <= this.Sum; ++i) {
                if (this.Basis[i] != 0 || this.Lower[i] != 0) continue;
                int n = i;
                sol[n] = sol[n] + this.Upbo[i];
            }
            for (int j = 1; j <= this.Columns; ++j) {
                double f = sol[this.Rows + j];
                if (f == 0.0) continue;
                for (i = this.Col_end[j - 1]; i < this.Col_end[j]; ++i) {
                    int n = this.Mat[i].row_nr;
                    sol[n] = sol[n] + f * this.Mat[i].value;
                }
            }
            for (i = 0; i <= this.Rows; ++i) {
                if (Math.abs(sol[i]) < this.Epsb) {
                    sol[i] = 0.0;
                    continue;
                }
                if (this.Lp.ch_sign[i] == 0) continue;
                sol[i] = -sol[i];
            }
        }
    }

    private void calculate_duals() {
        int i;
        for (i = 1; i <= this.Rows; ++i) {
            this.Lp.duals[i] = 0.0;
        }
        this.Lp.duals[0] = 1.0;
        this.btran(this.Lp.duals);
        if (this.Lp.scaling_used != 0) {
            for (i = 1; i <= this.Rows; ++i) {
                int n = i;
                this.Lp.duals[n] = this.Lp.duals[n] * (this.Lp.scale[i] / this.Lp.scale[0]);
            }
        }
        for (i = 1; i <= this.Rows; ++i) {
            if (this.Lp.basis[i] != 0) {
                this.Lp.duals[i] = 0.0;
                continue;
            }
            if (this.Lp.ch_sign[0] != this.Lp.ch_sign[i]) continue;
            this.Lp.duals[i] = -this.Lp.duals[i];
        }
    }

    private int milpsolve(double[] upbo, double[] lowbo, short[] sbasis, short[] slower, int[] sbas) {
        int j;
        double theta;
        int i;
        Random rdm = new Random();
        int notint = 0;
        if (this.Break_bb != 0) {
            return 8;
        }
        ++this.Level;
        ++this.Lp.total_nodes;
        if (this.Level > this.Lp.max_level) {
            this.Lp.max_level = this.Level;
        }
        this.debug_print("starting solve\n");
        System.arraycopy(upbo, 0, this.Upbo, 0, this.Sum + 1);
        System.arraycopy(lowbo, 0, this.Lowbo, 0, this.Sum + 1);
        System.arraycopy(sbasis, 0, this.Basis, 0, this.Sum + 1);
        System.arraycopy(slower, 0, this.Lower, 0, this.Sum + 1);
        System.arraycopy(sbas, 0, this.Bas, 0, this.Rows + 1);
        System.arraycopy(this.Orig_rh, 0, this.Rh, 0, this.Rows + 1);
        if (this.Lp.anti_degen != 0) {
            for (i = 1; i <= this.Columns; ++i) {
                double tmpdouble = rdm.nextDouble() * 0.001;
                if (tmpdouble > this.Epsb) {
                    int n = i + this.Rows;
                    this.Lowbo[n] = this.Lowbo[n] - tmpdouble;
                }
                if (!((tmpdouble = rdm.nextDouble() * 0.001) > this.Epsb)) continue;
                int n = i + this.Rows;
                this.Upbo[n] = this.Upbo[n] + tmpdouble;
            }
            this.Lp.eta_valid = 0;
        }
        if (this.Lp.eta_valid == 0) {
            for (i = 1; i <= this.Columns; ++i) {
                if (this.Lowbo[this.Rows + i] == 0.0) continue;
                theta = this.Lowbo[this.Rows + i];
                if (this.Upbo[this.Rows + i] < this.Infinite) {
                    int n = this.Rows + i;
                    this.Upbo[n] = this.Upbo[n] - theta;
                }
                for (j = this.Col_end[i - 1]; j < this.Col_end[i]; ++j) {
                    int n = this.Mat[j].row_nr;
                    this.Rh[n] = this.Rh[n] - theta * this.Mat[j].value;
                }
            }
            this.invert();
            this.Lp.eta_valid = 1;
        }
        int failure = this.solvelp();
        if (this.Lp.anti_degen != 0) {
            System.arraycopy(upbo, 0, this.Upbo, 0, this.Sum + 1);
            System.arraycopy(lowbo, 0, this.Lowbo, 0, this.Sum + 1);
            System.arraycopy(this.Orig_rh, 0, this.Rh, 0, this.Rows + 1);
            for (i = 1; i <= this.Columns; ++i) {
                if (this.Lowbo[this.Rows + i] == 0.0) continue;
                theta = this.Lowbo[this.Rows + i];
                if (this.Upbo[this.Rows + i] < this.Infinite) {
                    int n = this.Rows + i;
                    this.Upbo[n] = this.Upbo[n] - theta;
                }
                for (j = this.Col_end[i - 1]; j < this.Col_end[i]; ++j) {
                    int n = this.Mat[j].row_nr;
                    this.Rh[n] = this.Rh[n] - theta * this.Mat[j].value;
                }
            }
            this.invert();
            this.Lp.eta_valid = 1;
            failure = this.solvelp();
        }
        if (failure != 0) {
            this.debug_print("this problem has no solution, it is " + (failure == 3 ? "unbounded" : "infeasible"));
        }
        if (failure == 2 && this.Lp.verbose != 0) {
            System.out.print("level" + this.Level + " INF\n");
        }
        if (failure == 0) {
            boolean is_worse;
            this.construct_solution(this.Solution);
            this.debug_print("a solution was found\n");
            this.debug_print_solution();
            if (this.Maximise != 0) {
                is_worse = this.Solution[0] <= this.Best_solution[0];
            } else {
                boolean bl = is_worse = this.Solution[0] >= this.Best_solution[0];
            }
            if (is_worse) {
                if (this.Lp.verbose != 0) {
                    System.out.println("level" + this.Level + " OPT NOB value " + this.Solution[0] + " bound " + this.Best_solution[0]);
                }
                this.debug_print("but it was worse than the best sofar, discarded\n");
                --this.Level;
                return 1;
            }
            if (this.Lp.bb_rule == 0) {
                notint = 0;
                for (i = this.Rows + 1; i <= this.Sum && notint == 0; ++i) {
                    if (this.Must_be_int[i] == 0 || this.is_int(this.Solution[i]) != 0) continue;
                    if (lowbo[i] == upbo[i]) {
                        System.err.println("Warning: integer var " + (i - this.Rows) + " is already fixed at " + lowbo[i] + ", but has non-integer value " + this.Solution[i]);
                        System.err.println("Perhaps the -e option should be used");
                        continue;
                    }
                    notint = i;
                }
            }
            if (this.Lp.bb_rule == 1) {
                int nr_not_int = 0;
                for (i = this.Rows + 1; i <= this.Sum; ++i) {
                    if (this.Must_be_int[i] == 0 || this.is_int(this.Solution[i]) != 0) continue;
                    ++nr_not_int;
                }
                if (nr_not_int == 0) {
                    notint = 0;
                } else {
                    int select_not_int = rdm.nextInt() % nr_not_int + 1;
                    i = this.Rows + 1;
                    while (select_not_int > 0) {
                        if (this.Must_be_int[i] != 0 && this.is_int(this.Solution[i]) == 0) {
                            --select_not_int;
                        }
                        ++i;
                    }
                    notint = i - 1;
                }
            }
            if (this.Lp.verbose == 1) {
                if (notint != 0) {
                    System.out.println("level " + this.Level + " OPT     value " + this.Solution[0]);
                } else {
                    System.out.println("level " + this.Level + " OPT INT value " + this.Solution[0]);
                }
            }
            if (notint != 0) {
                int restwo;
                int resone;
                double[] new_upbo = new double[this.Sum + 1];
                double[] new_lowbo = new double[this.Sum + 1];
                short[] new_lower = new short[this.Sum + 1];
                short[] new_basis = new short[this.Sum + 1];
                int[] new_bas = new int[this.Rows + 1];
                System.arraycopy(upbo, 0, new_upbo, 0, this.Sum + 1);
                System.arraycopy(lowbo, 0, new_lowbo, 0, this.Sum + 1);
                System.arraycopy(this.Lower, 0, new_lower, 0, this.Sum + 1);
                System.arraycopy(this.Basis, 0, new_basis, 0, this.Sum + 1);
                System.arraycopy(this.Bas, 0, new_bas, 0, this.Rows + 1);
                if (this.Lp.names_used != 0) {
                    this.debug_print("not enough ints. Selecting var " + this.Lp.col_name[notint - this.Rows] + ", val: " + this.Solution[notint]);
                } else {
                    this.debug_print("not enough ints. Selecting Var [" + notint + "], val: " + this.Solution[notint]);
                }
                this.debug_print("current bounds:\n");
                this.debug_print_bounds(upbo, lowbo);
                if (this.Floor_first != 0) {
                    double new_bound = Math.ceil(this.Solution[notint]) - 1.0;
                    if (new_bound < lowbo[notint]) {
                        this.debug_print("New upper bound value " + new_bound + " conflicts with old lower bound " + lowbo[notint] + "\n");
                        resone = 1;
                    } else {
                        new_upbo[notint] = new_bound;
                        this.debug_print("starting first subproblem with bounds:");
                        this.debug_print_bounds(new_upbo, lowbo);
                        this.Lp.eta_valid = 0;
                        resone = this.milpsolve(new_upbo, lowbo, new_basis, new_lower, new_bas);
                        this.Lp.eta_valid = 0;
                    }
                    new_bound += 1.0;
                    if (new_bound > upbo[notint]) {
                        this.debug_print("New lower bound value " + new_bound + " conflicts with old upper bound " + upbo[notint] + "\n");
                        restwo = 1;
                    } else {
                        new_lowbo[notint] = new_bound;
                        this.debug_print("starting second subproblem with bounds:");
                        this.debug_print_bounds(upbo, new_lowbo);
                        this.Lp.eta_valid = 0;
                        restwo = this.milpsolve(upbo, new_lowbo, new_basis, new_lower, new_bas);
                        this.Lp.eta_valid = 0;
                    }
                } else {
                    double new_bound = Math.ceil(this.Solution[notint]);
                    if (new_bound > upbo[notint]) {
                        this.debug_print("New lower bound value " + new_bound + " conflicts with old upper bound " + upbo[notint] + "\n");
                        resone = 1;
                    } else {
                        new_lowbo[notint] = new_bound;
                        this.debug_print("starting first subproblem with bounds:");
                        this.debug_print_bounds(upbo, new_lowbo);
                        this.Lp.eta_valid = 0;
                        resone = this.milpsolve(upbo, new_lowbo, new_basis, new_lower, new_bas);
                        this.Lp.eta_valid = 0;
                    }
                    new_bound -= 1.0;
                    if (new_bound < lowbo[notint]) {
                        this.debug_print("New upper bound value " + new_bound + " conflicts with old lower bound " + lowbo[notint] + "\n");
                        restwo = 1;
                    } else {
                        new_upbo[notint] = new_bound;
                        this.debug_print("starting second subproblem with bounds:");
                        this.debug_print_bounds(new_upbo, lowbo);
                        this.Lp.eta_valid = 0;
                        restwo = this.milpsolve(new_upbo, lowbo, new_basis, new_lower, new_bas);
                        this.Lp.eta_valid = 0;
                    }
                }
                failure = resone != 0 && restwo != 0 ? 2 : 0;
            } else {
                this.debug_print("--> valid solution found\n");
                if (this.Maximise != 0) {
                    is_worse = this.Solution[0] < this.Best_solution[0];
                } else {
                    boolean bl = is_worse = this.Solution[0] > this.Best_solution[0];
                }
                if (!is_worse) {
                    if (this.Lp.debug != 0 || this.Lp.verbose != 0 && this.Lp.print_sol == 0) {
                        System.out.print("*** new best solution: old: " + this.Best_solution[0] + ", new: " + this.Solution[0] + " ***\n");
                    }
                    System.arraycopy(this.Solution, 0, this.Best_solution, 0, this.Sum + 1);
                    this.calculate_duals();
                    if (this.Lp.print_sol != 0) {
                        this.print_solution(this.Lp);
                    }
                    if (this.Lp.break_at_int != 0) {
                        if (this.Maximise != 0 && this.Best_solution[0] > this.Lp.break_value) {
                            this.Break_bb = 1;
                        }
                        if (this.Maximise == 0 && this.Best_solution[0] < this.Lp.break_value) {
                            this.Break_bb = 1;
                        }
                    }
                }
            }
        }
        --this.Level;
        return failure;
    }

    public int solve(lprec lp) {
        if (lp.active == 0) {
            this.set_globals(lp);
        }
        lp.total_iter = 0;
        lp.max_level = 1;
        lp.total_nodes = 0;
        if (solve.Isvalid(lp) != 0) {
            this.Best_solution[0] = this.Maximise != 0 && lp.obj_bound == this.Infinite ? -this.Infinite : (this.Maximise == 0 && lp.obj_bound == -this.Infinite ? this.Infinite : lp.obj_bound);
            this.Level = 0;
            if (lp.basis_valid == 0) {
                int i;
                for (i = 0; i <= lp.rows; ++i) {
                    lp.basis[i] = 1;
                    lp.bas[i] = i;
                }
                for (i = lp.rows + 1; i <= lp.sum; ++i) {
                    lp.basis[i] = 0;
                }
                for (i = 0; i <= lp.sum; ++i) {
                    lp.lower[i] = 1;
                }
                lp.basis_valid = 1;
            }
            lp.eta_valid = 0;
            this.Break_bb = 0;
            int result = this.milpsolve(this.Orig_upbo, this.Orig_lowbo, this.Basis, this.Lower, this.Bas);
            lp.eta_size = this.Eta_size;
            lp.eta_alloc = this.Eta_alloc;
            lp.num_inv = this.Num_inv;
            return result;
        }
        return 4;
    }

    public int lag_solve(lprec lp, double start_bound, int num_iter, short verbose) {
        double Zlb;
        double Zub;
        int i;
        double[] OrigObj = new double[lp.columns + 1];
        double[] ModObj = new double[lp.columns + 1];
        for (i = 0; i <= lp.columns; ++i) {
            ModObj[i] = 0.0;
        }
        double[] SubGrad = new double[lp.nr_lagrange];
        for (i = 0; i < lp.nr_lagrange; ++i) {
            SubGrad[i] = 0.0;
        }
        double[] BestFeasSol = new double[lp.sum + 1];
        for (i = 0; i <= lp.sum; ++i) {
            BestFeasSol[i] = 0.0;
        }
        int[] old_bas = new int[lp.rows + 1];
        System.arraycopy(lp.bas, 0, old_bas, 0, lp.rows + 1);
        short[] old_lower = new short[lp.sum + 1];
        System.arraycopy(lp.lower, 0, old_lower, 0, lp.sum + 1);
        this.get_row(lp, 0, OrigObj);
        double pie = 2.0;
        if (lp.maximise != 0) {
            Zub = 1.0E24;
            Zlb = start_bound;
        } else {
            Zlb = -1.0E24;
            Zub = start_bound;
        }
        int status = 5;
        double Step = 1.0;
        int OrigFeas = 0;
        boolean AnyFeas = false;
        int citer = 0;
        for (i = 0; i < lp.nr_lagrange; ++i) {
            lp.lambda[i] = 0.0;
        }
        while (status == 5) {
            int j;
            ++citer;
            for (i = 1; i <= lp.columns; ++i) {
                ModObj[i] = OrigObj[i];
                for (j = 0; j < lp.nr_lagrange; ++j) {
                    if (lp.maximise != 0) {
                        int n = i;
                        ModObj[n] = ModObj[n] - lp.lambda[j] * lp.lag_row[j][i];
                        continue;
                    }
                    int n = i;
                    ModObj[n] = ModObj[n] + lp.lambda[j] * lp.lag_row[j][i];
                }
            }
            for (i = 1; i <= lp.columns; ++i) {
                this.set_mat(lp, 0, i, ModObj[i]);
            }
            double rhsmod = 0.0;
            for (i = 0; i < lp.nr_lagrange; ++i) {
                if (lp.maximise != 0) {
                    rhsmod += lp.lambda[i] * lp.lag_rhs[i];
                    continue;
                }
                rhsmod -= lp.lambda[i] * lp.lag_rhs[i];
            }
            if (verbose != 0) {
                System.out.println("Zub: " + Zub + " Zlb: " + Zlb + " Step: " + Step + " pie: " + pie + " Feas " + OrigFeas);
                for (i = 0; i < lp.nr_lagrange; ++i) {
                    System.out.println(i + " SubGrad " + SubGrad[i] + " lambda " + lp.lambda[i]);
                }
            }
            if (verbose != 0 && lp.sum < 20) {
                this.print_lp(lp);
            }
            int result = this.solve(lp);
            if (verbose != 0 && lp.sum < 20) {
                this.print_solution(lp);
            }
            int same_basis = 1;
            for (i = 1; same_basis != 0 && i < lp.rows; ++i) {
                same_basis = old_bas[i] == lp.bas[i] ? 1 : 0;
            }
            for (i = 1; same_basis != 0 && i < lp.sum; ++i) {
                same_basis = old_lower[i] == lp.lower[i] ? 1 : 0;
            }
            if (same_basis == 0) {
                System.arraycopy(lp.lower, 0, old_lower, 0, lp.sum + 1);
                System.arraycopy(lp.bas, 0, old_bas, 0, lp.rows + 1);
                pie *= 0.95;
            }
            if (verbose != 0) {
                System.out.println("result: " + result + "  same basis: " + same_basis);
            }
            if (result == 3) {
                for (i = 1; i <= lp.columns; ++i) {
                    System.out.print(ModObj[i] + " ");
                }
                System.exit(-1);
            }
            if (result == 4) {
                status = 4;
            }
            if (result == 2) {
                status = 2;
            }
            double SqrsumSubGrad = 0.0;
            for (i = 0; i < lp.nr_lagrange; ++i) {
                SubGrad[i] = -lp.lag_rhs[i];
                for (j = 1; j <= lp.columns; ++j) {
                    int n = i;
                    SubGrad[n] = SubGrad[n] + lp.best_solution[lp.rows + j] * lp.lag_row[i][j];
                }
                SqrsumSubGrad += SubGrad[i] * SubGrad[i];
            }
            OrigFeas = 1;
            for (i = 0; i < lp.nr_lagrange; ++i) {
                if (lp.lag_con_type[i] != 0) {
                    if (!(Math.abs(SubGrad[i]) > lp.epsb)) continue;
                    OrigFeas = 0;
                    continue;
                }
                if (!(SubGrad[i] > lp.epsb)) continue;
                OrigFeas = 0;
            }
            if (OrigFeas != 0) {
                AnyFeas = true;
                double Ztmp = 0.0;
                for (i = 1; i <= lp.columns; ++i) {
                    Ztmp += lp.best_solution[lp.rows + i] * OrigObj[i];
                }
                if (lp.maximise != 0 && Ztmp > Zlb) {
                    Zlb = Ztmp;
                    for (i = 1; i <= lp.sum; ++i) {
                        BestFeasSol[i] = lp.best_solution[i];
                    }
                    BestFeasSol[0] = Zlb;
                    if (verbose != 0) {
                        System.out.println("Best feasible solution: " + Zlb);
                    }
                } else if (Ztmp < Zub) {
                    Zub = Ztmp;
                    for (i = 1; i <= lp.sum; ++i) {
                        BestFeasSol[i] = lp.best_solution[i];
                    }
                    BestFeasSol[0] = Zub;
                    if (verbose != 0) {
                        System.out.println("Best feasible solution: " + Zub);
                    }
                }
            }
            if (lp.maximise != 0) {
                Zub = Math.min(Zub, rhsmod + lp.best_solution[0]);
            } else {
                Zlb = Math.max(Zlb, rhsmod + lp.best_solution[0]);
            }
            if (Math.abs(Zub - Zlb) < 0.001) {
                status = 0;
            }
            Step = pie * (1.05 * Zub - Zlb) / SqrsumSubGrad;
            for (i = 0; i < lp.nr_lagrange; ++i) {
                int n = i;
                lp.lambda[n] = lp.lambda[n] + Step * SubGrad[i];
                if (lp.lag_con_type[i] != 0 || !(lp.lambda[i] < 0.0)) continue;
                lp.lambda[i] = 0.0;
            }
            if (citer != num_iter || status != 5) continue;
            if (AnyFeas) {
                status = 6;
                continue;
            }
            status = 7;
        }
        for (i = 0; i <= lp.sum; ++i) {
            lp.best_solution[i] = BestFeasSol[i];
        }
        for (i = 1; i <= lp.columns; ++i) {
            this.set_mat(lp, 0, i, OrigObj[i]);
        }
        lp.lag_bound = lp.maximise != 0 ? Zub : Zlb;
        return status;
    }
}

