/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.vector.doubles.dense.operation;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

public class CreateVector {
    public static Vector foreach(Vector vector, UnivariateRealFunction f2) {
        double[] a2 = vector.toArray();
        return new DenseVector(DoubleUtils.foreach(a2, f2));
    }

    public static Vector subVector(Vector v, int from, int to) {
        double[] a2 = Arrays.copyOfRange(v.toArray(), from - 1, to);
        return new DenseVector(a2);
    }

    public static Vector superDiagonal(Matrix A) {
        int a2;
        int a3 = Math.min(A.nRows(), A.nCols()) - 1;
        SuanShuUtils.assertArgument(a3 > 0, "1x1 matrix has no super-diagonal", new Object[0]);
        double[] a4 = new double[a3];
        int n = a2 = 1;
        while (n <= a3) {
            a4[a2 - 1] = A.get(a2, a2 + 1);
            n = ++a2;
        }
        return new DenseVector(a4);
    }

    public static Vector subDiagonal(Matrix A) {
        int a2;
        int a3 = Math.min(A.nRows(), A.nCols()) - 1;
        SuanShuUtils.assertArgument(a3 > 0, "1x1 matrix has no sub-diagonal", new Object[0]);
        double[] a4 = new double[a3];
        int n = a2 = 1;
        while (n <= a3) {
            a4[a2 - 1] = A.get(a2 + 1, a2);
            n = ++a2;
        }
        return new DenseVector(a4);
    }

    private CreateVector() {
        CreateVector a2;
    }

    public static Vector diagonal(Matrix A) {
        int a2;
        int a3 = Math.min(A.nRows(), A.nCols());
        double[] a4 = new double[a3];
        int n = a2 = 1;
        while (n <= a3) {
            a4[a2 - 1] = A.get(a2, a2);
            n = ++a2;
        }
        return new DenseVector(a4);
    }

    public static Vector concat(Vector ... vectors) {
        int a2;
        int a3;
        int a4 = 0;
        int n = a3 = 0;
        while (n < vectors.length) {
            a4 += vectors[a3] != null ? vectors[a3].size() : 0;
            n = ++a3;
        }
        DenseVector a22 = new DenseVector(a4);
        int a5 = 1;
        int n2 = a2 = 0;
        while (n2 < vectors.length) {
            if (vectors[a2] != null) {
                int a6;
                int n3 = a6 = 1;
                while (n3 <= vectors[a2].size()) {
                    a22.set(a5, vectors[a2].get(a6));
                    ++a5;
                    n3 = ++a6;
                }
            }
            n2 = ++a2;
        }
        return a22;
    }
}

