/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.vector.doubles.dense;

import com.numericalmethod.suanshu.analysis.function.FunctionOps;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.matrix.doubles.AreMatrices;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleArrayMath;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.vector.doubles.IsVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.VectorImpl;
import java.util.Arrays;

public class DenseVector
extends VectorImpl {
    public final int length;
    private double[] E;

    @Override
    public DenseVector minus(DenseVector that) {
        int a2;
        IsVector.throwIfNotEqualSize(this, that);
        DenseVector a3 = new DenseVector(this.length);
        int n = a2 = 0;
        while (n < this.length) {
            a3.E[a2] = this.E[a2] - that.E[a2];
            n = ++a2;
        }
        return a3;
    }

    @Override
    public double norm(int p) {
        int a2;
        if (p == Integer.MAX_VALUE) {
            return DoubleArrayMath.max(DoubleArrayMath.abs(this.toArray()));
        }
        if (p == Integer.MIN_VALUE) {
            return DoubleArrayMath.min(DoubleArrayMath.abs(this.toArray()));
        }
        double a3 = 0.0;
        int n = a2 = 0;
        while (n < this.length) {
            a3 += Math.pow(this.E[a2], p);
            n = ++a2;
        }
        a3 = Math.pow(a3, 1.0 / (double)p);
        return a3;
    }

    @Override
    public double get(int index) {
        IsVector.throwIfInvalidIndex(this, index);
        return this.E[index - 1];
    }

    @Override
    public DenseVector add(final double scalar) {
        double[] a2 = DoubleUtils.foreach(this.E, new UnivariateRealFunction(){
            {
                1 a2;
            }

            @Override
            public double evaluate(double x) {
                return x + scalar;
            }
        });
        return new DenseVector(a2);
    }

    @Override
    public DenseVector add(DenseVector that) {
        int a2;
        IsVector.throwIfNotEqualSize(this, that);
        DenseVector a3 = new DenseVector(this.length);
        int n = a2 = 0;
        while (n < this.length) {
            a3.E[a2] = this.E[a2] + that.E[a2];
            n = ++a2;
        }
        return a3;
    }

    public DenseVector(Vector v) {
        this.length = v.size();
        this.E = v.toArray();
    }

    public void set(int from, DenseVector replacement) {
        int a2;
        if (from + replacement.length - 1 > this.length) {
            throw new IllegalArgumentException("the replacement vector length starting from 'from' exceeds the original vector length");
        }
        int a3 = from;
        int n = a2 = 1;
        while (n <= replacement.length) {
            this.set(a3, replacement.get(a2));
            ++a3;
            n = ++a2;
        }
    }

    @Override
    public DenseVector ZERO() {
        return new DenseVector(this.length);
    }

    public int hashCode() {
        int a2 = 3;
        a2 = 19 * a2 + this.length;
        a2 = 19 * a2 + Arrays.hashCode(this.E);
        return a2;
    }

    public DenseVector(DenseVector vector) {
        this.length = vector.length;
        this.E = Arrays.copyOf(vector.E, this.length);
    }

    @Override
    public void set(int index, double value) {
        IsVector.throwIfInvalidIndex(this, index);
        this.E[index - 1] = value;
    }

    public DenseVector(int[] data) {
        int a2;
        this.length = data.length;
        this.E = new double[data.length];
        int n = a2 = 0;
        while (n < data.length) {
            this.E[a2] = data[a2];
            n = ++a2;
        }
    }

    public DenseVector(double ... data) {
        this.length = data.length;
        this.E = data;
    }

    @Override
    public DenseVector deepCopy() {
        return new DenseVector(this);
    }

    private double b(DenseVector a2) {
        DenseVector a3;
        IsVector.throwIfNotEqualSize(a3, a2);
        return FunctionOps.dotProduct(a3.E, a2.E);
    }

    public DenseVector multiply(DenseVector v) {
        int a2;
        IsVector.throwIfNotEqualSize(this, v);
        double[] a3 = new double[this.length];
        int n = a2 = 0;
        while (n < this.length) {
            a3[a2] = this.get(a2 + 1) * v.get(a2 + 1);
            n = ++a2;
        }
        return new DenseVector(a3);
    }

    @Override
    public Vector multiply(Vector v) {
        if (v instanceof DenseVector) {
            return this.multiply((DenseVector)v);
        }
        return super.multiply(v);
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public double[] toArray() {
        return Arrays.copyOf(this.E, this.E.length);
    }

    public static DenseVector as(Vector v) {
        if (v instanceof DenseVector) {
            return (DenseVector)v;
        }
        return new DenseVector(v);
    }

    public DenseVector(int length) {
        this.length = length;
        this.E = new double[this.length];
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vector)) {
            return false;
        }
        Vector a2 = (Vector)obj;
        if (!AreMatrices.equal(this, a2, 0.0)) {
            return false;
        }
        return true;
    }

    public DenseVector(Matrix A) {
        SuanShuUtils.assertArgument(A.nCols() == 1, "A must be a column matrix", new Object[0]);
        this.E = A.getColumn(1).toArray();
        this.length = this.E.length;
    }

    @Override
    public Vector minus(Vector that) {
        if (that instanceof DenseVector) {
            return this.minus((DenseVector)that);
        }
        return super.minus(that);
    }

    @Override
    public DenseVector minus(final double scalar) {
        double[] a2 = DoubleUtils.foreach(this.E, new UnivariateRealFunction(){
            {
                2 a2;
            }

            @Override
            public double evaluate(double x) {
                return x - scalar;
            }
        });
        return new DenseVector(a2);
    }

    public DenseVector(int length, double value) {
        int a2;
        this.length = length;
        this.E = new double[this.length];
        int n = a2 = 0;
        while (n < this.E.length) {
            this.E[a2] = value;
            n = ++a2;
        }
    }

    @Override
    public Vector add(Vector that) {
        if (that instanceof DenseVector) {
            return this.add((DenseVector)that);
        }
        return super.add(that);
    }

    public DenseVector divide(DenseVector v) {
        int a2;
        IsVector.throwIfNotEqualSize(this, v);
        double[] a3 = new double[this.length];
        int n = a2 = 0;
        while (n < this.length) {
            a3[a2] = this.get(a2 + 1) / v.get(a2 + 1);
            n = ++a2;
        }
        return new DenseVector(a3);
    }

    @Override
    public double innerProduct(Vector that) {
        if (that instanceof DenseVector) {
            return this.b((DenseVector)that);
        }
        return super.innerProduct(that);
    }

    @Override
    public Vector divide(Vector that) {
        if (that instanceof DenseVector) {
            return this.divide((DenseVector)that);
        }
        return super.divide(that);
    }

    @Override
    public DenseVector scaled(double scalar) {
        int a2;
        DenseVector a3 = new DenseVector(this.length);
        int n = a2 = 0;
        while (n < this.length) {
            a3.E[a2] = this.E[a2] * scalar;
            n = ++a2;
        }
        return a3;
    }

    public String toString() {
        int a2;
        StringBuilder a3 = new StringBuilder();
        a3.append("[");
        int n = a2 = 0;
        while (n < this.length) {
            Object[] objectArray = new Object[1];
            objectArray[0] = this.E[a2];
            a3.append(String.format("%f, ", objectArray));
            n = ++a2;
        }
        a3.setCharAt(a3.length() - 2, ']');
        return a3.toString();
    }

    @Override
    public DenseVector pow(final double scalar) {
        double[] a2 = DoubleUtils.foreach(this.E, new UnivariateRealFunction(){
            {
                3 a2;
            }

            @Override
            public double evaluate(double x) {
                return Math.pow(x, scalar);
            }
        });
        return new DenseVector(a2);
    }
}

