/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.vector.doubles;

import com.numericalmethod.suanshu.vector.doubles.Vector;

public class IsVector {
    private IsVector() {
        IsVector a2;
    }

    public static void throwIfInvalidIndex(Vector v, int index) {
        if (index < 1 || index > v.size()) {
            throw new VectorAccessException(v.size(), index);
        }
    }

    public static void throwIfNotEqualSize(Vector v1, Vector v2) {
        if (v1.size() != v2.size()) {
            throw new SizeMismatch(v1.size(), v2.size());
        }
    }

    public static class VectorAccessException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public VectorAccessException(int size, int index) {
            Object[] objectArray = new Object[2];
            objectArray[0] = size;
            objectArray[1] = index;
            super(String.format("out-of-range [1:%d] index: %d", objectArray));
        }

        public VectorAccessException(String msg) {
            super(msg);
        }
    }

    public static class SizeMismatch
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public SizeMismatch(int size1, int size2) {
            Object[] objectArray = new Object[2];
            objectArray[0] = size1;
            objectArray[1] = size2;
            super(String.format("vectors do not have the same size: %d and %d", objectArray));
        }
    }
}

