/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.univariate;

import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.timeseries.univariate.TimeSeries;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class GenericTimeTimeSeries<T extends Comparable<T>>
implements TimeSeries<T, TimeSeries.Entry<T>> {
    public ArrayList<TimeSeries.Entry<T>> ts = new ArrayList();

    @Override
    public int size() {
        return this.ts.size();
    }

    @Override
    public Iterator<TimeSeries.Entry<T>> iterator() {
        return new Iterator<TimeSeries.Entry<T>>(){
            private final Iterator<TimeSeries.Entry<T>> E;

            @Override
            public TimeSeries.Entry<T> next() {
                TimeSeries.Entry a2 = this.E.next();
                return new TimeSeries.Entry(a2.getTime(), a2.getValue());
            }

            @Override
            public boolean hasNext() {
                return this.E.hasNext();
            }
            {
                1 a2;
                a2.E = a2.GenericTimeTimeSeries.this.ts.iterator();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("time series is immutable");
            }
        };
    }

    public T[] timestamps() {
        int a2;
        int a3 = this.ts.size();
        Comparable[] a4 = (Comparable[])Array.newInstance(((Comparable)this.ts.get(0).getTime()).getClass(), a3);
        int n = a2 = 0;
        while (n < a3) {
            a4[a2] = (Comparable)this.ts.get(a2).getTime();
            n = ++a2;
        }
        return a4;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericTimeTimeSeries a2 = (GenericTimeTimeSeries)obj;
        if (!(this.ts == a2.ts || this.ts != null && this.ts.equals(a2.ts))) {
            return false;
        }
        return true;
    }

    public T time(int index) {
        return (T)((Comparable)this.ts.get(index - 1).getTime());
    }

    @Override
    public double[] toArray() {
        Iterator<TimeSeries.Entry<T>> a2;
        double[] a3 = new double[this.ts.size()];
        int a4 = 0;
        Iterator<TimeSeries.Entry<T>> iterator = a2 = this.ts.iterator();
        while (iterator.hasNext()) {
            TimeSeries.Entry<T> a5 = a2.next();
            a3[a4++] = a5.getValue();
            iterator = a2;
        }
        return a3;
    }

    public double get(int index) {
        return this.ts.get(index - 1).getValue();
    }

    public GenericTimeTimeSeries(T[] timestamps, double[] values) {
        int a2;
        SuanShuUtils.assertArgument(timestamps.length == values.length, "number of values and numbers of time stamps do not match", new Object[0]);
        int a3 = timestamps.length;
        int n = a2 = 0;
        while (n < a3) {
            this.ts.add(new TimeSeries.Entry<T>(timestamps[a2], values[a2]));
            n = ++a2;
        }
    }

    public String toString() {
        int a2;
        int a3 = this.size();
        StringBuilder a4 = new StringBuilder(a3);
        a4.append("[");
        int n = a2 = 0;
        while (n < a3) {
            TimeSeries.Entry<T> a5 = this.ts.get(a2);
            Object[] objectArray = new Object[2];
            objectArray[0] = ((Comparable)a5.getTime()).toString();
            objectArray[1] = a5.getValue();
            a4.append(String.format("%s: %f; ", objectArray));
            n = ++a2;
        }
        a4.append("]");
        return a4.toString();
    }

    public GenericTimeTimeSeries<T> diff(int d2) {
        Comparable[] a2 = this.timestamps();
        double[] a3 = this.toArray();
        Comparable[] a4 = Arrays.copyOfRange(a2, d2, a2.length);
        double[] a5 = R.diff(a3, 1, d2);
        return new GenericTimeTimeSeries(a4, a5);
    }

    public double get(T t) {
        for (TimeSeries.Entry<T> a2 : this.ts) {
            if (((Comparable)a2.getTime()).compareTo(t) != 0) continue;
            return a2.getValue();
        }
        Object[] objectArray = new Object[1];
        objectArray[0] = t.toString();
        throw new RuntimeException(String.format("no value found at time %s", objectArray));
    }

    public GenericTimeTimeSeries<T> drop(int nItems) {
        Comparable[] a2 = this.timestamps();
        double[] a3 = this.toArray();
        Comparable[] a4 = Arrays.copyOfRange(a2, nItems, this.size());
        double[] a5 = Arrays.copyOfRange(a3, nItems, this.size());
        return new GenericTimeTimeSeries(a4, a5);
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 97 * a2 + (this.ts != null ? this.ts.hashCode() : 0);
        return a2;
    }
}

