/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.multivariate.realtime;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.timeseries.multivariate.realtime.MultiVariateTimeSeries;
import com.numericalmethod.suanshu.stats.timeseries.univariate.realtime.TimeSeries;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import java.util.ArrayList;
import java.util.Iterator;

public class SimpleMultiVariateTimeSeries
implements MultiVariateTimeSeries {
    private final ArrayList<Vector> E = new ArrayList();

    public SimpleMultiVariateTimeSeries(TimeSeries ts) {
        this(new DenseMatrix(ts.toArray(), ts.size(), 1));
    }

    public SimpleMultiVariateTimeSeries drop(int nItems) {
        return this.lag(0, this.size() - nItems);
    }

    @Override
    public Iterator<MultiVariateTimeSeries.Entry> iterator() {
        return new Iterator<MultiVariateTimeSeries.Entry>(){
            private int L;
            private final Iterator<Vector> E;

            @Override
            public MultiVariateTimeSeries.Entry next() {
                Vector a2 = this.E.next();
                int n = this.L;
                this.L = n + 1;
                return new MultiVariateTimeSeries.Entry(n, a2);
            }

            @Override
            public boolean hasNext() {
                return this.E.hasNext();
            }
            {
                1 a2;
                a2.E = a2.SimpleMultiVariateTimeSeries.this.E.iterator();
                a2.L = 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("time series is immutable");
            }
        };
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleMultiVariateTimeSeries a2 = (SimpleMultiVariateTimeSeries)obj;
        if (!(this.E == a2.E || this.E != null && this.E.equals(a2.E))) {
            return false;
        }
        return true;
    }

    public SimpleMultiVariateTimeSeries(double[] ... values) {
        this(new DenseMatrix(values));
    }

    public String toString() {
        return this.E.toString();
    }

    public SimpleMultiVariateTimeSeries(Matrix values) {
        int a2;
        int n = a2 = 1;
        while (n <= values.nRows()) {
            this.E.add(values.getRow(a2));
            n = ++a2;
        }
    }

    public SimpleMultiVariateTimeSeries lag(int nLags, int length) {
        int a2;
        SuanShuUtils.assertArgument(nLags >= 0, "nLags >= 0", new Object[0]);
        int a3 = this.size() - nLags - length + 1;
        SuanShuUtils.assertArgument(a3 >= 1, "lagged series length is too long", new Object[0]);
        Vector[] a4 = new Vector[length];
        int n = a2 = a3;
        while (n <= this.size() - nLags) {
            a4[a2 - a3] = this.E.get(a2 - 1);
            n = ++a2;
        }
        return new SimpleMultiVariateTimeSeries(CreateMatrix.rbind(a4));
    }

    @Override
    public Matrix toMatrix() {
        Iterator<Vector> a2;
        Vector[] a3 = new Vector[this.E.size()];
        int a4 = 0;
        Iterator<Vector> iterator = a2 = this.E.iterator();
        while (iterator.hasNext()) {
            Vector a5 = a2.next();
            a3[a4++] = a5;
            iterator = a2;
        }
        return CreateMatrix.rbind(a3);
    }

    @Override
    public int dimension() {
        return this.E.get(0).size();
    }

    public SimpleMultiVariateTimeSeries(Vector ... values) {
        this(new DenseMatrix(CreateMatrix.rbind(values)));
    }

    @Override
    public int size() {
        return this.E.size();
    }

    public SimpleMultiVariateTimeSeries diff(int d2) {
        return new SimpleMultiVariateTimeSeries(R.diff(MatrixUtils.to2DArray(this.toMatrix()), 1, d2));
    }

    public SimpleMultiVariateTimeSeries lag(int nLags) {
        return this.lag(nLags, this.size() - nLags);
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 97 * a2 + (this.E != null ? this.E.hashCode() : 0);
        return a2;
    }

    @Override
    public Vector get(int t) {
        return new ImmutableVector(this.E.get(t - 1));
    }
}

