/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.multivariate;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.timeseries.multivariate.MultiVariateTimeSeries;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class GenericTimeTimeSeries<T extends Comparable<T>>
implements MultiVariateTimeSeries<T, MultiVariateTimeSeries.Entry<T>> {
    public ArrayList<MultiVariateTimeSeries.Entry<T>> ts = new ArrayList();

    @Override
    public int size() {
        return this.ts.size();
    }

    public GenericTimeTimeSeries(T[] timestamps, Vector[] values) {
        int a2;
        SuanShuUtils.assertArgument(timestamps.length == values.length, "number of values and numbers of time stamps do not match", new Object[0]);
        int a3 = timestamps.length;
        int n = a2 = 0;
        while (n < a3) {
            this.ts.add(new MultiVariateTimeSeries.Entry<T>(timestamps[a2], values[a2]));
            n = ++a2;
        }
    }

    public GenericTimeTimeSeries<T> drop(int nItems) {
        Comparable[] a2 = this.timestamps();
        Vector[] a3 = this.toArray();
        Vector[] a4 = Arrays.copyOfRange(a3, nItems, a3.length);
        Comparable[] a5 = Arrays.copyOfRange(a2, nItems, a2.length);
        return new GenericTimeTimeSeries(a5, a4);
    }

    public T time(int index) {
        return (T)((Comparable)this.ts.get(index - 1).getTime());
    }

    public GenericTimeTimeSeries(T[] timestamps, double[][] values) {
        int a2;
        SuanShuUtils.assertArgument(timestamps.length == values.length, "number of values and numbers of time stamps do not match", new Object[0]);
        int a3 = timestamps.length;
        int n = a2 = 0;
        while (n < a3) {
            this.ts.add(new MultiVariateTimeSeries.Entry<T>(timestamps[a2], new DenseVector(values[a2])));
            n = ++a2;
        }
    }

    public GenericTimeTimeSeries(T[] timestamps, Matrix values) {
        int a2;
        int a3 = values.nRows();
        SuanShuUtils.assertArgument(timestamps.length == a3, "number of values and numbers of time stamps do not match", new Object[0]);
        int a4 = timestamps.length;
        int n = a2 = 0;
        while (n < a4) {
            this.ts.add(new MultiVariateTimeSeries.Entry<T>(timestamps[a2], values.getRow(a2 + 1)));
            n = ++a2;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericTimeTimeSeries a2 = (GenericTimeTimeSeries)obj;
        if (!(this.ts == a2.ts || this.ts != null && this.ts.equals(a2.ts))) {
            return false;
        }
        return true;
    }

    public String toString() {
        int a2;
        int a3 = this.size();
        StringBuilder a4 = new StringBuilder(a3);
        a4.append("{");
        int n = a2 = 0;
        while (n < a3) {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.time(a2 + 1);
            objectArray[1] = this.get(a2 + 1);
            a4.append(String.format("%s: %s;\n", objectArray));
            n = ++a2;
        }
        a4.setCharAt(a4.length() - 2, '}');
        return a4.toString();
    }

    @Override
    public Iterator<MultiVariateTimeSeries.Entry<T>> iterator() {
        return new Iterator<MultiVariateTimeSeries.Entry<T>>(){
            private final Iterator<MultiVariateTimeSeries.Entry<T>> E;

            @Override
            public MultiVariateTimeSeries.Entry<T> next() {
                MultiVariateTimeSeries.Entry a2 = this.E.next();
                return new MultiVariateTimeSeries.Entry(a2.getTime(), a2.getValue());
            }

            @Override
            public boolean hasNext() {
                return this.E.hasNext();
            }
            {
                1 a2;
                a2.E = a2.GenericTimeTimeSeries.this.ts.iterator();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("time series is immutable");
            }
        };
    }

    public int hashCode() {
        int a2 = 3;
        a2 = 13 * a2 + (this.ts != null ? this.ts.hashCode() : 0);
        return a2;
    }

    public GenericTimeTimeSeries<T> diff(int d2) {
        Comparable[] a2 = this.timestamps();
        DenseMatrix a3 = CreateMatrix.rbind(this.toArray());
        double[][] a4 = MatrixUtils.to2DArray(a3);
        double[][] a5 = R.diff(a4, 1, d2);
        Comparable[] a6 = Arrays.copyOfRange(a2, d2, a2.length);
        return new GenericTimeTimeSeries(a6, a5);
    }

    public T[] timestamps() {
        int a2;
        int a3 = this.ts.size();
        Comparable[] a4 = (Comparable[])Array.newInstance(((Comparable)this.ts.get(0).getTime()).getClass(), a3);
        int n = a2 = 0;
        while (n < a3) {
            a4[a2] = (Comparable)this.ts.get(a2).getTime();
            n = ++a2;
        }
        return a4;
    }

    public Vector[] toArray() {
        int a2;
        int a3 = this.ts.size();
        Vector[] a4 = new Vector[a3];
        int n = a2 = 0;
        while (n < a3) {
            a4[a2] = new ImmutableVector(this.ts.get(a2).getValue());
            n = ++a2;
        }
        return a4;
    }

    @Override
    public Matrix toMatrix() {
        DenseMatrix a2 = CreateMatrix.rbind(this.toArray());
        return a2;
    }

    @Override
    public int dimension() {
        return this.ts.get(0).getValue().size();
    }

    public Vector get(int index) {
        return new ImmutableVector(this.ts.get(index - 1).getValue());
    }
}

