/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.garch;

import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.rn2rm.RealVectorFunction;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.optimization.unconstrained.NelderMead;
import com.numericalmethod.suanshu.optimization.unconstrained.quasinewton.BFGS;
import com.numericalmethod.suanshu.stats.descriptive.moment.Variance;
import com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.garch.GARCHModel;
import com.numericalmethod.suanshu.stats.timeseries.univariate.realtime.TimeSeries;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

public class GARCH {
    private final int k;
    private GARCHModel L;
    private final double E;

    private static double b(double a2, double a3) {
        double a4 = Math.log(a2);
        a4 += a3 / a2;
        return a4 *= -0.5;
    }

    private RealVectorFunction k(final double[] a2, final int a3, final int a4) {
        GARCH a5;
        return new RealVectorFunction(){
            public final int maxPQ;
            {
                4 a22;
                a22.maxPQ = Math.max(a22.a3, a22.a4);
            }

            @Override
            public int dimensionOfRange() {
                return 1;
            }

            @Override
            public int dimensionOfDomain() {
                return GARCH.this.k;
            }

            @Override
            public Vector evaluate(double ... theta) {
                int a23;
                int a33;
                int a43;
                double[] a5 = Arrays.copyOfRange(theta, a4 + 1, GARCH.this.k);
                GARCHModel a6 = GARCH.this.m(theta, a3, a4);
                Vector[] a7 = new Vector[a2.length];
                int n = a43 = 0;
                while (n < this.maxPQ) {
                    a7[a43] = new DenseVector(GARCH.this.k, 0.0);
                    a7[a43].set(1, 1.0);
                    n = ++a43;
                }
                double[] a22 = new double[a2.length];
                int n2 = a33 = 0;
                while (n2 < this.maxPQ) {
                    a22[a33] = GARCH.this.E;
                    n2 = ++a33;
                }
                Vector a32 = new DenseVector(GARCH.this.k, 0.0);
                int n3 = a23 = this.maxPQ;
                while (n3 < a2.length) {
                    int a8;
                    double[] a9 = Arrays.copyOfRange(a2, a23 - a4, a23);
                    DoubleUtils.reverse(a9);
                    double[] a10 = Arrays.copyOfRange(a22, a23 - a3, a23);
                    DoubleUtils.reverse(a10);
                    a22[a23] = a6.sigma2(a9, a10);
                    double[][] dArrayArray = new double[3][];
                    double[] dArray = new double[1];
                    dArray[0] = 1.0;
                    dArrayArray[0] = dArray;
                    dArrayArray[1] = a9;
                    dArrayArray[2] = a10;
                    a7[a23] = new DenseVector(DoubleUtils.concat(dArrayArray));
                    int n4 = a8 = 1;
                    while (n4 <= a3) {
                        Vector a11 = a7[a23 - a8].scaled(a5[a8 - 1]);
                        a7[a23] = a7[a23].add(a11);
                        n4 = ++a8;
                    }
                    Vector a42 = a7[a23].scaled(0.5 / a22[a23]);
                    a42 = a42.scaled(a2[a23] / a22[a23] - 1.0);
                    a32 = a32.add(a42);
                    n3 = ++a23;
                }
                a32 = a32.scaled(1.0 / (double)(a2.length - this.maxPQ));
                return a32;
            }
        };
    }

    private GARCHModel m(double[] a2, int a3, int a4) {
        try {
            GARCH a5;
            return new GARCHModel(a2[0], Arrays.copyOfRange(a2, 1, a4 + 1), Arrays.copyOfRange(a2, a4 + 1, a5.k));
        }
        catch (Exception a6) {
            return null;
        }
    }

    public GARCH(TimeSeries xt, int p, int q2) {
        this(xt, p, q2, 300, GRADIENT.ANALYTICAL);
    }

    private RealScalarFunction b(final double[] a2, final int a3, final int a4) {
        GARCH a5;
        return new RealScalarFunction(){
            public final int maxPQ;

            @Override
            public int dimensionOfDomain() {
                return GARCH.this.k;
            }
            {
                3 a22;
                a22.maxPQ = Math.max(a22.a3, a22.a4);
            }

            @Override
            public int dimensionOfRange() {
                return 1;
            }

            @Override
            public double evaluate(double ... theta) {
                int a23;
                int a32;
                GARCHModel a42 = GARCH.this.m(theta, a3, a4);
                if (a42 == null) {
                    return -1.7976931348623157E308;
                }
                double[] a5 = new double[a2.length];
                int n = a32 = 0;
                while (n < this.maxPQ) {
                    a5[a32] = GARCH.this.E;
                    n = ++a32;
                }
                double a22 = 0.0;
                int n2 = a23 = this.maxPQ;
                while (n2 < a2.length) {
                    double[] a6 = Arrays.copyOfRange(a2, a23 - a4, a23);
                    DoubleUtils.reverse(a6);
                    double[] a7 = Arrays.copyOfRange(a5, a23 - a3, a23);
                    DoubleUtils.reverse(a7);
                    a5[a23] = a42.sigma2(a6, a7);
                    double a8 = GARCH.b(a5[a23], a2[a23]);
                    a22 += a8;
                    n2 = ++a23;
                }
                return a22 /= (double)(a2.length - this.maxPQ);
            }
        };
    }

    public GARCH(TimeSeries xt, final int p, final int q2, int maxIterations, GRADIENT grad) {
        this.k = 1 + q2 + p;
        double[] a2 = xt.toArray();
        this.E = new Variance(a2).value();
        final double[] a3 = DoubleUtils.foreach(a2, new UnivariateRealFunction(){
            {
                1 a2;
            }

            @Override
            public double evaluate(double x) {
                return x * x;
            }
        });
        RealScalarFunction a4 = new RealScalarFunction(){
            public final RealScalarFunction L;
            {
                2 a2;
                a2.L = a2.GARCH.this.b(a2.a3, a2.p, a2.q2);
            }

            @Override
            public int dimensionOfRange() {
                return this.L.dimensionOfRange();
            }

            @Override
            public int dimensionOfDomain() {
                return this.L.dimensionOfDomain();
            }

            @Override
            public double evaluate(double ... x) {
                return -this.L.evaluate(x);
            }
        };
        RealVectorFunction a5 = this.k(a3, p, q2);
        double a6 = 0.05;
        Vector a7 = new DenseVector(this.k, 0.05);
        a7.set(1, this.E * (0.8 - 0.05 * (double)(q2 + p)));
        NelderMead a8 = new NelderMead();
        a8.solve(a4, 0.0, maxIterations);
        Vector[] vectorArray = new Vector[1];
        vectorArray[0] = a7;
        a7 = a8.search(vectorArray);
        BFGS a9 = new BFGS();
        if (grad == GRADIENT.NUMERICAL) {
            a9.solve(a4, 0.0, maxIterations);
        } else {
            a9.solve(a4, a5, 0.0, maxIterations);
        }
        try {
            for (int a10 = 0; a10 < maxIterations; ++a10) {
                Vector[] vectorArray2 = new Vector[1];
                vectorArray2[0] = a7;
                Vector a11 = a9.step(vectorArray2)[0];
                double[] a12 = a11.toArray();
                if (this.m(a12, p, q2) != null) {
                    a7 = a11;
                    continue;
                }
                break;
            }
        }
        catch (Exception a13) {
            // empty catch block
        }
        double[] a14 = a7.toArray();
        this.L = this.m(a14, p, q2);
    }

    public GARCHModel getModel() {
        return this.L;
    }

    public static final class GRADIENT
    extends Enum<GRADIENT> {
        public static final /* enum */ GRADIENT NUMERICAL;
        public static final /* enum */ GRADIENT ANALYTICAL;
        private static final /* synthetic */ GRADIENT[] E;

        public static GRADIENT valueOf(String name) {
            return Enum.valueOf(GRADIENT.class, name);
        }

        public static GRADIENT[] values() {
            return (GRADIENT[])E.clone();
        }

        private GRADIENT() {
            GRADIENT a2;
        }

        static {
            ANALYTICAL = new GRADIENT();
            NUMERICAL = new GRADIENT();
            GRADIENT[] gRADIENTArray = new GRADIENT[2];
            gRADIENTArray[0] = ANALYTICAL;
            gRADIENTArray[1] = NUMERICAL;
            E = gRADIENTArray;
        }
    }
}

