/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.arma;

import com.numericalmethod.suanshu.analysis.function.FunctionOps;
import com.numericalmethod.suanshu.stats.timeseries.linear.univariate.arima.ARIMAModel;

public class ARMAModel
extends ARIMAModel {
    public ARMAModel(double mu, double[] AR, double[] MA) {
        this(mu, AR, MA, 1.0);
    }

    public ARMAModel(double[] AR, double[] MA) {
        this(AR, MA, 1.0);
    }

    public double armaMeanNoIntercept(double[] arLags, double[] maLags) {
        double a2 = this.AR != null ? FunctionOps.dotProduct(this.AR, arLags) : 0.0;
        double a3 = this.MA != null ? FunctionOps.dotProduct(this.MA, maLags) : 0.0;
        return a2 + a3;
    }

    public ARMAModel(double mu, double[] AR, double[] MA, double sigma) {
        super(mu, AR, 0, MA, sigma);
    }

    public double armaMean(double[] arLags, double[] maLags) {
        double a2 = this.armaMeanNoIntercept(arLags, maLags);
        return this.mu + a2;
    }

    public ARMAModel(ARMAModel that) {
        super(that);
    }

    public ARMAModel(double[] AR, double[] MA, double sigma) {
        this(0.0, AR, MA, sigma);
    }
}

