/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.signalprocessing.filter.MovingAverage;
import com.numericalmethod.suanshu.stats.descriptive.moment.Mean;
import com.numericalmethod.suanshu.stats.timeseries.univariate.realtime.SimpleTimeSeries;
import com.numericalmethod.suanshu.stats.timeseries.univariate.realtime.TimeSeries;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class MADecomposition {
    public final TimeSeries seasonal;
    public final TimeSeries trend;
    public final TimeSeries random;

    public MADecomposition(TimeSeries Xt, double[] MAFilter, int period) {
        Object a2;
        SuanShuUtils.assertArgument(MAFilter.length > 0, "MAFilter must be supplied", new Object[0]);
        SuanShuUtils.assertArgument(period >= 1, "period must be +ve", new Object[0]);
        double[] a3 = Xt.toArray();
        DenseVector a4 = new DenseVector(a3);
        int a5 = a4.size();
        MovingAverage a6 = new MovingAverage(MAFilter);
        double[] a7 = a6.filtering(a3);
        Vector a8 = a4;
        Vector a9 = null;
        if (period > 1) {
            int a10;
            int a11;
            int a12;
            a2 = new Mean[period];
            int n = a12 = 0;
            while (n < a5) {
                a2[a12 % period] = new Mean();
                n = ++a12;
            }
            double[] a22 = new double[a5];
            int n2 = a11 = 0;
            while (n2 < a5) {
                a22[a11] = a4.get(a11 + 1) - a7[a11];
                if (!Double.isNaN(a22[a11])) {
                    double[] dArray = new double[1];
                    dArray[0] = a22[a11];
                    ((Mean)a2[a11 % period]).addData(dArray);
                }
                n2 = ++a11;
            }
            double a32 = 0.0;
            int n3 = a10 = 0;
            while (n3 < period) {
                a32 += ((Mean)a2[a10]).value();
                n3 = ++a10;
            }
            a32 /= (double)((Object)a2).length;
            a9 = new DenseVector(a5);
            int n4 = a10 = 1;
            while (n4 <= a5) {
                int a13 = (a10 - 1) % period;
                a9.set(a10, ((Mean)a2[a13]).value() - a32);
                n4 = ++a10;
            }
            a8 = a4.minus(a9);
            a7 = a6.filtering(a8.toArray());
        }
        a2 = a8.minus(new DenseVector(a7));
        this.trend = new SimpleTimeSeries(a7);
        this.seasonal = a9 != null ? new SimpleTimeSeries(a9.toArray()) : new SimpleTimeSeries(new DenseVector(a5, 0.0).toArray());
        this.random = new SimpleTimeSeries(a2.toArray());
    }

    public MADecomposition(TimeSeries Xt, int period) {
        this(Xt, period, period);
    }

    private static double[] b(int a2) {
        double[] a3;
        SuanShuUtils.assertArgument(a2 > 0, "MAOrder must be > 0", new Object[0]);
        if (a2 % 2 == 0) {
            double[] dArray = new DenseVector(a2 + 1, 1.0 / (double)a2).toArray();
            a3 = dArray;
            dArray[0] = 0.5 / (double)a2;
            a3[a3.length - 1] = 0.5 / (double)a2;
        } else {
            a3 = new DenseVector(a2, 1.0 / (double)a2).toArray();
        }
        return a3;
    }

    public MADecomposition(TimeSeries Xt, int MAOrder, int period) {
        this(Xt, MADecomposition.b(MAOrder), period);
    }
}

