/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.univariate.sample;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.descriptive.moment.Mean;
import com.numericalmethod.suanshu.stats.timeseries.linear.univariate.AutoCovarianceFunction;
import com.numericalmethod.suanshu.stats.timeseries.univariate.realtime.TimeSeries;

public class AutoCovariance
extends AutoCovarianceFunction {
    private final Type k;
    private final TimeSeries L;
    private final double E;

    public AutoCovariance(TimeSeries xt, Type type) {
        this.L = xt;
        this.k = type;
        Mean a2 = new Mean(xt.toArray());
        this.E = a2.value();
    }

    public AutoCovariance(TimeSeries xt) {
        this(xt, Type.TYPE_I);
    }

    @Override
    public double evaluate(double x1, double x2) {
        return this.evaluate(Math.round((float)Math.abs(x1 - x2)));
    }

    public double evaluate(int k) {
        int a2;
        SuanShuUtils.assertArgument(k < this.L.size(), "lag must be < lenght of the time series", new Object[0]);
        int a3 = this.L.size();
        double a4 = 0.0;
        int n = a2 = 1;
        while (n <= a3 - k) {
            a4 += (this.L.get(a2) - this.E) * (this.L.get(a2 + k) - this.E);
            n = ++a2;
        }
        double a22 = a4;
        a22 = this.k == Type.TYPE_II ? (a22 /= (double)(a3 - k)) : (a22 /= (double)a3);
        return a22;
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type TYPE_I = new Type();
        private static final /* synthetic */ Type[] E;
        public static final /* enum */ Type TYPE_II = new Type();

        public static Type[] values() {
            return (Type[])E.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        static {
            Type[] typeArray = new Type[2];
            typeArray[0] = TYPE_I;
            typeArray[1] = TYPE_II;
            E = typeArray;
        }

        private Type() {
            Type a2;
        }
    }
}

