/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.univariate.arima;

import com.numericalmethod.suanshu.license.Package;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.arma.ARMAXModel;
import java.util.Arrays;

public class ARIMAXModel {
    private final int E;
    public final double[] MA;
    public final double sigma;
    public final double[] AR;
    public final double mu;
    public final double[] psi;

    public double mu() {
        return this.mu;
    }

    public int q() {
        return this.MA != null ? this.MA.length : 0;
    }

    public int p() {
        return this.AR != null ? this.AR.length : 0;
    }

    public double[] MA() {
        return this.MA != null ? Arrays.copyOf(this.MA, this.MA.length) : null;
    }

    public ARIMAXModel(double mu, double[] AR, int d2, double[] MA, double[] psi) {
        this(mu, AR, d2, MA, psi, 1.0);
    }

    public double sigma() {
        return this.sigma;
    }

    public ARIMAXModel(ARIMAXModel that) {
        this.mu = that.mu;
        this.AR = that.AR != null ? Arrays.copyOf(that.AR, that.AR.length) : null;
        this.MA = that.MA != null ? Arrays.copyOf(that.MA, that.MA.length) : null;
        this.psi = that.psi != null ? Arrays.copyOf(that.psi, that.psi.length) : null;
        this.E = that.E;
        this.sigma = that.sigma;
    }

    public ARIMAXModel(double[] AR, int d2, double[] MA, double[] psi, double sigma) {
        this(0.0, AR, d2, MA, psi, sigma);
    }

    static {
        Package.getInstance("STATS").isValidated();
    }

    public double MA(int i2) {
        return i2 == 0 ? 1.0 : this.MA[i2 - 1];
    }

    public ARIMAXModel(double mu, double[] AR, int d2, double[] MA, double[] psi, double sigma) {
        SuanShuUtils.assertArgument(AR != null || MA != null, "at least one of AR and MA terms cannot be null", new Object[0]);
        SuanShuUtils.assertArgument(d2 >= 0, "d >= 0", new Object[0]);
        SuanShuUtils.assertArgument(sigma >= 0.0, "sigma >= 0", new Object[0]);
        this.mu = mu;
        this.AR = AR != null ? Arrays.copyOf(AR, AR.length) : null;
        this.MA = MA != null ? Arrays.copyOf(MA, MA.length) : null;
        this.psi = psi != null ? Arrays.copyOf(psi, psi.length) : null;
        this.E = d2;
        this.sigma = sigma;
    }

    public double[] psi() {
        return this.psi != null ? Arrays.copyOf(this.psi, this.psi.length) : null;
    }

    public ARMAXModel getArmax() {
        return new ARMAXModel(this.mu, this.AR, this.MA, this.psi, this.sigma);
    }

    public int maxPQ() {
        return Math.max(this.p(), this.q());
    }

    public ARIMAXModel(double[] AR, int d2, double[] MA, double[] psi) {
        this(0.0, AR, d2, MA, psi, 1.0);
    }

    public int d() {
        return this.E;
    }

    public double[] AR() {
        return this.AR != null ? Arrays.copyOf(this.AR, this.AR.length) : null;
    }

    public String toString() {
        int a2;
        StringBuilder a3 = new StringBuilder();
        a3.append("Xt = ");
        a3.append(this.mu);
        a3.append(" + (");
        if (this.AR != null) {
            int n = a2 = 0;
            while (n < this.AR.length) {
                a3.append(this.AR[a2]);
                Object[] objectArray = new Object[1];
                objectArray[0] = a2 + 1;
                a3.append(String.format("*X_{t-%d}", objectArray));
                n = ++a2;
            }
        }
        a3.append(") ");
        a3.append(" + (");
        if (this.MA != null) {
            int n = a2 = 0;
            while (n < this.MA.length) {
                a3.append(this.MA[a2]);
                Object[] objectArray = new Object[1];
                objectArray[0] = a2 + 1;
                a3.append(String.format("*e_{t-%d}", objectArray));
                n = ++a2;
            }
        }
        a3.append(") ");
        a3.append(" + (");
        if (this.psi != null) {
            int n = a2 = 0;
            while (n < this.psi.length) {
                a3.append(this.psi[a2]);
                Object[] objectArray = new Object[1];
                objectArray[0] = a2;
                a3.append(String.format("*D_{t-%d}", objectArray));
                n = ++a2;
            }
        }
        a3.append(") ");
        a3.append(" + e_t");
        Object[] objectArray = new Object[2];
        objectArray[0] = this.sigma;
        objectArray[1] = this.E;
        a3.append(String.format("; var(e_t) = %f, d = %d", objectArray));
        return a3.toString();
    }

    public double AR(int i2) {
        return i2 == 0 ? 1.0 : this.AR[i2 - 1];
    }
}

