/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.univariate.arima;

import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.signalprocessing.Innovations;
import com.numericalmethod.suanshu.stats.timeseries.linear.univariate.arima.ARIMAModel;
import com.numericalmethod.suanshu.stats.timeseries.univariate.realtime.SimpleTimeSeries;
import java.util.Arrays;

public class ARIMASim
extends SimpleTimeSeries {
    public ARIMASim(int n, ARIMAModel arima) {
        this(n, arima, new Innovations(n + arima.maxPQ() + arima.d()));
    }

    public ARIMASim(int n, ARIMAModel arima, Innovations innovations) {
        super(ARIMASim.b(n, arima, innovations));
    }

    private static double[] b(int a2, ARIMAModel a3, Innovations a4) {
        int a5;
        int a6;
        int a7 = a3.maxPQ();
        SuanShuUtils.assertArgument(a2 > a7, "time series length > max(p, q)", new Object[0]);
        int a8 = a2 + a7 + a3.d();
        double[] a9 = a4.toArray(a8);
        double[] a10 = new double[a8];
        int n = a6 = a7;
        while (n < a8) {
            int a11;
            int a12;
            double[] a13 = new double[a3.p()];
            int n2 = a12 = 1;
            while (n2 <= a3.p()) {
                a13[a12 - 1] = a10[a6 - a12];
                n2 = ++a12;
            }
            double[] a22 = new double[a3.q()];
            int n3 = a11 = 1;
            while (n3 <= a3.q()) {
                a22[a11 - 1] = a9[a6 - a11];
                n3 = ++a11;
            }
            a10[a6] = a3.getArma().armaMean(a13, a22) + a9[a6];
            n = ++a6;
        }
        double[] a32 = a10;
        int n4 = a5 = 1;
        while (n4 <= a3.d()) {
            a32 = R.cumsum(a32);
            n4 = ++a5;
        }
        double[] a42 = Arrays.copyOfRange(a32, a32.length - a2, a32.length);
        return a42;
    }
}

