/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.stationaryprocess.arma;

import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

public class VECM {
    private final ImmutableMatrix G;
    private final ImmutableMatrix[] F;
    private final ImmutableMatrix k;
    private final ImmutableVector L;
    private final ImmutableMatrix E;

    public ImmutableMatrix pi() {
        return this.G;
    }

    public ImmutableMatrix gamma(int i2) {
        return i2 <= 0 ? null : this.F[i2 - 1];
    }

    public int dimension() {
        return this.L.size();
    }

    public ImmutableMatrix sigma() {
        return this.k;
    }

    public VECM(Vector mu, Matrix pi, Matrix[] gamma, Matrix psi, Matrix sigma) {
        this.L = new ImmutableVector(mu);
        int a2 = mu.size();
        SuanShuUtils.assertArgument(pi.nRows() == a2 && pi.nCols() == a2, "pi should be a square matrix of the correct dimension", new Object[0]);
        this.G = new ImmutableMatrix(pi);
        ImmutableMatrix[] immutableMatrixArray = gamma != null ? new ImmutableMatrix[gamma.length] : (this.F = null);
        if (gamma != null) {
            int a3;
            int n = a3 = 0;
            while (n < gamma.length) {
                SuanShuUtils.assertArgument(gamma[a3].nRows() == a2 && gamma[a3].nCols() == a2, "each gamma should be a square matrix of the correct dimension", new Object[0]);
                this.F[a3] = new ImmutableMatrix(gamma[a3]);
                n = ++a3;
            }
        }
        ImmutableMatrix immutableMatrix = this.E = psi != null ? new ImmutableMatrix(psi) : null;
        if (psi != null) {
            SuanShuUtils.assertArgument(psi.nRows() == a2, "number of rows of psi should be the same as the dimension of the multivariate ARIMA model", new Object[0]);
        }
        SuanShuUtils.assertArgument(sigma.nRows() == a2 && sigma.nCols() == a2, "sigma should be a square matrix of the correct dimension", new Object[0]);
        this.k = new ImmutableMatrix(sigma);
    }

    public ImmutableMatrix psi() {
        return this.E != null ? this.E : null;
    }

    public VECM(VECM that) {
        this.L = new ImmutableVector(new DenseVector(that.L));
        this.G = new ImmutableMatrix(new DenseMatrix(that.G));
        this.F = Arrays.copyOf(that.F, that.F.length);
        this.E = that.E != null ? new ImmutableMatrix(new DenseMatrix(that.E)) : null;
        this.k = new ImmutableMatrix(new DenseMatrix(that.k));
    }

    public int p() {
        return this.F != null ? this.F.length + 1 : 1;
    }

    public ImmutableVector mu() {
        return this.L;
    }
}

