/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.stationaryprocess.arma;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.AutoCorrelationFunction;
import com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.arima.ARIMAModel;
import com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.stationaryprocess.arma.AutoCovariance;

public class AutoCorrelation
extends AutoCorrelationFunction {
    private final AutoCovariance E;

    public AutoCorrelation(ARIMAModel model, int nLags) {
        this.E = new AutoCovariance(model, nLags);
    }

    @Override
    public Matrix evaluate(double x1, double x2) {
        return this.evaluate(Math.abs(x2 - x1));
    }

    public Matrix evaluate(double lag) {
        int a2;
        Matrix a3 = this.E.evaluate(lag);
        Matrix a4 = this.E.evaluate(0.0);
        int a5 = a3.nRows();
        int a6 = a3.nCols();
        DenseMatrix a7 = new DenseMatrix(a5, a6);
        int n = a2 = 1;
        while (n <= a5) {
            int a8;
            int n2 = a8 = 1;
            while (n2 <= a6) {
                a7.set(a2, a8, a3.get(a2, a8) / Math.sqrt(a4.get(a2, a2) * a4.get(a8, a8)));
                n2 = ++a8;
            }
            n = ++a2;
        }
        return a7;
    }
}

