/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.stationaryprocess;

import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.AutoCovarianceFunction;
import com.numericalmethod.suanshu.stats.timeseries.multivariate.realtime.MultiVariateTimeSeries;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public abstract class InnovationAlgorithmImpl {
    private Matrix[][] L;
    public MultiVariateTimeSeries XtHat;
    private Matrix[] E;

    public void run(int t, AutoCovarianceFunction K) {
        int a2;
        this.E = new Matrix[t + 1];
        this.L = new Matrix[t + 1][t + 1];
        this.E[0] = K.get(1, 1);
        int n = a2 = 1;
        while (n <= t) {
            int a3;
            int n2 = a3 = 0;
            while (true) {
                int a4;
                if (n2 > a2 - 1) break;
                this.L[a2][a2 - a3] = K.get(a2 + 1, a3 + 1);
                int n3 = a4 = 0;
                while (true) {
                    if (n3 > a3 - 1) break;
                    Matrix a5 = this.L[a2][a2 - a4].multiply(this.E[a4]).multiply(this.L[a3][a3 - a4].t());
                    this.L[a2][a2 - a3] = this.L[a2][a2 - a3].minus(a5);
                    n3 = ++a4;
                }
                this.L[a2][a2 - a3] = this.L[a2][a2 - a3].multiply(new Inverse(this.E[a3]));
                n2 = ++a3;
            }
            this.E[a2] = K.get(a2 + 1, a2 + 1);
            int n4 = a3 = 0;
            while (true) {
                if (n4 > a2 - 1) break;
                Matrix a6 = this.L[a2][a2 - a3].multiply(this.E[a3]).multiply(this.L[a2][a2 - a3].t());
                this.E[a2] = this.E[a2].minus(a6);
                n4 = ++a3;
            }
            n = ++a2;
        }
    }

    public ImmutableMatrix theta(int i2, int j) {
        return new ImmutableMatrix(this.L[i2][j]);
    }

    public ImmutableMatrix covariance(int t) {
        return new ImmutableMatrix(this.E[t]);
    }

    public ImmutableVector XtHat(int t) {
        Vector a2 = t != 0 ? this.XtHat.get(t) : new DenseVector(this.XtHat.dimension(), 0.0);
        return new ImmutableVector(a2);
    }

    public MultiVariateTimeSeries XtHat() {
        return this.XtHat;
    }
}

