/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.variance;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.number.DoubleArrayMath;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.descriptive.moment.Mean;
import com.numericalmethod.suanshu.stats.descriptive.moment.Variance;
import com.numericalmethod.suanshu.stats.descriptive.rank.Quantile;
import com.numericalmethod.suanshu.stats.distribution.univariate.FDistribution;
import com.numericalmethod.suanshu.stats.test.HypothesisTest;

public class Levene
extends HypothesisTest {
    public final double df1;
    public final double df2;

    @Override
    public String getAlternativeHypothesis() {
        return "at least two variances are different";
    }

    public Levene(double ... samples) {
        double[][] dArrayArray = new double[1][];
        dArrayArray[0] = samples;
        this(Type.MEDIAN, (double[][])dArrayArray);
    }

    private double[] k(double[] ... a2) {
        Levene a3;
        int a4;
        double[] a5 = new double[a2.length];
        int n = a4 = 0;
        while (n < a3.k) {
            a5[a4] = new Mean(a2[a4]).value();
            n = ++a4;
        }
        return a5;
    }

    private double[] m(double[] ... a2) {
        Levene a3;
        int a4;
        double[] a5 = new double[a2.length];
        int n = a4 = 0;
        while (n < a3.k) {
            final double a6 = new Quantile(a2[a4], Quantile.QuantileType.APPROXIMATELY_MEDIAN_UNBIASED).value(0.025);
            final double a7 = new Quantile(a2[a4], Quantile.QuantileType.APPROXIMATELY_MEDIAN_UNBIASED).value(0.975);
            double[] a8 = R.select(a2[a4], new R.which(){
                {
                    2 a2;
                }

                @Override
                public boolean isTrue(double x, int index) {
                    return x >= a6 && x <= a7;
                }
            });
            a5[a4] = new Mean(a8).value();
            n = ++a4;
        }
        return a5;
    }

    public Levene(Type type, double[] ... samples) {
        super(samples);
        int a2;
        int a3;
        final double[] a4 = type == Type.MEANS ? this.k(samples) : (type == Type.TRIMMED_MEANS ? this.m(samples) : this.b(samples));
        double[][] a5 = new double[this.k][];
        int n = a3 = 0;
        while (n < this.k) {
            final int a6 = a3;
            a5[a3] = DoubleUtils.foreach(samples[a3], new UnivariateRealFunction(){
                {
                    1 a2;
                }

                @Override
                public double evaluate(double x) {
                    return Math.abs(x - a4[a6]);
                }
            });
            n = ++a3;
        }
        double a22 = DoubleArrayMath.sum(DoubleUtils.concat(a5)) / (double)this.N;
        double a7 = 0.0;
        double a8 = 0.0;
        int n2 = a2 = 0;
        while (n2 < this.k) {
            double a9 = new Mean(a5[a2]).value();
            a7 += (double)samples[a2].length * Math.pow(a9 - a22, 2.0);
            double a10 = new Variance(a5[a2]).value();
            a8 += (double)(samples[a2].length - 1) * a10;
            n2 = ++a2;
        }
        this.testStatistics = a7 / a8 * (double)(this.N - this.k) / (double)(this.k - 1);
        this.df1 = this.k - 1;
        this.df2 = this.N - this.k;
        FDistribution a32 = new FDistribution(this.df1, this.df2);
        this.pValue = Levene.oneSidedPvalue(a32, this.testStatistics);
    }

    @Override
    public String getNullHypothesis() {
        return "all population variances are equal";
    }

    private double[] b(double[] ... a2) {
        Levene a3;
        int a4;
        double[] a5 = new double[a2.length];
        int n = a4 = 0;
        while (n < a3.k) {
            Quantile a6 = new Quantile(a2[a4]);
            a5[a4] = a6.value(0.5);
            n = ++a4;
        }
        return a5;
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type MEDIAN = new Type();
        public static final /* enum */ Type MEANS = new Type();
        private static final /* synthetic */ Type[] E;
        public static final /* enum */ Type TRIMMED_MEANS = new Type();

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        static {
            Type[] typeArray = new Type[3];
            typeArray[0] = MEDIAN;
            typeArray[1] = MEANS;
            typeArray[2] = TRIMMED_MEANS;
            E = typeArray;
        }

        public static Type[] values() {
            return (Type[])E.clone();
        }

        private Type() {
            Type a2;
        }
    }
}

