/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.variance;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.descriptive.moment.Variance;
import com.numericalmethod.suanshu.stats.distribution.univariate.FDistribution;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;
import com.numericalmethod.suanshu.stats.test.HypothesisTest;

public class F
extends HypothesisTest {
    public final double df2;
    public final double pValue1SidedLess;
    public final double df1;
    public final UnivariateDistribution F;
    public final double pValue1SidedGreater;
    public final double estimate;

    public F(double[] sample1, double[] sample2) {
        this(sample1, sample2, 1.0);
    }

    public F(double[] sample1, double[] sample2, double ratio) {
        double[][] dArrayArray = new double[2][];
        dArrayArray[0] = sample1;
        dArrayArray[1] = sample2;
        super(dArrayArray);
        double a2 = new Variance(sample1).value();
        double a3 = new Variance(sample2).value();
        this.estimate = a2 / a3;
        this.testStatistics = this.estimate / ratio;
        this.df1 = sample1.length - 1;
        this.df2 = sample2.length - 1;
        this.F = new FDistribution(this.df1, this.df2);
        this.pValue1SidedGreater = com.numericalmethod.suanshu.stats.test.variance.F.oneSidedPvalue(this.F, this.testStatistics);
        this.pValue1SidedLess = 1.0 - this.pValue1SidedGreater;
        this.pValue = 2.0 * Math.min(this.pValue1SidedGreater, this.pValue1SidedLess);
    }

    @Override
    public String getAlternativeHypothesis() {
        return "the two samples have different variances";
    }

    public double leftConfidenceInterval(double confidence) {
        SuanShuUtils.assertArgument(0.0 < confidence && confidence < 1.0, "0 < confidence level < 1", new Object[0]);
        return this.estimate / this.F.quantile(1.0 - confidence);
    }

    public double[] confidenceInterval(double confidence) {
        SuanShuUtils.assertArgument(0.0 < confidence && confidence < 1.0, "0 < confidence level < 1", new Object[0]);
        double[] dArray = new double[2];
        double[] a2 = dArray;
        dArray[0] = this.estimate / this.F.quantile(confidence);
        a2[1] = this.estimate / this.F.quantile(1.0 - confidence);
        return a2;
    }

    @Override
    public String getNullHypothesis() {
        return "the two normal populations have the same variance";
    }

    public double rightConfidenceInterval(double confidence) {
        SuanShuUtils.assertArgument(0.0 < confidence && confidence < 1.0, "0 < confidence level < 1", new Object[0]);
        return this.estimate / this.F.quantile(confidence);
    }
}

